/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.wicket.PageRegistration;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.panels.DropDownMenu;
import com.gitblit.wicket.panels.LinkPanel;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class NavigationPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public NavigationPanel(String id, final Class<? extends BasePage> pageClass, List<PageRegistration> registeredPages) {
        super(id);
        ListDataProvider refsDp = new ListDataProvider(registeredPages);
        DataView<PageRegistration> refsView = new DataView<PageRegistration>("navLink", (IDataProvider)refsDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<PageRegistration> item) {
                PageRegistration entry = (PageRegistration)item.getModelObject();
                if (entry instanceof PageRegistration.OtherPageLink) {
                    PageRegistration.OtherPageLink link = (PageRegistration.OtherPageLink)entry;
                    LinkPanel c = new LinkPanel("link", null, this.getString(entry.translationKey), link.url);
                    c.setRenderBodyOnly(true);
                    item.add(new Component[]{c});
                } else if (entry instanceof PageRegistration.DropDownMenuRegistration) {
                    PageRegistration.DropDownMenuRegistration reg = (PageRegistration.DropDownMenuRegistration)entry;
                    DropDownMenu c = new DropDownMenu("link", this.getString(entry.translationKey), reg);
                    c.setRenderBodyOnly(true);
                    item.add(new Component[]{c});
                    WicketUtils.setCssClass(item, "dropdown");
                } else {
                    LinkPanel c = new LinkPanel("link", null, this.getString(entry.translationKey), entry.pageClass, entry.params);
                    c.setRenderBodyOnly(true);
                    if (entry.pageClass.equals(pageClass)) {
                        WicketUtils.setCssClass(item, "active");
                    }
                    item.add(new Component[]{c});
                }
            }
        };
        this.add(new Component[]{refsView});
    }
}

