/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.SyndicationServlet;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.DocsPage;
import com.gitblit.wicket.pages.EditRepositoryPage;
import com.gitblit.wicket.pages.LogPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.TicketsPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.RepositoryUrlPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.Localizer;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;

public class ProjectRepositoryPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;

    public ProjectRepositoryPanel(String wicketId, Localizer localizer, Component parent, boolean isAdmin, final RepositoryModel entry, Map<Constants.AccessRestrictionType, String> accessRestrictions) {
        super(wicketId);
        Fragment repositoryLinks;
        boolean showAdmin;
        Label swatch;
        boolean showSwatch = GitBlit.getBoolean("web.repositoryListSwatches", true);
        boolean gitServlet = GitBlit.getBoolean("git.enableGitServlet", true);
        boolean showSize = GitBlit.getBoolean("web.showRepositorySizes", true);
        if (entry.isBare) {
            swatch = new Label("repositorySwatch", "&nbsp;").setEscapeModelStrings(false);
        } else {
            swatch = new Label("repositorySwatch", "!");
            WicketUtils.setHtmlTooltip((Component)swatch, localizer.getString("gb.workingCopyWarning", parent));
        }
        WicketUtils.setCssBackground((Component)swatch, entry.toString());
        this.add(new Component[]{swatch});
        swatch.setVisible(showSwatch);
        PageParameters pp = WicketUtils.newRepositoryParameter(entry.name);
        this.add(new Component[]{new LinkPanel("repositoryName", "list", StringUtils.getRelativePath(entry.projectPath, StringUtils.stripDotGit(entry.name)), SummaryPage.class, pp)});
        this.add(new Component[]{new Label("repositoryDescription", entry.description).setVisible(!StringUtils.isEmpty(entry.description))});
        if (StringUtils.isEmpty(entry.originRepository)) {
            this.add(new Component[]{new Label("originRepository").setVisible(false)});
        } else {
            Fragment forkFrag = new Fragment("originRepository", "originFragment", (MarkupContainer)this);
            forkFrag.add(new Component[]{new LinkPanel("originRepository", null, StringUtils.stripDotGit(entry.originRepository), SummaryPage.class, WicketUtils.newRepositoryParameter(entry.originRepository))});
            this.add(new Component[]{forkFrag});
        }
        this.add(new Component[]{new BookmarkablePageLink("tickets", TicketsPage.class, pp).setVisible(entry.useTickets)});
        this.add(new Component[]{new BookmarkablePageLink("docs", DocsPage.class, pp).setVisible(entry.useDocs)});
        if (entry.isFrozen) {
            this.add(new Component[]{WicketUtils.newImage("frozenIcon", "cold_16x16.png", localizer.getString("gb.isFrozen", parent))});
        } else {
            this.add(new Component[]{WicketUtils.newClearPixel("frozenIcon").setVisible(false)});
        }
        if (entry.isFederated) {
            this.add(new Component[]{WicketUtils.newImage("federatedIcon", "federated_16x16.png", localizer.getString("gb.isFederated", parent))});
        } else {
            this.add(new Component[]{WicketUtils.newClearPixel("federatedIcon").setVisible(false)});
        }
        switch (entry.accessRestriction) {
            case NONE: {
                this.add(new Component[]{WicketUtils.newBlankImage("accessRestrictionIcon").setVisible(false)});
                break;
            }
            case PUSH: {
                this.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "lock_go_16x16.png", accessRestrictions.get((Object)entry.accessRestriction))});
                break;
            }
            case CLONE: {
                this.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "lock_pull_16x16.png", accessRestrictions.get((Object)entry.accessRestriction))});
                break;
            }
            case VIEW: {
                this.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "shield_16x16.png", accessRestrictions.get((Object)entry.accessRestriction))});
                break;
            }
            default: {
                this.add(new Component[]{WicketUtils.newBlankImage("accessRestrictionIcon")});
            }
        }
        if (StringUtils.isEmpty(entry.owner)) {
            this.add(new Component[]{new Label("repositoryOwner").setVisible(false)});
        } else {
            UserModel ownerModel = GitBlit.self().getUserModel(entry.owner);
            String owner = entry.owner;
            if (ownerModel != null) {
                owner = ownerModel.getDisplayName();
            }
            this.add(new Component[]{new Label("repositoryOwner", owner + " (" + localizer.getString("gb.owner", parent) + ")")});
        }
        UserModel user = GitBlitWebSession.get().getUser();
        if (user == null) {
            user = UserModel.ANONYMOUS;
        }
        boolean showOwner = entry.isOwner(user.username);
        boolean bl = showAdmin = isAdmin || entry.isUsersPersonalRepository(user.username);
        if (showAdmin || showOwner) {
            repositoryLinks = new Fragment("repositoryLinks", showAdmin ? "repositoryAdminLinks" : "repositoryOwnerLinks", (MarkupContainer)this);
            repositoryLinks.add(new Component[]{new BookmarkablePageLink("editRepository", EditRepositoryPage.class, WicketUtils.newRepositoryParameter(entry.name))});
            if (showAdmin) {
                Link<Void> deleteLink = new Link<Void>("deleteRepository"){
                    private static final long serialVersionUID = 1L;

                    public void onClick() {
                        if (GitBlit.self().deleteRepositoryModel(entry)) {
                            if (entry.isPersonalRepository()) {
                                this.setResponsePage(this.getPage().getClass(), WicketUtils.newUsernameParameter(entry.projectPath.substring(1)));
                            } else {
                                this.setResponsePage(this.getPage().getClass(), WicketUtils.newProjectParameter(entry.projectPath));
                            }
                        } else {
                            this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.repositoryDeleteFailed"), entry)));
                        }
                    }
                };
                deleteLink.add(new IBehavior[]{new BasePanel.JavascriptEventConfirmation("onclick", MessageFormat.format(localizer.getString("gb.deleteRepository", parent), entry))});
                repositoryLinks.add(new Component[]{deleteLink});
            }
        } else {
            repositoryLinks = new Fragment("repositoryLinks", "repositoryUserLinks", (MarkupContainer)this);
        }
        repositoryLinks.add(new Component[]{new BookmarkablePageLink("tree", TreePage.class, WicketUtils.newRepositoryParameter(entry.name)).setEnabled(entry.hasCommits)});
        repositoryLinks.add(new Component[]{new BookmarkablePageLink("log", LogPage.class, WicketUtils.newRepositoryParameter(entry.name)).setEnabled(entry.hasCommits)});
        this.add(new Component[]{repositoryLinks});
        String lastChange = entry.lastChange.getTime() == 0L ? "--" : this.getTimeUtils().timeAgo(entry.lastChange);
        Label lastChangeLabel = new Label("repositoryLastChange", lastChange);
        this.add(new Component[]{lastChangeLabel});
        WicketUtils.setCssClass((Component)lastChangeLabel, this.getTimeUtils().timeAgoCss(entry.lastChange));
        if (entry.hasCommits) {
            this.add(new Component[]{new Label("repositorySize", entry.size).setVisible(showSize)});
        } else {
            this.add(new Component[]{new Label("repositorySize", localizer.getString("gb.empty", parent)).setEscapeModelStrings(false)});
        }
        this.add(new Component[]{new ExternalLink("syndication", SyndicationServlet.asLink("", entry.name, null, 0))});
        ArrayList<String> repositoryUrls = new ArrayList<String>();
        if (gitServlet) {
            repositoryUrls.add(BasePage.getRepositoryUrl(entry));
        }
        repositoryUrls.addAll(GitBlit.self().getOtherCloneUrls(entry.name));
        String primaryUrl = ArrayUtils.isEmpty(repositoryUrls) ? "" : (String)repositoryUrls.remove(0);
        this.add(new Component[]{new RepositoryUrlPanel("repositoryCloneUrl", primaryUrl)});
    }
}

