/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.wicket.panels.ObjectContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Response;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.util.value.IValueMap;

public class ShockWaveComponent
extends ObjectContainer {
    private static final long serialVersionUID = 1L;
    private static final String CONTENTTYPE = "application/x-shockwave-flash";
    private static final String CLSID = "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000";
    private static final String CODEBASE = "http://fpdownload.adobe.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0";
    private static final List<String> attributeNames = Arrays.asList("classid", "width", "height", "codebase", "align", "base", "data", "flashvars");
    private static final List<String> parameterNames = Arrays.asList("devicefont", "movie", "play", "loop", "quality", "bgcolor", "scale", "salign", "menu", "wmode", "allowscriptaccess", "seamlesstabbing", "flashvars");
    private static final List<String> optionNames = new ArrayList<String>(attributeNames.size() + parameterNames.size());
    private Map<String, String> attributes = new HashMap<String, String>();
    private Map<String, String> parameters = new HashMap<String, String>();

    public ShockWaveComponent(String id) {
        super(id);
    }

    public ShockWaveComponent(String id, String movie) {
        this(id);
        this.setValue("movie", movie);
    }

    public ShockWaveComponent(String id, String movie, String width, String height) {
        this(id);
        this.setValue("movie", movie);
        this.setValue("width", width);
        this.setValue("height", height);
    }

    @Override
    public void setValue(String name, String value) {
        String parameter = name.toLowerCase();
        if ("data".equals(parameter)) {
            parameter = "movie";
        }
        if ("movie".equals(parameter) && !this.getClientProperties().isBrowserInternetExplorer()) {
            this.attributes.put("data", value);
        }
        if (attributeNames.contains(parameter)) {
            this.attributes.put(parameter, value);
        } else if (parameterNames.contains(parameter)) {
            this.parameters.put(parameter, value);
        }
    }

    @Override
    public String getValue(String name) {
        String parameter = name.toLowerCase();
        String value = null;
        if ("data".equals(parameter)) {
            if (this.getClientProperties().isBrowserInternetExplorer()) {
                return null;
            }
            parameter = "movie";
        }
        if (attributeNames.contains(parameter)) {
            value = this.attributes.get(parameter);
        } else if (parameterNames.contains(parameter)) {
            value = this.parameters.get(parameter);
        }
        if (value != null && parameter.equals("movie")) {
            value = this.resolveResource(value);
        }
        return value;
    }

    @Override
    public void onComponentTag(ComponentTag tag) {
        IValueMap valueMap = tag.getAttributes();
        for (String s : optionNames) {
            if (!valueMap.containsKey((Object)s)) continue;
            if (!this.attributes.containsKey(s) && !this.parameters.containsKey(s)) {
                this.setValue(s, valueMap.getString(s));
            }
            valueMap.remove((Object)s);
        }
        super.onComponentTag(tag);
    }

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        String value;
        super.onComponentTagBody(markupStream, openTag);
        Response response = this.getResponse();
        response.write((CharSequence)"<embed");
        this.addParameter(response, "type", CONTENTTYPE);
        for (String name : this.getParameterNames()) {
            value = this.getValue(name);
            if (value == null) continue;
            name = "movie".equals(name) ? "src" : name;
            this.addParameter(response, name, value);
        }
        for (String name : this.getAttributeNames()) {
            if (!"width".equals(name) && !"height".equals(name) || (value = this.getValue(name)) == null) continue;
            this.addParameter(response, name, value);
        }
        response.write((CharSequence)" />\n");
    }

    private void addParameter(Response response, String name, String value) {
        response.write((CharSequence)" ");
        response.write((CharSequence)name);
        response.write((CharSequence)"=\"");
        response.write((CharSequence)value);
        response.write((CharSequence)"\"");
    }

    @Override
    protected String getClsid() {
        return CLSID;
    }

    @Override
    protected String getCodebase() {
        return CODEBASE;
    }

    @Override
    protected String getContentType() {
        return CONTENTTYPE;
    }

    @Override
    protected List<String> getAttributeNames() {
        return attributeNames;
    }

    @Override
    protected List<String> getParameterNames() {
        return parameterNames;
    }

    static {
        optionNames.addAll(attributeNames);
        optionNames.addAll(parameterNames);
    }
}

