/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.GitBlit;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.EditUserPage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class UsersPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;

    public UsersPanel(String wicketId, boolean showAdmin) {
        super(wicketId);
        Fragment adminLinks = new Fragment("adminPanel", "adminLinks", (MarkupContainer)this);
        adminLinks.add(new Component[]{new BookmarkablePageLink("newUser", EditUserPage.class).setVisible(GitBlit.self().supportsCredentialChanges())});
        this.add(new Component[]{adminLinks.setVisible(showAdmin)});
        final List<UserModel> users = GitBlit.self().getAllUsers();
        DataView<UserModel> usersView = new DataView<UserModel>("userRow", (IDataProvider)new ListDataProvider(users)){
            private static final long serialVersionUID = 1L;
            private int counter;

            protected void onBeforeRender() {
                super.onBeforeRender();
                this.counter = 0;
            }

            public void populateItem(Item<UserModel> item) {
                final UserModel entry = (UserModel)item.getModelObject();
                LinkPanel editLink = new LinkPanel("username", "list", entry.username, EditUserPage.class, WicketUtils.newUsernameParameter(entry.username));
                WicketUtils.setHtmlTooltip((Component)editLink, this.getString("gb.edit") + " " + entry.getDisplayName());
                item.add(new Component[]{editLink});
                if (StringUtils.isEmpty(entry.displayName)) {
                    item.add(new Component[]{new Label("displayName").setVisible(false)});
                } else {
                    editLink = new LinkPanel("displayName", "list", entry.getDisplayName(), EditUserPage.class, WicketUtils.newUsernameParameter(entry.username));
                    WicketUtils.setHtmlTooltip((Component)editLink, this.getString("gb.edit") + " " + entry.getDisplayName());
                    item.add(new Component[]{editLink});
                }
                if (StringUtils.isEmpty(entry.emailAddress)) {
                    item.add(new Component[]{new Label("emailAddress").setVisible(false)});
                } else {
                    editLink = new LinkPanel("emailAddress", "list", entry.emailAddress, EditUserPage.class, WicketUtils.newUsernameParameter(entry.username));
                    WicketUtils.setHtmlTooltip((Component)editLink, this.getString("gb.edit") + " " + entry.getDisplayName());
                    item.add(new Component[]{editLink});
                }
                item.add(new Component[]{new Label("accesslevel", entry.canAdmin() ? "administrator" : "")});
                item.add(new Component[]{new Label("teams", entry.teams.size() > 0 ? "" + entry.teams.size() : "")});
                item.add(new Component[]{new Label("repositories", entry.permissions.size() > 0 ? "" + entry.permissions.size() : "")});
                Fragment userLinks = new Fragment("userLinks", "userAdminLinks", (MarkupContainer)this);
                userLinks.add(new Component[]{new BookmarkablePageLink("editUser", EditUserPage.class, WicketUtils.newUsernameParameter(entry.username))});
                Link<Void> deleteLink = new Link<Void>("deleteUser"){
                    private static final long serialVersionUID = 1L;

                    public void onClick() {
                        if (GitBlit.self().deleteUser(entry.username)) {
                            users.remove(entry);
                            this.info(MessageFormat.format(this.getString("gb.userDeleted"), entry.username));
                        } else {
                            this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.deleteUserFailed"), entry.username)));
                        }
                    }
                };
                deleteLink.add(new IBehavior[]{new BasePanel.JavascriptEventConfirmation("onclick", MessageFormat.format(this.getString("gb.deleteUser"), entry.username))});
                userLinks.add(new Component[]{deleteLink});
                item.add(new Component[]{userLinks});
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{usersView.setVisible(showAdmin)});
    }
}

