/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.nclient.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.wso2.andes.nclient.MessagePartListener;
import org.wso2.andes.nclient.util.ByteBufferMessage;
import org.wso2.andes.nclient.util.MessageListener;
import org.wso2.andes.transport.DeliveryProperties;
import org.wso2.andes.transport.MessageProperties;
import org.wso2.andes.transport.MessageTransfer;
import org.wso2.andes.transport.Struct;

public class MessagePartListenerAdapter
implements MessagePartListener {
    MessageListener _adaptee;
    ByteBufferMessage _currentMsg;

    public MessagePartListenerAdapter(MessageListener listener) {
        this._adaptee = listener;
    }

    public void messageTransfer(MessageTransfer xfr) {
        this._currentMsg = new ByteBufferMessage(xfr.getId());
        for (Struct st : xfr.getHeader().getStructs()) {
            if (st instanceof DeliveryProperties) {
                this._currentMsg.setDeliveryProperties((DeliveryProperties)st);
                continue;
            }
            if (!(st instanceof MessageProperties)) continue;
            this._currentMsg.setMessageProperties((MessageProperties)st);
        }
        ByteBuffer body = xfr.getBody();
        if (body == null) {
            body = ByteBuffer.allocate(0);
        }
        try {
            this._currentMsg.appendData(body);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._adaptee.onMessage(this._currentMsg);
    }
}

