/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.network.security.sasl;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.sasl.SaslException;
import org.wso2.andes.transport.Sender;
import org.wso2.andes.transport.SenderException;
import org.wso2.andes.transport.network.security.sasl.SASLEncryptor;
import org.wso2.andes.transport.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SASLSender
extends SASLEncryptor
implements Sender<ByteBuffer> {
    protected Sender<ByteBuffer> delegate;
    private byte[] appData;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private static final Logger log = Logger.get(SASLSender.class);

    public SASLSender(Sender<ByteBuffer> delegate) {
        this.delegate = delegate;
        log.debug("SASL Sender enabled", new Object[0]);
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.delegate.close();
            if (this.isSecurityLayerEstablished()) {
                try {
                    this.saslClient.dispose();
                }
                catch (SaslException e) {
                    throw new SenderException("Error closing SASL Sender", e);
                }
            }
        }
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void send(ByteBuffer buf) {
        if (this.closed.get()) {
            throw new SenderException("SSL Sender is closed");
        }
        if (this.isSecurityLayerEstablished()) {
            while (buf.hasRemaining()) {
                int length = Math.min(buf.remaining(), this.sendBuffSize);
                log.debug("sendBuffSize %s", this.sendBuffSize);
                log.debug("buf.remaining() %s", buf.remaining());
                buf.get(this.appData, 0, length);
                try {
                    byte[] out = this.saslClient.wrap(this.appData, 0, length);
                    log.debug("out.length %s", out.length);
                    this.delegate.send(ByteBuffer.wrap(out));
                }
                catch (SaslException e) {
                    log.error("Exception while encrypting data.", e);
                    throw new SenderException("SASL Sender, Error occurred while encrypting data", e);
                }
            }
        } else {
            this.delegate.send(buf);
        }
    }

    @Override
    public void setIdleTimeout(int i) {
        this.delegate.setIdleTimeout(i);
    }

    @Override
    public void securityLayerEstablished() {
        this.appData = new byte[this.sendBuffSize];
        log.debug("SASL Security Layer Established", new Object[0]);
    }
}

