/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.deploy.service;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceUnregisteredCartridgeExceptionException;
import org.apache.stratos.cloud.controller.stub.pojo.CartridgeInfo;
import org.apache.stratos.cloud.controller.stub.pojo.LoadbalancerConfig;
import org.apache.stratos.cloud.controller.stub.pojo.Properties;
import org.apache.stratos.cloud.controller.stub.pojo.Property;
import org.apache.stratos.manager.client.CloudControllerServiceClient;
import org.apache.stratos.manager.deploy.service.Service;
import org.apache.stratos.manager.deploy.service.multitenant.MultiTenantService;
import org.apache.stratos.manager.deploy.service.multitenant.lb.MultiTenantLBService;
import org.apache.stratos.manager.exception.ADCException;
import org.apache.stratos.manager.exception.NotSubscribedException;
import org.apache.stratos.manager.exception.PersistenceManagerException;
import org.apache.stratos.manager.exception.ServiceAlreadyDeployedException;
import org.apache.stratos.manager.exception.UnregisteredCartridgeException;
import org.apache.stratos.manager.lb.category.DefaultLoadBalancerCategory;
import org.apache.stratos.manager.lb.category.ExistingLoadBalancerCategory;
import org.apache.stratos.manager.lb.category.LBDataContext;
import org.apache.stratos.manager.lb.category.LoadBalancerCategory;
import org.apache.stratos.manager.lb.category.ServiceLevelLoadBalancerCategory;
import org.apache.stratos.manager.retriever.DataInsertionAndRetrievalManager;
import org.apache.stratos.manager.subscription.CartridgeSubscription;
import org.apache.stratos.manager.subscription.utils.CartridgeSubscriptionUtils;

public class ServiceDeploymentManager {
    private static Log log = LogFactory.getLog(ServiceDeploymentManager.class);

    public Service deployService(String type, String autoscalingPolicyName, String deploymentPolicyName, int tenantId, String tenantRange, String tenantDomain, String userName) throws ADCException, UnregisteredCartridgeException, ServiceAlreadyDeployedException {
        CartridgeInfo cartridgeInfo;
        Service deployedService;
        DataInsertionAndRetrievalManager dataInsertionAndRetrievalManager = new DataInsertionAndRetrievalManager();
        try {
            deployedService = dataInsertionAndRetrievalManager.getService(type);
        }
        catch (PersistenceManagerException e) {
            String errorMsg = "Error in checking if Service is available is PersistenceManager";
            log.error((Object)errorMsg, (Throwable)e);
            throw new ADCException(errorMsg, e);
        }
        if (deployedService != null) {
            String errorMsg = "There is an already deployed Service for type " + type;
            log.error((Object)errorMsg);
            throw new ServiceAlreadyDeployedException(errorMsg, type);
        }
        try {
            cartridgeInfo = CloudControllerServiceClient.getServiceClient().getCartridgeInfo(type);
        }
        catch (CloudControllerServiceUnregisteredCartridgeExceptionException e) {
            String message = type + " is not a valid cartridgeSubscription type. Please try again with a valid cartridgeSubscription type.";
            log.error((Object)message);
            throw new ADCException(message, e);
        }
        catch (Exception e) {
            String message = "Error getting info for " + type;
            log.error((Object)message, (Throwable)e);
            throw new ADCException(message, e);
        }
        if (!cartridgeInfo.getMultiTenant()) {
            String errorMsg = "Cartridge definition with type " + type + " is not multitenant";
            log.error((Object)errorMsg);
            throw new ADCException(errorMsg);
        }
        LBDataContext lbDataCtxt = null;
        LoadbalancerConfig lbConfig = cartridgeInfo.getLbConfig();
        if (lbConfig == null || lbConfig.getProperties() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("This Service does not require a load balancer. [Service Name] " + type));
            }
        } else {
            lbDataCtxt = CartridgeSubscriptionUtils.getLoadBalancerDataContext(-1234, type, deploymentPolicyName, lbConfig);
            this.deployLBCluster(type, lbDataCtxt, tenantRange);
        }
        MultiTenantService service = new MultiTenantService(type, autoscalingPolicyName, deploymentPolicyName, tenantId, cartridgeInfo, tenantRange);
        Properties serviceClusterProperties = null;
        if (lbDataCtxt.getLoadBalancedServiceProperties() != null && !lbDataCtxt.getLoadBalancedServiceProperties().isEmpty()) {
            serviceClusterProperties = new Properties();
            serviceClusterProperties.setProperties(lbDataCtxt.getLoadBalancedServiceProperties().toArray(new Property[0]));
        }
        service.create();
        service.deploy(serviceClusterProperties);
        this.persist(service);
        return service;
    }

    private void deployLBCluster(String loadBalancedService, LBDataContext lbDataCtxt, String tenantRange) throws ADCException, UnregisteredCartridgeException {
        if (lbDataCtxt.getLbCategory() == null || lbDataCtxt.getLbCategory().equals("no.load.balancer")) {
            return;
        }
        LoadBalancerCategory loadBalancerCategory = null;
        if (lbDataCtxt.getLbCategory().equals("existing.load.balancers")) {
            loadBalancerCategory = new ExistingLoadBalancerCategory();
        } else if (lbDataCtxt.getLbCategory().equals("default.load.balancer")) {
            loadBalancerCategory = new DefaultLoadBalancerCategory();
        } else if (lbDataCtxt.getLbCategory().equals("service.aware.load.balancer")) {
            loadBalancerCategory = new ServiceLevelLoadBalancerCategory();
        }
        if (loadBalancerCategory == null) {
            throw new ADCException("The given Load Balancer category " + lbDataCtxt.getLbCategory() + " not found");
        }
        loadBalancerCategory.setLoadBalancedServiceType(loadBalancedService);
        loadBalancerCategory.setLoadBalancedServiceMultiTenant(true);
        log.info((Object)(" ******* Setting Deployment Policy name : ------>  " + lbDataCtxt.getDeploymentPolicy()));
        loadBalancerCategory.setDeploymentPolicyName(lbDataCtxt.getDeploymentPolicy());
        MultiTenantLBService lbService = new MultiTenantLBService(lbDataCtxt.getLbCartridgeInfo().getType(), lbDataCtxt.getAutoscalePolicy(), lbDataCtxt.getDeploymentPolicy(), -1234, lbDataCtxt.getLbCartridgeInfo(), tenantRange, loadBalancerCategory);
        Properties lbProperties = null;
        if (lbDataCtxt.getLbProperperties() != null && !lbDataCtxt.getLbProperperties().isEmpty()) {
            lbProperties = new Properties();
            lbProperties.setProperties(lbDataCtxt.getLbProperperties().toArray(new Property[0]));
        }
        lbService.create();
        lbService.getPayloadData().add("LB_CATEGORY", lbDataCtxt.getLbCategory());
        ((Service)lbService).deploy(lbProperties);
        this.persist(lbService);
    }

    private void persist(Service service) throws ADCException {
        DataInsertionAndRetrievalManager dataInsertionAndRetrievalManager = new DataInsertionAndRetrievalManager();
        try {
            dataInsertionAndRetrievalManager.persistService(service);
        }
        catch (PersistenceManagerException e) {
            String errorMsg = "Error in persisting Service in PersistenceManager";
            log.error((Object)errorMsg, (Throwable)e);
            throw new ADCException(errorMsg, e);
        }
    }

    public Service getService(String type) throws ADCException {
        try {
            return new DataInsertionAndRetrievalManager().getService(type);
        }
        catch (PersistenceManagerException e) {
            String errorMsg = "Error in getting Service for type " + type;
            log.error((Object)errorMsg, (Throwable)e);
            throw new ADCException(errorMsg, e);
        }
    }

    public Collection<Service> getServices() throws ADCException {
        try {
            return new DataInsertionAndRetrievalManager().getServices();
        }
        catch (PersistenceManagerException e) {
            String errorMsg = "Error in getting deployed Services";
            log.error((Object)errorMsg, (Throwable)e);
            throw new ADCException(errorMsg, e);
        }
    }

    public void undeployService(String type) throws ADCException {
        Service service;
        DataInsertionAndRetrievalManager dataInsertionAndRetrievalManager = new DataInsertionAndRetrievalManager();
        Collection<CartridgeSubscription> cartridgeSubscriptions = dataInsertionAndRetrievalManager.getCartridgeSubscriptions(type);
        if (cartridgeSubscriptions != null && !cartridgeSubscriptions.isEmpty()) {
            String errorMsg = "Cannot undeploy Service since existing Subscriptions are found";
            log.error((Object)errorMsg);
            throw new ADCException(errorMsg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("No subscriptions found for service type: " + type + " , proceeding with undeploying service"));
        }
        try {
            service = dataInsertionAndRetrievalManager.getService(type);
        }
        catch (PersistenceManagerException e) {
            String errorMsg = "Error in checking if Service is available is PersistenceManager";
            log.error((Object)errorMsg, (Throwable)e);
            throw new ADCException(errorMsg, e);
        }
        if (service == null) {
            String errorMsg = "No service found for type " + type;
            log.error((Object)errorMsg);
            throw new ADCException(errorMsg);
        }
        try {
            service.undeploy();
        }
        catch (NotSubscribedException e) {
            String errorMsg = "Undeploying Service Cluster failed for " + type;
            log.error((Object)errorMsg, (Throwable)e);
            throw new ADCException(errorMsg, e);
        }
        try {
            dataInsertionAndRetrievalManager.removeService(type);
        }
        catch (PersistenceManagerException e) {
            String errorMsg = "Error in removing Service from PersistenceManager";
            log.error((Object)errorMsg, (Throwable)e);
            throw new ADCException(errorMsg, e);
        }
    }

    private static Property[] combine(Property[] propertyArray1, Property[] propertyArray2) {
        int length = propertyArray1.length + propertyArray2.length;
        Property[] combinedProperties = new Property[length];
        System.arraycopy(propertyArray1, 0, combinedProperties, 0, propertyArray1.length);
        System.arraycopy(propertyArray2, 0, combinedProperties, propertyArray1.length, propertyArray2.length);
        return combinedProperties;
    }
}

