/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.publisher;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.repository.Repository;
import org.apache.stratos.messaging.broker.publish.EventPublisher;
import org.apache.stratos.messaging.broker.publish.EventPublisherPool;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.event.instance.notifier.ArtifactUpdatedEvent;
import org.apache.stratos.messaging.event.instance.notifier.InstanceCleanupClusterEvent;
import org.apache.stratos.messaging.event.instance.notifier.InstanceCleanupMemberEvent;

public class InstanceNotificationPublisher {
    private static final Log log = LogFactory.getLog(InstanceNotificationPublisher.class);

    private void publish(Event event) {
        EventPublisher depsyncEventPublisher = EventPublisherPool.getPublisher((String)"instance-notifier");
        depsyncEventPublisher.publish(event);
    }

    public void sendArtifactUpdateEvent(Repository repository, String clusterId, String tenantId) {
        ArtifactUpdatedEvent artifactUpdateEvent = new ArtifactUpdatedEvent();
        artifactUpdateEvent.setClusterId(clusterId);
        artifactUpdateEvent.setRepoUserName(repository.getUserName());
        artifactUpdateEvent.setRepoPassword(repository.getPassword());
        artifactUpdateEvent.setRepoURL(repository.getUrl());
        artifactUpdateEvent.setTenantId(tenantId);
        log.info((Object)String.format("Publishing artifact updated event: [cluster] %s [repo-URL] %s [repo-username] %s [repo-password] %s [tenant-id] %s", clusterId, repository.getUrl(), repository.getUserName(), repository.getPassword(), tenantId));
        this.publish((Event)artifactUpdateEvent);
    }

    public void sendInstanceCleanupEventForMember(String memberId) {
        log.info((Object)String.format("Publishing Instance Cleanup Event: [member] %s", memberId));
        this.publish((Event)new InstanceCleanupMemberEvent(memberId));
    }

    public void sendInstanceCleanupEventForCluster(String clusterId) {
        log.info((Object)String.format("Publishing Instance Cleanup Event: [cluster] %s", clusterId));
        this.publish((Event)new InstanceCleanupClusterEvent(clusterId));
    }
}

