/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.publisher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.internal.DataHolder;
import org.apache.stratos.manager.retriever.DataInsertionAndRetrievalManager;
import org.apache.stratos.manager.subscription.CartridgeSubscription;
import org.apache.stratos.messaging.broker.publish.EventPublisher;
import org.apache.stratos.messaging.broker.publish.EventPublisherPool;
import org.apache.stratos.messaging.domain.tenant.Tenant;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.event.tenant.CompleteTenantEvent;
import org.wso2.carbon.ntask.core.Task;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class TenantSynzhronizerTask
implements Task {
    private static final Log log = LogFactory.getLog(TenantSynzhronizerTask.class);

    public void init() {
    }

    public void execute() {
        block8: {
            try {
                org.wso2.carbon.user.api.Tenant[] carbonTenants;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Publishing complete tenant event", new Object[0]));
                }
                ArrayList<Tenant> tenants = new ArrayList<Tenant>();
                TenantManager tenantManager = DataHolder.getRealmService().getTenantManager();
                for (org.wso2.carbon.user.api.Tenant carbonTenant : carbonTenants = tenantManager.getAllTenants()) {
                    Tenant tenant;
                    Collection<CartridgeSubscription> cartridgeSubscriptions;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Tenant found: [tenant-id] %d [tenant-domain] %s", carbonTenant.getId(), carbonTenant.getDomain()));
                    }
                    if ((cartridgeSubscriptions = new DataInsertionAndRetrievalManager().getCartridgeSubscriptions((tenant = new Tenant(carbonTenant.getId(), carbonTenant.getDomain())).getTenantId())) != null && !cartridgeSubscriptions.isEmpty()) {
                        for (CartridgeSubscription subscription : cartridgeSubscriptions) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("Tenant subscription found: [tenant-id] %d [tenant-domain] %s [service] %s", carbonTenant.getId(), carbonTenant.getDomain(), subscription.getType()));
                            }
                            tenant.addServiceSubscription(subscription.getType());
                        }
                    }
                    tenants.add(tenant);
                }
                CompleteTenantEvent event = new CompleteTenantEvent(tenants);
                EventPublisher eventPublisher = EventPublisherPool.getPublisher((String)"tenant");
                eventPublisher.publish((Event)event);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block8;
                log.error((Object)"Could not publish complete tenant event", (Throwable)e);
            }
        }
    }

    public void setProperties(Map<String, String> stringStringMap) {
    }
}

