/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.registry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.internal.DataHolder;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryManager {
    private static final Log log = LogFactory.getLog(RegistryManager.class);
    private static final String STRATOS_MANAGER_REOSURCE = "/stratos_manager";
    private static RegistryService registryService;
    private static volatile RegistryManager registryManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RegistryManager getInstance() {
        if (registryManager != null) return registryManager;
        Class<RegistryManager> clazz = RegistryManager.class;
        synchronized (RegistryManager.class) {
            if (registryManager != null) return registryManager;
            registryManager = new RegistryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return registryManager;
        }
    }

    private RegistryManager() {
        registryService = DataHolder.getRegistryService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private UserRegistry initRegistry(int tenantId) throws RegistryException {
        UserRegistry tenantGovRegistry = registryService.getGovernanceSystemRegistry(tenantId);
        if (tenantGovRegistry.resourceExists(STRATOS_MANAGER_REOSURCE)) return tenantGovRegistry;
        Class<RegistryManager> clazz = RegistryManager.class;
        synchronized (RegistryManager.class) {
            try {
                if (tenantGovRegistry.resourceExists(STRATOS_MANAGER_REOSURCE)) return tenantGovRegistry;
                tenantGovRegistry.put(STRATOS_MANAGER_REOSURCE, (Resource)tenantGovRegistry.newCollection());
            }
            catch (RegistryException e) {
                String errorMsg = "Failed to create the registry resource /stratos_manager";
                log.error((Object)errorMsg, (Throwable)e);
                throw e;
            }
            return tenantGovRegistry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private UserRegistry initRegistry() throws RegistryException {
        UserRegistry govRegistry = registryService.getGovernanceSystemRegistry();
        if (govRegistry.resourceExists(STRATOS_MANAGER_REOSURCE)) return govRegistry;
        Class<RegistryManager> clazz = RegistryManager.class;
        synchronized (RegistryManager.class) {
            try {
                if (govRegistry.resourceExists(STRATOS_MANAGER_REOSURCE)) return govRegistry;
                govRegistry.put(STRATOS_MANAGER_REOSURCE, (Resource)govRegistry.newCollection());
            }
            catch (RegistryException e) {
                String errorMsg = "Failed to create the registry resource /stratos_manager";
                log.error((Object)errorMsg, (Throwable)e);
                throw e;
            }
            return govRegistry;
        }
    }

    public void persist(String path, byte[] resourceBytes, String tag) throws RegistryException {
        UserRegistry registry = this.initRegistry();
        try {
            registry.beginTransaction();
            Resource nodeResource = registry.newResource();
            nodeResource.setContent((Object)resourceBytes);
            registry.put(path, nodeResource);
            if (tag != null) {
                registry.applyTag(path, tag);
            }
            registry.commitTransaction();
        }
        catch (RegistryException e) {
            String errorMsg = "Failed to persist the given resource in registry path " + path;
            log.error((Object)errorMsg, (Throwable)e);
            try {
                registry.rollbackTransaction();
            }
            catch (RegistryException e1) {
                errorMsg = "Failed to rollback the transaction in registry path " + path;
                log.error((Object)errorMsg, (Throwable)e1);
                throw e1;
            }
            throw e;
        }
    }

    public void move(String sourcePath, String targetPath) throws RegistryException {
        UserRegistry registry = this.initRegistry();
        try {
            registry.beginTransaction();
            registry.move(sourcePath, targetPath);
            registry.commitTransaction();
        }
        catch (RegistryException e) {
            String errorMsg = "Could not move the resource at " + sourcePath + " to " + targetPath;
            log.error((Object)errorMsg, (Throwable)e);
            try {
                registry.rollbackTransaction();
            }
            catch (RegistryException e1) {
                errorMsg = "Failed to rollback moving the resource at " + sourcePath + " to " + targetPath;
                log.error((Object)errorMsg, (Throwable)e1);
                throw e1;
            }
            throw e;
        }
    }

    public void delete(String resourcePath) throws RegistryException {
        UserRegistry registry = this.initRegistry();
        try {
            registry.beginTransaction();
            registry.delete(resourcePath);
            registry.commitTransaction();
        }
        catch (RegistryException e) {
            String errorMsg = "Could not delete resource at " + resourcePath;
            log.error((Object)errorMsg, (Throwable)e);
            try {
                registry.rollbackTransaction();
            }
            catch (RegistryException e1) {
                errorMsg = "Failed to rollback the transaction in registry path " + resourcePath;
                log.error((Object)errorMsg, (Throwable)e1);
                throw e1;
            }
            throw e;
        }
    }

    public Object retrieve(String resourcePath) throws RegistryException {
        Resource resource;
        UserRegistry registry = this.initRegistry();
        try {
            resource = registry.get(resourcePath);
        }
        catch (ResourceNotFoundException ignore) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No resource found in the registry path " + resourcePath));
            }
            return null;
        }
        catch (RegistryException e) {
            String errorMsg = "Failed to retrieve the Resource at " + resourcePath + " from registry.";
            log.error((Object)errorMsg, (Throwable)e);
            throw e;
        }
        return resource.getContent();
    }
}

