/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.repository;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.publisher.InstanceNotificationPublisher;
import org.apache.stratos.manager.retriever.DataInsertionAndRetrievalManager;
import org.apache.stratos.manager.subscription.CartridgeSubscription;

public class RepositoryNotification {
    private static final Log log = LogFactory.getLog(RepositoryNotification.class);

    public void updateRepository(String url) {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            Set<CartridgeSubscription> cartridgeSubscriptions = new DataInsertionAndRetrievalManager().getCartridgeSubscriptionForRepository(url);
            if (cartridgeSubscriptions == null || cartridgeSubscriptions.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No subscription information found for repo url : " + url));
                }
                return;
            }
            for (CartridgeSubscription cartridgeSubscription : cartridgeSubscriptions) {
                this.updateRepository(cartridgeSubscription);
            }
        }
    }

    public void updateRepository(CartridgeSubscription cartridgeSubscription) {
        if (cartridgeSubscription.getRepository() != null) {
            InstanceNotificationPublisher publisher = new InstanceNotificationPublisher();
            publisher.sendArtifactUpdateEvent(cartridgeSubscription.getRepository(), String.valueOf(cartridgeSubscription.getCluster().getId()), String.valueOf(cartridgeSubscription.getSubscriber().getTenantId()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Git pull request from " + cartridgeSubscription.getRepository() + "repository, for the tenant " + String.valueOf(cartridgeSubscription.getSubscriber().getTenantId())));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No repository found for subscription with alias: " + cartridgeSubscription.getAlias() + ", type: " + cartridgeSubscription.getType() + ". Not sending the Artifact Updated event"));
        }
    }
}

