/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.subscription;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cloud.controller.stub.pojo.CartridgeInfo;
import org.apache.stratos.cloud.controller.stub.pojo.Properties;
import org.apache.stratos.manager.dao.CartridgeSubscriptionInfo;
import org.apache.stratos.manager.dao.Cluster;
import org.apache.stratos.manager.exception.ADCException;
import org.apache.stratos.manager.exception.AlreadySubscribedException;
import org.apache.stratos.manager.exception.DuplicateCartridgeAliasException;
import org.apache.stratos.manager.exception.InvalidCartridgeAliasException;
import org.apache.stratos.manager.exception.InvalidRepositoryException;
import org.apache.stratos.manager.exception.NotSubscribedException;
import org.apache.stratos.manager.exception.PolicyException;
import org.apache.stratos.manager.exception.RepositoryCredentialsRequiredException;
import org.apache.stratos.manager.exception.RepositoryRequiredException;
import org.apache.stratos.manager.exception.RepositoryTransportException;
import org.apache.stratos.manager.exception.UnregisteredCartridgeException;
import org.apache.stratos.manager.payload.PayloadData;
import org.apache.stratos.manager.repository.Repository;
import org.apache.stratos.manager.subscriber.Subscriber;
import org.apache.stratos.manager.subscription.tenancy.SubscriptionTenancyBehaviour;
import org.apache.stratos.manager.utils.ApplicationManagementUtil;

public abstract class CartridgeSubscription
implements Serializable {
    private static final long serialVersionUID = -5197430500059231924L;
    private static Log log = LogFactory.getLog(CartridgeSubscription.class);
    private int subscriptionId;
    private String type;
    private String alias;
    private String autoscalingPolicyName;
    private String deploymentPolicyName;
    private Subscriber subscriber;
    private Repository repository;
    private CartridgeInfo cartridgeInfo;
    private PayloadData payloadData;
    private Cluster cluster;
    private String lbClusterId;
    private String subscriptionStatus;
    private String mappedDomain;
    private String subscriptionKey;
    private SubscriptionTenancyBehaviour subscriptionTenancyBehaviour;

    public CartridgeSubscription(CartridgeInfo cartridgeInfo, SubscriptionTenancyBehaviour subscriptionTenancyBehaviour) {
        this.setCartridgeInfo(cartridgeInfo);
        this.setType(cartridgeInfo.getType());
        this.setCluster(new Cluster());
        this.getCluster().setClusterDomain("");
        this.getCluster().setClusterSubDomain("__$default");
        this.getCluster().setMgtClusterDomain("");
        this.getCluster().setMgtClusterSubDomain("mgt");
        this.getCluster().setHostName(cartridgeInfo.getHostName());
        this.setSubscriptionTenancyBehaviour(subscriptionTenancyBehaviour);
    }

    public void createSubscription(Subscriber subscriber, String alias, String autoscalingPolicy, String deploymentPolicyName, Repository repository) throws ADCException, PolicyException, UnregisteredCartridgeException, InvalidCartridgeAliasException, DuplicateCartridgeAliasException, RepositoryRequiredException, AlreadySubscribedException, RepositoryCredentialsRequiredException, InvalidRepositoryException, RepositoryTransportException {
        this.setSubscriber(subscriber);
        this.setAlias(alias);
        this.setAutoscalingPolicyName(autoscalingPolicy);
        this.setDeploymentPolicyName(deploymentPolicyName);
        this.setRepository(repository);
        this.setPayloadData(this.getSubscriptionTenancyBehaviour().create(this.getAlias(), this.getCluster(), this.getSubscriber(), this.getRepository(), this.getCartridgeInfo(), this.getSubscriptionKey(), this.getCustomPayloadEntries()));
    }

    public void removeSubscription() throws ADCException, NotSubscribedException {
        this.getSubscriptionTenancyBehaviour().remove(this.getCluster().getClusterDomain(), this.getAlias());
        this.cleanupSubscription();
    }

    public CartridgeSubscriptionInfo registerSubscription(Properties properties) throws ADCException, UnregisteredCartridgeException {
        this.getSubscriptionTenancyBehaviour().register(this.getCartridgeInfo(), this.getCluster(), this.getPayloadData(), this.getAutoscalingPolicyName(), this.getDeploymentPolicyName(), properties);
        return ApplicationManagementUtil.createCartridgeSubscription(this.getCartridgeInfo(), this.getAutoscalingPolicyName(), this.getType(), this.getAlias(), this.getSubscriber().getTenantId(), this.getSubscriber().getTenantDomain(), this.getRepository(), this.getCluster().getHostName(), this.getCluster().getClusterDomain(), this.getCluster().getClusterSubDomain(), this.getCluster().getMgtClusterDomain(), this.getCluster().getMgtClusterSubDomain(), null, "PENDING", this.getSubscriptionKey());
    }

    public void connect(String connectingCartridgeAlias) {
    }

    public void disconnect(String disconnectingCartridgeAlias) {
    }

    public abstract Repository manageRepository(String var1, String var2, String var3, boolean var4) throws ADCException, RepositoryRequiredException, RepositoryCredentialsRequiredException, RepositoryTransportException, InvalidRepositoryException;

    protected void cleanupSubscription() throws ADCException {
    }

    public Map<String, String> getCustomPayloadEntries() {
        return null;
    }

    public String getType() {
        return this.type;
    }

    public String getAlias() {
        return this.alias;
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public CartridgeInfo getCartridgeInfo() {
        return this.cartridgeInfo;
    }

    public String getHostName() {
        return this.getCluster().getHostName();
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getClusterDomain() {
        return this.getCluster().getClusterDomain();
    }

    public void setClusterDomain(String clusterDomain) {
        this.getCluster().setClusterDomain(clusterDomain);
    }

    public String getClusterSubDomain() {
        return this.getCluster().getClusterSubDomain();
    }

    public void setClusterSubDomain(String clusterSubDomain) {
        this.getCluster().setClusterSubDomain(clusterSubDomain);
    }

    public String getMgtClusterDomain() {
        return this.getCluster().getMgtClusterDomain();
    }

    public void setMgtClusterDomain(String mgtClusterDomain) {
        this.getCluster().setMgtClusterDomain(mgtClusterDomain);
    }

    public String getMgtClusterSubDomain() {
        return this.getCluster().getMgtClusterSubDomain();
    }

    public void setMgtClusterSubDomain(String mgtClusterSubDomain) {
        this.getCluster().setMgtClusterSubDomain(mgtClusterSubDomain);
    }

    public void setHostName(String hostName) {
        this.getCluster().setHostName(hostName);
    }

    public String getAutoscalingPolicyName() {
        return this.autoscalingPolicyName;
    }

    public void setAutoscalingPolicyName(String autoscalingPolicyName) {
        this.autoscalingPolicyName = autoscalingPolicyName;
    }

    public void setSubscriber(Subscriber subscriber) {
        this.subscriber = subscriber;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setCartridgeInfo(CartridgeInfo cartridgeInfo) {
        this.cartridgeInfo = cartridgeInfo;
    }

    public PayloadData getPayloadData() {
        return this.payloadData;
    }

    public void setPayloadData(PayloadData payloadData) {
        this.payloadData = payloadData;
    }

    public int getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(int subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getMappedDomain() {
        return this.mappedDomain;
    }

    public void setMappedDomain(String mappedDomain) {
        this.mappedDomain = mappedDomain;
    }

    public String getSubscriptionStatus() {
        return this.subscriptionStatus;
    }

    public void setSubscriptionStatus(String subscriptionStatus) {
        this.subscriptionStatus = subscriptionStatus;
    }

    public String getSubscriptionKey() {
        return this.subscriptionKey;
    }

    public void setSubscriptionKey(String subscriptionKey) {
        this.subscriptionKey = subscriptionKey;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public String getDeploymentPolicyName() {
        return this.deploymentPolicyName;
    }

    public void setDeploymentPolicyName(String deploymentPolicyName) {
        this.deploymentPolicyName = deploymentPolicyName;
    }

    public SubscriptionTenancyBehaviour getSubscriptionTenancyBehaviour() {
        return this.subscriptionTenancyBehaviour;
    }

    public void setSubscriptionTenancyBehaviour(SubscriptionTenancyBehaviour subscriptionTenancyBehaviour) {
        this.subscriptionTenancyBehaviour = subscriptionTenancyBehaviour;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CartridgeSubscription)) {
            return false;
        }
        CartridgeSubscription that = (CartridgeSubscription)other;
        return this.type.equals(that.type) && this.alias.equals(that.alias);
    }

    public int hashCode() {
        return this.type.hashCode() + this.alias.hashCode();
    }

    public String toString() {
        return "CartridgeSubscription [subscriptionId=" + this.subscriptionId + ", type=" + this.type + ", alias=" + this.alias + ", autoscalingPolicyName=" + this.autoscalingPolicyName + ", deploymentPolicyName=" + this.deploymentPolicyName + ", subscriber=" + this.subscriber + ", repository=" + this.repository + ", cartridgeInfo=" + this.cartridgeInfo + ", payload=" + this.payloadData + ", cluster=" + this.cluster + "]";
    }

    public String getLbClusterId() {
        return this.lbClusterId;
    }

    public void setLbClusterId(String lbClusterId) {
        this.lbClusterId = lbClusterId;
    }
}

