/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.subscription.factory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cloud.controller.stub.pojo.CartridgeInfo;
import org.apache.stratos.manager.exception.ADCException;
import org.apache.stratos.manager.lb.category.LBDataContext;
import org.apache.stratos.manager.lb.category.LoadBalancerCategory;
import org.apache.stratos.manager.subscription.ApplicationCartridgeSubscription;
import org.apache.stratos.manager.subscription.CartridgeSubscription;
import org.apache.stratos.manager.subscription.DataCartridgeSubscription;
import org.apache.stratos.manager.subscription.FrameworkCartridgeSubscription;
import org.apache.stratos.manager.subscription.InternalRepoBasedCartridgeSubscription;
import org.apache.stratos.manager.subscription.LBCartridgeSubscription;
import org.apache.stratos.manager.subscription.tenancy.SubscriptionTenancyBehaviour;

public class CartridgeSubscriptionFactory {
    private static Log log = LogFactory.getLog(CartridgeSubscriptionFactory.class);

    public static CartridgeSubscription getCartridgeSubscriptionInstance(CartridgeInfo cartridgeInfo, SubscriptionTenancyBehaviour subscriptionTenancyBehaviour) throws ADCException {
        CartridgeSubscription cartridgeSubscription = null;
        cartridgeSubscription = cartridgeInfo.getMultiTenant() ? new FrameworkCartridgeSubscription(cartridgeInfo, subscriptionTenancyBehaviour) : (cartridgeInfo.getProvider().equals("data") ? new DataCartridgeSubscription(cartridgeInfo, subscriptionTenancyBehaviour) : (cartridgeInfo.getProvider().equals("application") ? new ApplicationCartridgeSubscription(cartridgeInfo, subscriptionTenancyBehaviour) : (cartridgeInfo.getProvider().equals("internal") ? new InternalRepoBasedCartridgeSubscription(cartridgeInfo, subscriptionTenancyBehaviour) : new FrameworkCartridgeSubscription(cartridgeInfo, subscriptionTenancyBehaviour))));
        if (cartridgeSubscription == null) {
            throw new ADCException("Unable to create a CartridgeSubscription subscription for " + cartridgeInfo);
        }
        return cartridgeSubscription;
    }

    public static CartridgeSubscription getLBCartridgeSubscriptionInstance(LBDataContext lbDataContext, LoadBalancerCategory loadBalancerCategory) throws ADCException {
        if (!lbDataContext.getLbCartridgeInfo().getProvider().equals("loadbalancer") && !lbDataContext.getLbCartridgeInfo().getProvider().equals("lb")) {
            throw new ADCException("LB cartridge provider should be either lb or loadbalancer");
        }
        return new LBCartridgeSubscription(lbDataContext.getLbCartridgeInfo(), null, loadBalancerCategory);
    }
}

