/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.client;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.autoscaler.deployment.policy.DeploymentPolicy;
import org.apache.stratos.autoscaler.partition.PartitionGroup;
import org.apache.stratos.autoscaler.policy.model.AutoscalePolicy;
import org.apache.stratos.autoscaler.stub.AutoScalerServiceInvalidPartitionExceptionException;
import org.apache.stratos.autoscaler.stub.AutoScalerServiceInvalidPolicyExceptionException;
import org.apache.stratos.autoscaler.stub.AutoScalerServiceNonExistingLBExceptionException;
import org.apache.stratos.autoscaler.stub.AutoScalerServiceStub;
import org.apache.stratos.cloud.controller.stub.deployment.partition.Partition;
import org.apache.stratos.manager.internal.DataHolder;

public class AutoscalerServiceClient {
    private AutoScalerServiceStub stub;
    private static final Log log = LogFactory.getLog(AutoscalerServiceClient.class);
    private static volatile AutoscalerServiceClient serviceClient;

    public AutoscalerServiceClient(String epr) throws AxisFault {
        String autosclaerSocketTimeout = System.getProperty("autoscaler.socket.timeout") == null ? "300000" : System.getProperty("autoscaler.socket.timeout");
        String autosclaerConnectionTimeout = System.getProperty("autoscaler.connection.timeout") == null ? "300000" : System.getProperty("autoscaler.connection.timeout");
        ConfigurationContext clientConfigContext = DataHolder.getClientConfigContext();
        try {
            this.stub = new AutoScalerServiceStub(clientConfigContext, epr);
            this.stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)new Integer(autosclaerSocketTimeout));
            this.stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)new Integer(autosclaerConnectionTimeout));
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate autoscaler service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new AxisFault(msg, (Throwable)axisFault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AutoscalerServiceClient getServiceClient() throws AxisFault {
        if (serviceClient != null) return serviceClient;
        Class<AutoscalerServiceClient> clazz = AutoscalerServiceClient.class;
        synchronized (AutoscalerServiceClient.class) {
            if (serviceClient != null) return serviceClient;
            serviceClient = new AutoscalerServiceClient(System.getProperty("autoscaler.service.url"));
            // ** MonitorExit[var0] (shouldn't be in output)
            return serviceClient;
        }
    }

    public Partition[] getAvailablePartitions() throws RemoteException {
        Partition[] partitions = this.stub.getAllAvailablePartitions();
        return partitions;
    }

    public Partition getPartition(String partitionId) throws RemoteException {
        Partition partition = this.stub.getPartition(partitionId);
        return partition;
    }

    public Partition[] getPartitionsOfGroup(String deploymentPolicyId, String partitionGroupId) throws RemoteException {
        Partition[] partitions = this.stub.getPartitionsOfGroup(deploymentPolicyId, partitionGroupId);
        return partitions;
    }

    public Partition[] getPartitionsOfDeploymentPolicy(String deploymentPolicyId) throws RemoteException {
        Partition[] partitions = this.stub.getPartitionsOfDeploymentPolicy(deploymentPolicyId);
        return partitions;
    }

    public PartitionGroup[] getPartitionGroups(String deploymentPolicyId) throws RemoteException {
        PartitionGroup[] partitionGroups = this.stub.getPartitionGroups(deploymentPolicyId);
        return partitionGroups;
    }

    public AutoscalePolicy[] getAutoScalePolicies() throws RemoteException {
        AutoscalePolicy[] autoscalePolicies = this.stub.getAllAutoScalingPolicy();
        return autoscalePolicies;
    }

    public AutoscalePolicy getAutoScalePolicy(String autoscalingPolicyId) throws RemoteException {
        AutoscalePolicy autoscalePolicy = this.stub.getAutoscalingPolicy(autoscalingPolicyId);
        return autoscalePolicy;
    }

    public DeploymentPolicy[] getDeploymentPolicies() throws RemoteException {
        DeploymentPolicy[] deploymentPolicies = this.stub.getAllDeploymentPolicies();
        return deploymentPolicies;
    }

    public DeploymentPolicy[] getDeploymentPolicies(String cartridgeType) throws RemoteException {
        DeploymentPolicy[] deploymentPolicies = this.stub.getValidDeploymentPoliciesforCartridge(cartridgeType);
        return deploymentPolicies;
    }

    public void checkLBExistenceAgainstPolicy(String clusterId, String deploymentPolicyId) throws RemoteException, AutoScalerServiceNonExistingLBExceptionException {
        this.stub.checkLBExistenceAgainstPolicy(clusterId, deploymentPolicyId);
    }

    public boolean checkDefaultLBExistenceAgainstPolicy(String deploymentPolicyId) throws RemoteException {
        return this.stub.checkDefaultLBExistenceAgainstPolicy(deploymentPolicyId);
    }

    public boolean checkServiceLBExistenceAgainstPolicy(String serviceName, String deploymentPolicyId) throws RemoteException {
        return this.stub.checkServiceLBExistenceAgainstPolicy(serviceName, deploymentPolicyId);
    }

    public DeploymentPolicy getDeploymentPolicy(String deploymentPolicyId) throws RemoteException {
        DeploymentPolicy deploymentPolicy = this.stub.getDeploymentPolicy(deploymentPolicyId);
        return deploymentPolicy;
    }

    public boolean deployDeploymentPolicy(DeploymentPolicy deploymentPolicy) throws RemoteException, AutoScalerServiceInvalidPolicyExceptionException {
        return this.stub.addDeploymentPolicy(deploymentPolicy);
    }

    public boolean deployAutoscalingPolicy(AutoscalePolicy autoScalePolicy) throws RemoteException, AutoScalerServiceInvalidPolicyExceptionException {
        return this.stub.addAutoScalingPolicy(autoScalePolicy);
    }

    public boolean deployPartition(Partition partition) throws RemoteException, AutoScalerServiceInvalidPartitionExceptionException {
        return this.stub.addPartition(partition);
    }

    public String getDefaultLBClusterId(String deploymentPolicy) throws RemoteException {
        return this.stub.getDefaultLBClusterId(deploymentPolicy);
    }

    public String getServiceLBClusterId(String serviceType, String deploymentPolicy) throws RemoteException {
        return this.stub.getServiceLBClusterId(serviceType, deploymentPolicy);
    }
}

