/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.client;

import java.rmi.RemoteException;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceInvalidCartridgeDefinitionExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceInvalidCartridgeTypeExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceInvalidClusterExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceInvalidIaasProviderExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceStub;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceUnregisteredCartridgeExceptionException;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceUnregisteredClusterExceptionException;
import org.apache.stratos.cloud.controller.stub.pojo.CartridgeConfig;
import org.apache.stratos.cloud.controller.stub.pojo.CartridgeInfo;
import org.apache.stratos.cloud.controller.stub.pojo.ClusterContext;
import org.apache.stratos.cloud.controller.stub.pojo.Property;
import org.apache.stratos.cloud.controller.stub.pojo.Registrant;
import org.apache.stratos.manager.internal.DataHolder;

public class CloudControllerServiceClient {
    private CloudControllerServiceStub stub;
    private static final Log log = LogFactory.getLog(CloudControllerServiceClient.class);
    private static volatile CloudControllerServiceClient serviceClient;

    public CloudControllerServiceClient(String epr) throws AxisFault {
        String ccSocketTimeout = System.getProperty("cc.socket.timeout") == null ? "300000" : System.getProperty("cc.socket.timeout");
        String ccConnectionTimeout = System.getProperty("cc.connection.timeout") == null ? "300000" : System.getProperty("cc.connection.timeout");
        ConfigurationContext clientConfigContext = DataHolder.getClientConfigContext();
        try {
            this.stub = new CloudControllerServiceStub(clientConfigContext, epr);
            this.stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)new Integer(ccSocketTimeout));
            this.stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)new Integer(ccConnectionTimeout));
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate AutoscalerService client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new AxisFault(msg, (Throwable)axisFault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CloudControllerServiceClient getServiceClient() throws AxisFault {
        if (serviceClient != null) return serviceClient;
        Class<CloudControllerServiceClient> clazz = CloudControllerServiceClient.class;
        synchronized (CloudControllerServiceClient.class) {
            if (serviceClient != null) return serviceClient;
            serviceClient = new CloudControllerServiceClient(System.getProperty("cloud.controller.service.url"));
            // ** MonitorExit[var0] (shouldn't be in output)
            return serviceClient;
        }
    }

    public void deployCartridgeDefinition(CartridgeConfig cartridgeConfig) throws RemoteException, CloudControllerServiceInvalidCartridgeDefinitionExceptionException, CloudControllerServiceInvalidIaasProviderExceptionException {
        this.stub.deployCartridgeDefinition(cartridgeConfig);
    }

    public void unDeployCartridgeDefinition(String cartridgeType) throws RemoteException, CloudControllerServiceInvalidCartridgeTypeExceptionException {
        this.stub.undeployCartridgeDefinition(cartridgeType);
    }

    public boolean register(String clusterId, String cartridgeType, String payload, String tenantRange, String hostName, org.apache.stratos.cloud.controller.stub.pojo.Properties properties, String autoscalorPolicyName, String deploymentPolicyName) throws RemoteException, CloudControllerServiceUnregisteredCartridgeExceptionException {
        Registrant registrant = new Registrant();
        registrant.setClusterId(clusterId);
        registrant.setCartridgeType(cartridgeType);
        registrant.setTenantRange(tenantRange);
        registrant.setHostName(hostName);
        registrant.setProperties(properties);
        registrant.setPayload(payload);
        registrant.setAutoScalerPolicyName(autoscalorPolicyName);
        registrant.setDeploymentPolicyName(deploymentPolicyName);
        return this.stub.registerService(registrant);
    }

    private org.apache.stratos.cloud.controller.stub.pojo.Properties extractProperties(Properties properties) {
        org.apache.stratos.cloud.controller.stub.pojo.Properties props = new org.apache.stratos.cloud.controller.stub.pojo.Properties();
        if (properties != null) {
            for (String string : properties.keySet()) {
                String value = properties.getProperty(string);
                Property prop = new Property();
                prop.setName(string);
                prop.setValue(value);
                props.addProperties(prop);
            }
        }
        return props;
    }

    public void terminateAllInstances(String clusterId) throws RemoteException, CloudControllerServiceInvalidClusterExceptionException {
        this.stub.terminateAllInstances(clusterId);
    }

    public String[] getRegisteredCartridges() throws RemoteException {
        return this.stub.getRegisteredCartridges();
    }

    public CartridgeInfo getCartridgeInfo(String cartridgeType) throws RemoteException, CloudControllerServiceUnregisteredCartridgeExceptionException {
        return this.stub.getCartridgeInfo(cartridgeType);
    }

    public void unregisterService(String clusterId) throws RemoteException, CloudControllerServiceUnregisteredClusterExceptionException {
        this.stub.unregisterService(clusterId);
    }

    public ClusterContext getClusterContext(String clusterId) throws RemoteException {
        return this.stub.getClusterContext(clusterId);
    }
}

