/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.deploy.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cloud.controller.stub.pojo.CartridgeInfo;
import org.apache.stratos.cloud.controller.stub.pojo.Properties;
import org.apache.stratos.manager.behaviour.CartridgeMgtBehaviour;
import org.apache.stratos.manager.dao.Cluster;
import org.apache.stratos.manager.exception.ADCException;
import org.apache.stratos.manager.exception.NotSubscribedException;
import org.apache.stratos.manager.exception.UnregisteredCartridgeException;
import org.apache.stratos.manager.payload.PayloadData;
import org.apache.stratos.manager.subscription.utils.CartridgeSubscriptionUtils;

public abstract class Service
extends CartridgeMgtBehaviour {
    private static Log log = LogFactory.getLog(Service.class);
    private String type;
    private String autoscalingPolicyName;
    private String deploymentPolicyName;
    private String tenantRange;
    private int tenantId;
    private String subscriptionKey;
    private CartridgeInfo cartridgeInfo;
    private PayloadData payloadData;
    private Cluster cluster;

    public Service(String type, String autoscalingPolicyName, String deploymentPolicyName, int tenantId, CartridgeInfo cartridgeInfo, String tenantRange) {
        this.type = type;
        this.autoscalingPolicyName = autoscalingPolicyName;
        this.deploymentPolicyName = deploymentPolicyName;
        this.tenantId = tenantId;
        this.cartridgeInfo = cartridgeInfo;
        this.tenantRange = tenantRange;
        this.subscriptionKey = CartridgeSubscriptionUtils.generateSubscriptionKey();
        this.setCluster(new Cluster());
    }

    public void create() throws ADCException {
        this.setClusterId(this.generateClusterId(null, this.type));
        this.setHostName(this.cartridgeInfo.getHostName());
        this.setPayloadData(this.createPayload(this.cartridgeInfo, this.subscriptionKey, null, this.cluster, null, null, null));
    }

    @Override
    protected String generateClusterId(String alias, String cartridgeType) {
        String clusterId = cartridgeType + this.cartridgeInfo.getHostName() + ".domain";
        if (clusterId.length() > 30) {
            clusterId = CartridgeSubscriptionUtils.limitLengthOfString(clusterId, 30);
        }
        return clusterId;
    }

    public void deploy(Properties properties) throws ADCException, UnregisteredCartridgeException {
        this.register(this.getCartridgeInfo(), this.getCluster(), this.getPayloadData(), this.getAutoscalingPolicyName(), this.getDeploymentPolicyName(), properties);
    }

    public void undeploy() throws ADCException, NotSubscribedException {
        this.remove(this.cluster.getClusterDomain(), null);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAutoscalingPolicyName() {
        return this.autoscalingPolicyName;
    }

    public void setAutoscalingPolicyName(String autoscalingPolicyName) {
        this.autoscalingPolicyName = autoscalingPolicyName;
    }

    public String getDeploymentPolicyName() {
        return this.deploymentPolicyName;
    }

    public void setDeploymentPolicyName(String deploymentPolicyName) {
        this.deploymentPolicyName = deploymentPolicyName;
    }

    public String getTenantRange() {
        return this.tenantRange;
    }

    public void setTenantRange(String tenantRange) {
        this.tenantRange = tenantRange;
    }

    public String getClusterId() {
        return this.cluster.getClusterDomain();
    }

    public void setClusterId(String clusterId) {
        this.cluster.setClusterDomain(clusterId);
    }

    public String getHostName() {
        return this.cluster.getHostName();
    }

    public void setHostName(String hostName) {
        this.cluster.setHostName(hostName);
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public CartridgeInfo getCartridgeInfo() {
        return this.cartridgeInfo;
    }

    public void setCartridgeInfo(CartridgeInfo cartridgeInfo) {
        this.cartridgeInfo = cartridgeInfo;
    }

    public String getSubscriptionKey() {
        return this.subscriptionKey;
    }

    public void setSubscriptionKey(String subscriptionKey) {
        this.subscriptionKey = subscriptionKey;
    }

    public PayloadData getPayloadData() {
        return this.payloadData;
    }

    public void setPayloadData(PayloadData payloadData) {
        this.payloadData = payloadData;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }
}

