/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.lb.category;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cloud.controller.stub.pojo.CartridgeInfo;
import org.apache.stratos.manager.behaviour.CartridgeMgtBehaviour;
import org.apache.stratos.manager.dao.Cluster;
import org.apache.stratos.manager.deploy.service.Service;
import org.apache.stratos.manager.exception.ADCException;
import org.apache.stratos.manager.exception.AlreadySubscribedException;
import org.apache.stratos.manager.exception.PersistenceManagerException;
import org.apache.stratos.manager.payload.PayloadData;
import org.apache.stratos.manager.repository.Repository;
import org.apache.stratos.manager.retriever.DataInsertionAndRetrievalManager;
import org.apache.stratos.manager.subscriber.Subscriber;

public abstract class LoadBalancerCategory
extends CartridgeMgtBehaviour {
    private String loadBalancedServiceType;
    private boolean isLoadBalancedServiceMultiTenant;
    private String deploymentPolicyName;
    private static Log log = LogFactory.getLog(LoadBalancerCategory.class);

    public String getLoadBalancedServiceType() {
        return this.loadBalancedServiceType;
    }

    public void setLoadBalancedServiceType(String loadBalancedServiceType) {
        this.loadBalancedServiceType = loadBalancedServiceType;
    }

    @Override
    public PayloadData create(String alias, Cluster cluster, Subscriber subscriber, Repository repository, CartridgeInfo cartridgeInfo, String subscriptionKey, Map<String, String> customPayloadEntries) throws ADCException, AlreadySubscribedException {
        if (this.isLoadBalancedServiceMultiTenant) {
            Service deployedLBService;
            try {
                deployedLBService = new DataInsertionAndRetrievalManager().getService(cartridgeInfo.getType());
            }
            catch (PersistenceManagerException e) {
                String errorMsg = "Error in checking if Service is available is PersistenceManager";
                log.error((Object)errorMsg, (Throwable)e);
                throw new ADCException(errorMsg, e);
            }
            if (deployedLBService == null) {
                String errorMsg = "There is no deployed Service for type " + cartridgeInfo.getType();
                log.error((Object)errorMsg);
                throw new ADCException(errorMsg);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Setting cluster Domain : " + deployedLBService.getClusterId()));
                log.debug((Object)(" Setting Host Name : " + deployedLBService.getHostName()));
            }
            cluster.setClusterDomain(deployedLBService.getClusterId());
            cluster.setHostName(deployedLBService.getHostName());
            return null;
        }
        cluster.setClusterDomain(this.generateClusterId(alias, cartridgeInfo.getType()));
        cluster.setHostName(this.generateHostName(alias, cartridgeInfo.getHostName()));
        return this.createPayload(cartridgeInfo, subscriptionKey, subscriber, cluster, repository, alias, customPayloadEntries);
    }

    public boolean isLoadBalancedServiceMultiTenant() {
        return this.isLoadBalancedServiceMultiTenant;
    }

    public void setLoadBalancedServiceMultiTenant(boolean isLoadBalancedServiceMultiTenant) {
        this.isLoadBalancedServiceMultiTenant = isLoadBalancedServiceMultiTenant;
    }

    public String getDeploymentPolicyName() {
        return this.deploymentPolicyName;
    }

    public void setDeploymentPolicyName(String deploymentPolicyName) {
        this.deploymentPolicyName = deploymentPolicyName;
    }
}

