/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.lookup;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.subscription.CartridgeSubscription;

public class ClusterIdToSubscription
implements Serializable {
    private static final Log log = LogFactory.getLog(ClusterIdToSubscription.class);
    private Map<String, Set<CartridgeSubscription>> clusterIdToCartridgeSubscription = new HashMap<String, Set<CartridgeSubscription>>();

    public void addSubscription(CartridgeSubscription cartridgeSubscription) {
        String clusterDomain = cartridgeSubscription.getClusterDomain();
        if (this.clusterIdToCartridgeSubscription.containsKey(clusterDomain)) {
            Set<CartridgeSubscription> existingSubscriptions = this.clusterIdToCartridgeSubscription.get(clusterDomain);
            if (existingSubscriptions.remove(cartridgeSubscription) && log.isDebugEnabled()) {
                log.debug((Object)("Removed the existing Cartridge Subscription for cluster id " + clusterDomain + " in [Cluster Id -> Set<CartridgeSubscription>] map"));
            }
            existingSubscriptions.add(cartridgeSubscription);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added Cartridge Subscription for cluster id " + clusterDomain + " in [Cluster Id -> Set<CartridgeSubscription>] map"));
            }
        } else {
            HashSet<CartridgeSubscription> subscriptions = new HashSet<CartridgeSubscription>();
            subscriptions.add(cartridgeSubscription);
            this.clusterIdToCartridgeSubscription.put(clusterDomain, subscriptions);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added Cartridge Subscription for cluster id " + clusterDomain + " in [Cluster Id -> Set<CartridgeSubscription>] map"));
            }
        }
    }

    public Set<CartridgeSubscription> getSubscription(String clusterId) {
        return this.clusterIdToCartridgeSubscription.get(clusterId);
    }

    public void removeSubscription(String clusterId, String subscriptionAlias) {
        Set<CartridgeSubscription> existingSubscriptions = this.clusterIdToCartridgeSubscription.get(clusterId);
        if (existingSubscriptions != null && !existingSubscriptions.isEmpty()) {
            Iterator<CartridgeSubscription> iterator = existingSubscriptions.iterator();
            while (iterator.hasNext()) {
                CartridgeSubscription cartridgeSubscription = iterator.next();
                if (!cartridgeSubscription.getAlias().equals(subscriptionAlias)) continue;
                iterator.remove();
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("Deleted the subscription for cluster id " + clusterId + " from [Cluster Id -> Set<CartridgeSubscription>] map"));
                break;
            }
        }
        if (existingSubscriptions == null || existingSubscriptions.isEmpty()) {
            this.clusterIdToCartridgeSubscription.remove(clusterId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleted the subscriptions set for cluster id " + clusterId + " from [Cluster Id -> Set<CartridgeSubscription>] map"));
            }
        }
    }
}

