/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.lookup;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.subscription.CartridgeSubscription;

public class SubscriptionContext
implements Serializable {
    private static final Log log = LogFactory.getLog(SubscriptionContext.class);
    private Map<String, Set<CartridgeSubscription>> cartridgeTypeToSubscriptions = new HashMap<String, Set<CartridgeSubscription>>();
    private Map<String, CartridgeSubscription> aliasToSubscription = new HashMap<String, CartridgeSubscription>();

    public void addSubscription(CartridgeSubscription cartridgeSubscription) {
        String cartridgeType = cartridgeSubscription.getType();
        if (this.cartridgeTypeToSubscriptions.containsKey(cartridgeType)) {
            Set<CartridgeSubscription> existingSubscriptions = this.cartridgeTypeToSubscriptions.get(cartridgeType);
            if (existingSubscriptions.remove(cartridgeSubscription) && log.isDebugEnabled()) {
                log.debug((Object)("Removed the existing Cartridge Subscription for type " + cartridgeType + ", alias " + cartridgeSubscription.getAlias() + " in [Cartridge Type -> Set<CartridgeSubscription>] map"));
            }
            existingSubscriptions.add(cartridgeSubscription);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added Cartridge Subscription for type " + cartridgeType + ", alias " + cartridgeSubscription.getAlias() + " in [Cartridge Type -> Set<CartridgeSubscription>] map"));
            }
        } else {
            HashSet<CartridgeSubscription> subscriptions = new HashSet<CartridgeSubscription>();
            subscriptions.add(cartridgeSubscription);
            this.cartridgeTypeToSubscriptions.put(cartridgeType, subscriptions);
        }
        if (this.aliasToSubscription.put(cartridgeSubscription.getAlias(), cartridgeSubscription) != null && log.isDebugEnabled()) {
            log.debug((Object)("Overwrote the existing Cartridge Subscription for alias " + cartridgeSubscription.getAlias() + " in [Subscription Alias -> CartridgeSubscription] map"));
        }
    }

    public Collection<CartridgeSubscription> getSubscriptions() {
        return this.aliasToSubscription.values();
    }

    public Collection<CartridgeSubscription> getSubscriptionsOfType(String cartridgeType) {
        return this.cartridgeTypeToSubscriptions.get(cartridgeType);
    }

    public CartridgeSubscription getSubscriptionForAlias(String subscriptionAlias) {
        return this.aliasToSubscription.get(subscriptionAlias);
    }

    public void deleteSubscription(String type, String subscriptionAlias) {
        Set<CartridgeSubscription> existingSubscriptions = this.cartridgeTypeToSubscriptions.get(type);
        if (existingSubscriptions != null && !existingSubscriptions.isEmpty()) {
            Iterator<CartridgeSubscription> iterator = existingSubscriptions.iterator();
            while (iterator.hasNext()) {
                CartridgeSubscription cartridgeSubscription = iterator.next();
                if (!cartridgeSubscription.getAlias().equals(subscriptionAlias)) continue;
                iterator.remove();
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("Deleted the subscription for alias " + subscriptionAlias + " and type " + type + " from [Type -> Set<CartridgeSubscription>] map"));
                break;
            }
        }
        if (existingSubscriptions == null || existingSubscriptions.isEmpty()) {
            this.cartridgeTypeToSubscriptions.remove(type);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleted the subscriptions set for type " + type + " from [Type -> Set<CartridgeSubscription>] map"));
            }
        }
        if (this.aliasToSubscription.remove(subscriptionAlias) != null && log.isDebugEnabled()) {
            log.debug((Object)("Deleted the subscription for alias " + subscriptionAlias + " from [Alias -> CartridgeSubscription] map"));
        }
    }

    public boolean isEmpty() {
        return this.cartridgeTypeToSubscriptions.isEmpty() && this.aliasToSubscription.isEmpty();
    }
}

