/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.manager;

import java.util.Collection;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cloud.controller.stub.CloudControllerServiceUnregisteredCartridgeExceptionException;
import org.apache.stratos.cloud.controller.stub.pojo.CartridgeInfo;
import org.apache.stratos.cloud.controller.stub.pojo.LoadbalancerConfig;
import org.apache.stratos.cloud.controller.stub.pojo.Properties;
import org.apache.stratos.cloud.controller.stub.pojo.Property;
import org.apache.stratos.manager.client.CloudControllerServiceClient;
import org.apache.stratos.manager.dao.CartridgeSubscriptionInfo;
import org.apache.stratos.manager.dto.SubscriptionInfo;
import org.apache.stratos.manager.exception.ADCException;
import org.apache.stratos.manager.exception.AlreadySubscribedException;
import org.apache.stratos.manager.exception.DuplicateCartridgeAliasException;
import org.apache.stratos.manager.exception.InvalidCartridgeAliasException;
import org.apache.stratos.manager.exception.InvalidRepositoryException;
import org.apache.stratos.manager.exception.NotSubscribedException;
import org.apache.stratos.manager.exception.PersistenceManagerException;
import org.apache.stratos.manager.exception.PolicyException;
import org.apache.stratos.manager.exception.RepositoryCredentialsRequiredException;
import org.apache.stratos.manager.exception.RepositoryRequiredException;
import org.apache.stratos.manager.exception.RepositoryTransportException;
import org.apache.stratos.manager.exception.UnregisteredCartridgeException;
import org.apache.stratos.manager.lb.category.DefaultLoadBalancerCategory;
import org.apache.stratos.manager.lb.category.ExistingLoadBalancerCategory;
import org.apache.stratos.manager.lb.category.LBDataContext;
import org.apache.stratos.manager.lb.category.LoadBalancerCategory;
import org.apache.stratos.manager.lb.category.ServiceLevelLoadBalancerCategory;
import org.apache.stratos.manager.publisher.CartridgeSubscriptionDataPublisher;
import org.apache.stratos.manager.repository.Repository;
import org.apache.stratos.manager.retriever.DataInsertionAndRetrievalManager;
import org.apache.stratos.manager.subscriber.Subscriber;
import org.apache.stratos.manager.subscription.CartridgeSubscription;
import org.apache.stratos.manager.subscription.PersistenceContext;
import org.apache.stratos.manager.subscription.SubscriptionData;
import org.apache.stratos.manager.subscription.factory.CartridgeSubscriptionFactory;
import org.apache.stratos.manager.subscription.tenancy.SubscriptionMultiTenantBehaviour;
import org.apache.stratos.manager.subscription.tenancy.SubscriptionSingleTenantBehaviour;
import org.apache.stratos.manager.subscription.tenancy.SubscriptionTenancyBehaviour;
import org.apache.stratos.manager.subscription.utils.CartridgeSubscriptionUtils;
import org.apache.stratos.manager.topology.model.TopologyClusterInformationModel;
import org.apache.stratos.manager.utils.ApplicationManagementUtil;
import org.apache.stratos.manager.utils.RepoPasswordMgtUtil;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Member;
import org.wso2.carbon.context.CarbonContext;

public class CartridgeSubscriptionManager {
    private static Log log = LogFactory.getLog(CartridgeSubscriptionManager.class);

    public SubscriptionInfo subscribeToCartridgeWithProperties(SubscriptionData subscriptionData) throws ADCException, InvalidCartridgeAliasException, DuplicateCartridgeAliasException, PolicyException, UnregisteredCartridgeException, RepositoryRequiredException, RepositoryCredentialsRequiredException, RepositoryTransportException, AlreadySubscribedException, InvalidRepositoryException {
        CartridgeInfo cartridgeInfo;
        CartridgeSubscriptionUtils.validateCartridgeAlias(subscriptionData.getTenantId(), subscriptionData.getCartridgeType(), subscriptionData.getCartridgeAlias());
        try {
            cartridgeInfo = CloudControllerServiceClient.getServiceClient().getCartridgeInfo(subscriptionData.getCartridgeType());
        }
        catch (CloudControllerServiceUnregisteredCartridgeExceptionException e) {
            String message = subscriptionData.getCartridgeType() + " is not a valid cartridgeSubscription type. Please try again with a valid cartridgeSubscription type.";
            log.error((Object)message);
            throw new ADCException(message, e);
        }
        catch (Exception e) {
            String message = "Error getting info for " + subscriptionData.getCartridgeType();
            log.error((Object)message, (Throwable)e);
            throw new ADCException(message, e);
        }
        if (cartridgeInfo.getMultiTenant() && !this.activeInstancesAvailable(subscriptionData)) {
            String msg = "No active instances are found for cartridge [" + subscriptionData.getCartridgeType() + "]";
            log.error((Object)msg);
            throw new ADCException(msg);
        }
        Properties persistenceMappingProperties = null;
        if (subscriptionData.getPersistanceContext() != null) {
            persistenceMappingProperties = this.getPersistenceMappingProperties(subscriptionData.getPersistanceContext(), cartridgeInfo);
        }
        Properties serviceCartridgeSubscriptionProperties = null;
        LBDataContext lbDataCtxt = null;
        CartridgeSubscription lbCartridgeSubscription = null;
        Properties lbCartridgeSubscriptionProperties = null;
        String lbClusterId = null;
        LoadbalancerConfig lbConfig = cartridgeInfo.getLbConfig();
        if (lbConfig == null || lbConfig.getProperties() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("This Service does not require a load balancer. [Service Name] " + subscriptionData.getCartridgeType()));
            }
        } else {
            lbDataCtxt = CartridgeSubscriptionUtils.getLoadBalancerDataContext(subscriptionData.getTenantId(), subscriptionData.getCartridgeType(), subscriptionData.getDeploymentPolicyName(), lbConfig);
            lbCartridgeSubscription = this.subscribeToLB(subscriptionData, lbDataCtxt, cartridgeInfo);
            if (lbCartridgeSubscription != null) {
                lbClusterId = lbCartridgeSubscription.getClusterDomain();
            }
            lbCartridgeSubscriptionProperties = new Properties();
            if (lbDataCtxt.getLbProperperties() != null && !lbDataCtxt.getLbProperperties().isEmpty()) {
                lbCartridgeSubscriptionProperties.setProperties(lbDataCtxt.getLbProperperties().toArray(new Property[0]));
            }
        }
        CartridgeSubscription serviceCartridgeSubscription = this.subscribe(subscriptionData, cartridgeInfo, lbClusterId);
        serviceCartridgeSubscriptionProperties = new Properties();
        if (lbDataCtxt != null && lbDataCtxt.getLoadBalancedServiceProperties() != null && !lbDataCtxt.getLoadBalancedServiceProperties().isEmpty()) {
            serviceCartridgeSubscriptionProperties.setProperties(lbDataCtxt.getLoadBalancedServiceProperties().toArray(new Property[0]));
        }
        if (persistenceMappingProperties != null && persistenceMappingProperties.getProperties().length > 0) {
            for (Property persistenceMappingProperty : persistenceMappingProperties.getProperties()) {
                serviceCartridgeSubscriptionProperties.addProperties(persistenceMappingProperty);
            }
        }
        if (lbCartridgeSubscription != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Registering LB Cartridge subscription ");
            }
            this.registerCartridgeSubscription(lbCartridgeSubscription, lbCartridgeSubscriptionProperties);
        }
        return this.registerCartridgeSubscription(serviceCartridgeSubscription, serviceCartridgeSubscriptionProperties);
    }

    private boolean activeInstancesAvailable(SubscriptionData subscriptionData) {
        Cluster cluster = TopologyClusterInformationModel.getInstance().getCluster(subscriptionData.getCartridgeType());
        int activeMemberCount = 0;
        if (cluster != null) {
            Collection members = cluster.getMembers();
            for (Member member : members) {
                if (!member.isActive()) continue;
                ++activeMemberCount;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Active member count for cluster  [" + cluster + "] is : " + activeMemberCount));
        }
        return activeMemberCount > 0;
    }

    private CartridgeSubscription subscribeToLB(SubscriptionData subscriptionData, LBDataContext lbDataContext, CartridgeInfo serviceCartridgeInfo) throws ADCException, InvalidCartridgeAliasException, DuplicateCartridgeAliasException, PolicyException, UnregisteredCartridgeException, RepositoryRequiredException, RepositoryCredentialsRequiredException, RepositoryTransportException, AlreadySubscribedException, InvalidRepositoryException {
        if (lbDataContext.getLbCategory() == null || lbDataContext.getLbCategory().equals("no.load.balancer")) {
            log.info((Object)("No LB subscription required for the Subscription with alias: " + subscriptionData.getCartridgeAlias() + ", type: " + subscriptionData.getCartridgeType()));
            return null;
        }
        LoadBalancerCategory loadBalancerCategory = null;
        String lbAlias = "lb" + lbDataContext.getLbCartridgeInfo().getType() + new Random().nextInt();
        if (lbDataContext.getLbCategory().equals("existing.load.balancers")) {
            loadBalancerCategory = new ExistingLoadBalancerCategory();
        } else if (lbDataContext.getLbCategory().equals("default.load.balancer")) {
            loadBalancerCategory = new DefaultLoadBalancerCategory();
        } else if (lbDataContext.getLbCategory().equals("service.aware.load.balancer")) {
            loadBalancerCategory = new ServiceLevelLoadBalancerCategory();
        }
        if (loadBalancerCategory == null) {
            throw new ADCException("The given Load Balancer category " + lbDataContext.getLbCategory() + " not found");
        }
        if (lbDataContext.getLbCartridgeInfo().getMultiTenant()) {
            throw new ADCException("LB Cartridge must be single tenant");
        }
        loadBalancerCategory.setLoadBalancedServiceType(subscriptionData.getCartridgeType());
        loadBalancerCategory.setLoadBalancedServiceMultiTenant(serviceCartridgeInfo.getMultiTenant());
        loadBalancerCategory.setDeploymentPolicyName(lbDataContext.getDeploymentPolicy());
        CartridgeSubscription cartridgeSubscription = CartridgeSubscriptionFactory.getLBCartridgeSubscriptionInstance(lbDataContext, loadBalancerCategory);
        String subscriptionKey = CartridgeSubscriptionUtils.generateSubscriptionKey();
        cartridgeSubscription.setSubscriptionKey(subscriptionKey);
        Repository repository = cartridgeSubscription.manageRepository(null, "", "", false);
        Subscriber subscriber = new Subscriber(subscriptionData.getTenantAdminUsername(), subscriptionData.getTenantId(), subscriptionData.getTenantDomain());
        cartridgeSubscription.createSubscription(subscriber, lbAlias, lbDataContext.getAutoscalePolicy(), lbDataContext.getDeploymentPolicy(), repository);
        if (cartridgeSubscription.getPayloadData() != null) {
            cartridgeSubscription.getPayloadData().add("LB_CATEGORY", lbDataContext.getLbCategory());
        }
        CartridgeSubscriptionDataPublisher.publish(subscriptionData.getTenantId(), subscriptionData.getTenantAdminUsername(), lbAlias, lbDataContext.getLbCartridgeInfo().getType(), subscriptionData.getRepositoryURL(), serviceCartridgeInfo.getMultiTenant(), lbDataContext.getDeploymentPolicy(), lbDataContext.getAutoscalePolicy(), cartridgeSubscription.getCluster().getClusterDomain(), cartridgeSubscription.getHostName(), cartridgeSubscription.getMappedDomain(), "Subscribed");
        log.info((Object)("Tenant [" + subscriptionData.getTenantId() + "] with username [" + subscriptionData.getTenantAdminUsername() + " subscribed to " + "] Cartridge with Alias " + lbAlias + ", Cartridge Type: " + lbDataContext.getLbCartridgeInfo().getType() + ", Autoscale Policy: " + lbDataContext.getAutoscalePolicy() + ", Deployment Policy: " + lbDataContext.getDeploymentPolicy()));
        return cartridgeSubscription;
    }

    private CartridgeSubscription subscribe(SubscriptionData subscriptionData, CartridgeInfo cartridgeInfo, String lbClusterId) throws ADCException, InvalidCartridgeAliasException, DuplicateCartridgeAliasException, PolicyException, UnregisteredCartridgeException, RepositoryRequiredException, RepositoryCredentialsRequiredException, RepositoryTransportException, AlreadySubscribedException, InvalidRepositoryException {
        SubscriptionTenancyBehaviour tenancyBehaviour = cartridgeInfo.getMultiTenant() ? new SubscriptionMultiTenantBehaviour() : new SubscriptionSingleTenantBehaviour();
        CartridgeSubscription cartridgeSubscription = CartridgeSubscriptionFactory.getCartridgeSubscriptionInstance(cartridgeInfo, tenancyBehaviour);
        String subscriptionKey = CartridgeSubscriptionUtils.generateSubscriptionKey();
        cartridgeSubscription.setSubscriptionKey(subscriptionKey);
        String repositoryPassword = subscriptionData.getRepositoryPassword();
        String encryptedRepoPassword = repositoryPassword != null && !repositoryPassword.isEmpty() ? RepoPasswordMgtUtil.encryptPassword(repositoryPassword, subscriptionKey) : "";
        Repository repository = cartridgeSubscription.manageRepository(subscriptionData.getRepositoryURL(), subscriptionData.getRepositoryUsername(), encryptedRepoPassword, subscriptionData.isPrivateRepository());
        Subscriber subscriber = new Subscriber(subscriptionData.getTenantAdminUsername(), subscriptionData.getTenantId(), subscriptionData.getTenantDomain());
        cartridgeSubscription.setLbClusterId(lbClusterId);
        cartridgeSubscription.createSubscription(subscriber, subscriptionData.getCartridgeAlias(), subscriptionData.getAutoscalingPolicyName(), subscriptionData.getDeploymentPolicyName(), repository);
        CartridgeSubscriptionDataPublisher.publish(subscriptionData.getTenantId(), subscriptionData.getTenantAdminUsername(), subscriptionData.getCartridgeAlias(), subscriptionData.getCartridgeType(), subscriptionData.getRepositoryURL(), cartridgeInfo.getMultiTenant(), subscriptionData.getAutoscalingPolicyName(), subscriptionData.getDeploymentPolicyName(), cartridgeSubscription.getCluster().getClusterDomain(), cartridgeSubscription.getHostName(), cartridgeSubscription.getMappedDomain(), "Subscribed");
        if (cartridgeSubscription.getPayloadData() != null) {
            cartridgeSubscription.getPayloadData().add("COMMIT_ENABLED", String.valueOf(subscriptionData.isCommitsEnabled()));
        }
        log.info((Object)("Tenant [" + subscriptionData.getTenantId() + "] with username [" + subscriptionData.getTenantAdminUsername() + " subscribed to " + "] Cartridge with Alias " + subscriptionData.getCartridgeAlias() + ", Cartridge Type: " + subscriptionData.getCartridgeType() + ", Repo URL: " + subscriptionData.getRepositoryURL() + ", Autoscale Policy: " + subscriptionData.getAutoscalingPolicyName() + ", Deployment Policy: " + subscriptionData.getDeploymentPolicyName()));
        return cartridgeSubscription;
    }

    private SubscriptionInfo registerCartridgeSubscription(CartridgeSubscription cartridgeSubscription, Properties properties) throws ADCException, UnregisteredCartridgeException {
        CartridgeSubscriptionInfo cartridgeSubscriptionInfo = cartridgeSubscription.registerSubscription(properties);
        cartridgeSubscription.setSubscriptionStatus("SUBSCRIBED");
        try {
            new DataInsertionAndRetrievalManager().cacheAndPersistSubcription(cartridgeSubscription);
        }
        catch (PersistenceManagerException e) {
            String errorMsg = "Error saving subscription for tenant " + cartridgeSubscription.getSubscriber().getTenantDomain() + ", alias " + cartridgeSubscription.getType();
            log.error((Object)errorMsg);
            throw new ADCException(errorMsg, e);
        }
        log.info((Object)("Successful Subscription: " + cartridgeSubscription.toString()));
        CartridgeSubscriptionUtils.publishTenantSubscribedEvent(cartridgeSubscription.getSubscriber().getTenantId(), cartridgeSubscription.getCartridgeInfo().getType());
        return ApplicationManagementUtil.createSubscriptionResponse(cartridgeSubscriptionInfo, cartridgeSubscription.getRepository());
    }

    public Collection<CartridgeSubscription> getCartridgeSubscriptions(int tenantId, String type) throws ADCException {
        if (type == null || type.isEmpty()) {
            return new DataInsertionAndRetrievalManager().getCartridgeSubscriptions(tenantId);
        }
        return new DataInsertionAndRetrievalManager().getCartridgeSubscriptions(tenantId, type);
    }

    public CartridgeSubscription getCartridgeSubscription(int tenantId, String subscriptionAlias) {
        return new DataInsertionAndRetrievalManager().getCartridgeSubscription(tenantId, subscriptionAlias);
    }

    public void unsubscribeFromCartridge(String tenantDomain, String alias) throws ADCException, NotSubscribedException {
        DataInsertionAndRetrievalManager dataInsertionAndRetrievalManager = new DataInsertionAndRetrievalManager();
        CartridgeSubscription cartridgeSubscription = dataInsertionAndRetrievalManager.getCartridgeSubscription(CarbonContext.getThreadLocalCarbonContext().getTenantId(), alias);
        if (cartridgeSubscription != null) {
            cartridgeSubscription.removeSubscription();
            try {
                dataInsertionAndRetrievalManager.removeSubscription(cartridgeSubscription.getSubscriber().getTenantId(), alias);
            }
            catch (PersistenceManagerException e) {
                String errorMsg = "Error removing subscription for tenant " + tenantDomain + ", alias " + cartridgeSubscription.getAlias();
                log.error((Object)errorMsg);
                throw new ADCException(errorMsg, e);
            }
        } else {
            String errorMsg = "No cartridge subscription found with [alias] " + alias + " for [tenant] " + tenantDomain;
            log.error((Object)errorMsg);
            throw new NotSubscribedException(errorMsg, alias);
        }
        CartridgeSubscriptionUtils.publishTenantUnSubscribedEvent(cartridgeSubscription.getSubscriber().getTenantId(), cartridgeSubscription.getCartridgeInfo().getType());
        CartridgeSubscriptionDataPublisher.publish(cartridgeSubscription.getSubscriber().getTenantId(), cartridgeSubscription.getSubscriber().getAdminUserName(), cartridgeSubscription.getAlias(), cartridgeSubscription.getType(), "", cartridgeSubscription.getCartridgeInfo().getMultiTenant(), cartridgeSubscription.getAutoscalingPolicyName(), cartridgeSubscription.getDeploymentPolicyName(), cartridgeSubscription.getCluster().getClusterDomain(), cartridgeSubscription.getHostName(), cartridgeSubscription.getMappedDomain(), "unsubscribed");
    }

    private Properties getPersistenceMappingProperties(PersistenceContext persistenceCtxt, CartridgeInfo cartridgeInfo) throws ADCException {
        if (!cartridgeInfo.isPersistenceSpecified()) {
            String errorMsg = "Persistence Mapping not supported by the cartridge type " + cartridgeInfo.getType();
            log.error((Object)errorMsg);
            throw new ADCException(errorMsg);
        }
        Properties persistenceMappingProperties = new Properties();
        persistenceMappingProperties.setProperties(new Property[]{persistenceCtxt.getPersistanceRequiredProperty(), persistenceCtxt.getSizeProperty(), persistenceCtxt.getDeleteOnTerminationProperty()});
        return persistenceMappingProperties;
    }

    public Collection<CartridgeSubscription> isCartridgeSubscribed(int tenantId, String cartridgeType) {
        DataInsertionAndRetrievalManager dataInsertionAndRetrievalManager = new DataInsertionAndRetrievalManager();
        return dataInsertionAndRetrievalManager.getCartridgeSubscriptions(tenantId, cartridgeType);
    }
}

