/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.subscription.utils;

import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.apache.axis2.AxisFault;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.autoscaler.deployment.policy.DeploymentPolicy;
import org.apache.stratos.cloud.controller.stub.pojo.CartridgeInfo;
import org.apache.stratos.cloud.controller.stub.pojo.LoadbalancerConfig;
import org.apache.stratos.cloud.controller.stub.pojo.PortMapping;
import org.apache.stratos.cloud.controller.stub.pojo.Properties;
import org.apache.stratos.cloud.controller.stub.pojo.Property;
import org.apache.stratos.manager.client.AutoscalerServiceClient;
import org.apache.stratos.manager.client.CloudControllerServiceClient;
import org.apache.stratos.manager.dao.Cluster;
import org.apache.stratos.manager.deploy.service.Service;
import org.apache.stratos.manager.exception.ADCException;
import org.apache.stratos.manager.exception.DuplicateCartridgeAliasException;
import org.apache.stratos.manager.exception.InvalidCartridgeAliasException;
import org.apache.stratos.manager.exception.UnregisteredCartridgeException;
import org.apache.stratos.manager.lb.category.LBDataContext;
import org.apache.stratos.manager.payload.BasicPayloadData;
import org.apache.stratos.manager.repository.Repository;
import org.apache.stratos.manager.retriever.DataInsertionAndRetrievalManager;
import org.apache.stratos.manager.subscriber.Subscriber;
import org.apache.stratos.messaging.broker.publish.EventPublisher;
import org.apache.stratos.messaging.broker.publish.EventPublisherPool;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.event.tenant.TenantSubscribedEvent;
import org.apache.stratos.messaging.event.tenant.TenantUnSubscribedEvent;

public class CartridgeSubscriptionUtils {
    private static Log log = LogFactory.getLog(CartridgeSubscriptionUtils.class);

    public static BasicPayloadData createBasicPayload(CartridgeInfo cartridgeInfo, String subscriptionKey, Cluster cluster, Repository repository, String alias, Subscriber subscriber) {
        BasicPayloadData basicPayloadData = new BasicPayloadData();
        basicPayloadData.setApplicationPath(cartridgeInfo.getBaseDir());
        basicPayloadData.setSubscriptionKey(subscriptionKey);
        basicPayloadData.setDeployment("default");
        basicPayloadData.setMultitenant(String.valueOf(cartridgeInfo.getMultiTenant()));
        basicPayloadData.setPortMappings(CartridgeSubscriptionUtils.createPortMappingPayloadString(cartridgeInfo));
        basicPayloadData.setServiceName(cartridgeInfo.getType());
        if (repository != null) {
            basicPayloadData.setGitRepositoryUrl(repository.getUrl());
        }
        if (cluster != null) {
            basicPayloadData.setClusterId(cluster.getClusterDomain());
            basicPayloadData.setHostName(cluster.getHostName());
        }
        if (alias != null) {
            basicPayloadData.setSubscriptionAlias(alias);
        }
        if (subscriber != null) {
            basicPayloadData.setTenantId(subscriber.getTenantId());
        }
        if (cartridgeInfo.getMultiTenant()) {
            basicPayloadData.setTenantRange("*");
        } else if (subscriber != null) {
            basicPayloadData.setTenantRange(String.valueOf(subscriber.getTenantId()));
        }
        return basicPayloadData;
    }

    public static BasicPayloadData createBasicPayload(Service service) {
        BasicPayloadData basicPayloadData = new BasicPayloadData();
        basicPayloadData.setApplicationPath(service.getCartridgeInfo().getBaseDir());
        basicPayloadData.setSubscriptionKey(service.getSubscriptionKey());
        basicPayloadData.setClusterId(service.getClusterId());
        basicPayloadData.setDeployment("default");
        basicPayloadData.setHostName(service.getHostName());
        basicPayloadData.setMultitenant(String.valueOf(service.getCartridgeInfo().getMultiTenant()));
        basicPayloadData.setPortMappings(CartridgeSubscriptionUtils.createPortMappingPayloadString(service.getCartridgeInfo()));
        basicPayloadData.setServiceName(service.getType());
        basicPayloadData.setTenantId(service.getTenantId());
        basicPayloadData.setTenantRange(service.getTenantRange());
        return basicPayloadData;
    }

    private static String createPortMappingPayloadString(CartridgeInfo cartridgeInfo) {
        PortMapping[] portMappings;
        StringBuilder portMapBuilder = new StringBuilder();
        for (PortMapping portMapping : portMappings = cartridgeInfo.getPortMappings()) {
            String port = portMapping.getPort();
            portMapBuilder.append(port).append("|");
        }
        String portMappingString = portMapBuilder.toString().replaceAll("\\|$", "");
        return portMappingString;
    }

    public static String generateSubscriptionKey() {
        String key = RandomStringUtils.randomAlphanumeric((int)16);
        log.info((Object)("Generated key  : " + key));
        return key;
    }

    public static void publishTenantSubscribedEvent(int tenantId, String serviceName) {
        Executor exec = new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        };
        exec.execute(new TenantSubscribedEventPublisher(tenantId, serviceName));
    }

    public static void publishTenantUnSubscribedEvent(int tenantId, String serviceName) {
        block3: {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Publishing tenant un-subscribed event: [tenant-id] %d [service] %s", tenantId, serviceName));
                }
                TenantUnSubscribedEvent event = new TenantUnSubscribedEvent(tenantId, serviceName);
                EventPublisher eventPublisher = EventPublisherPool.getPublisher((String)"tenant");
                eventPublisher.publish((Event)event);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)String.format("Could not publish tenant un-subscribed event: [tenant-id] %d [service] %s", tenantId, serviceName), (Throwable)e);
            }
        }
    }

    public static void validateCartridgeAlias(int tenantId, String cartridgeType, String alias) throws InvalidCartridgeAliasException, DuplicateCartridgeAliasException, ADCException {
        String patternString = "([a-z0-9]+([-][a-z0-9])*)+";
        Pattern pattern = Pattern.compile(patternString);
        if (!pattern.matcher(alias).matches()) {
            String msg = "The alias " + alias + " can contain only alpha-numeric lowercase characters. Please enter a valid alias.";
            log.error((Object)msg);
            throw new InvalidCartridgeAliasException(msg, tenantId, cartridgeType, alias);
        }
        boolean isAliasTaken = false;
        try {
            isAliasTaken = CartridgeSubscriptionUtils.isAliasTaken(tenantId, alias);
        }
        catch (Exception e) {
            String msg = "Exception : " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new ADCException("Error when checking alias is already taken", e);
        }
        if (isAliasTaken) {
            String msg = "The alias " + alias + " is already taken. Please try again with a different alias.";
            log.error((Object)msg);
            throw new DuplicateCartridgeAliasException(msg, cartridgeType, alias);
        }
    }

    public static boolean isAliasTaken(int tenantId, String alias) {
        DataInsertionAndRetrievalManager dataInsertionAndRetrievalManager = new DataInsertionAndRetrievalManager();
        return dataInsertionAndRetrievalManager.getCartridgeSubscriptionForAlias(alias) != null;
    }

    public static String limitLengthOfString(String source, int length) {
        return source.substring(0, length);
    }

    public static LBDataContext getLoadBalancerDataContext(int tenantId, String serviceType, String deploymentPolicyName, LoadbalancerConfig lbConfig) throws UnregisteredCartridgeException, ADCException {
        String lbCartridgeType = lbConfig.getType();
        LBDataContext lbDataCtxt = new LBDataContext();
        lbDataCtxt.setTenantId(tenantId);
        Properties lbReferenceProperties = lbConfig.getProperties();
        Property lbRefProperty = new Property();
        lbRefProperty.setName("load.balancer.ref");
        for (Property prop : lbReferenceProperties.getProperties()) {
            CartridgeInfo lbCartridgeInfo;
            String name = prop.getName();
            String value = prop.getValue();
            if ("no.load.balancer".equals(name)) {
                if (!"true".equals(value)) continue;
                lbDataCtxt.setLbCategory("no.load.balancer");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("This cartridge does not require a load balancer. [Type] " + serviceType));
                }
                lbRefProperty.setValue(name);
                lbDataCtxt.addLoadBalancedServiceProperty(lbRefProperty);
                break;
            }
            if ("existing.load.balancers".equals(name)) {
                String[] clusterIds;
                lbDataCtxt.setLbCategory("existing.load.balancers");
                String clusterIdsVal = value;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("This cartridge refers to existing load balancers. [Type] " + serviceType + "[Referenced Cluster Ids] " + clusterIdsVal));
                }
                for (String clusterId : clusterIds = clusterIdsVal.split(",")) {
                    try {
                        AutoscalerServiceClient.getServiceClient().checkLBExistenceAgainstPolicy(clusterId, deploymentPolicyName);
                    }
                    catch (Exception ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                lbRefProperty.setValue(name);
                lbDataCtxt.addLoadBalancedServiceProperty(lbRefProperty);
                break;
            }
            if ("default.load.balancer".equals(name)) {
                CartridgeInfo lbCartridgeInfo2;
                if (!"true".equals(value)) continue;
                lbDataCtxt.setLbCategory("default.load.balancer");
                lbRefProperty.setValue(name);
                try {
                    lbCartridgeInfo2 = CloudControllerServiceClient.getServiceClient().getCartridgeInfo(lbCartridgeType);
                }
                catch (Exception e) {
                    String message = "Error getting info for " + lbCartridgeType;
                    log.error((Object)message, (Throwable)e);
                    throw new ADCException(message, e);
                }
                if (lbCartridgeInfo2 == null) {
                    String msg = "Please specify a LB cartridge type for the cartridge: " + serviceType + " as category: " + "default.load.balancer";
                    log.error((Object)msg);
                    throw new ADCException(msg);
                }
                lbDataCtxt.setLbCartridgeInfo(lbCartridgeInfo2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("This cartridge uses default load balancer. [Type] " + serviceType));
                }
                try {
                    DeploymentPolicy[] lbCartridgeDepPolicies;
                    for (DeploymentPolicy policy : lbCartridgeDepPolicies = CartridgeSubscriptionUtils.getAutoscalerServiceClient().getDeploymentPolicies(lbCartridgeType)) {
                        if (!deploymentPolicyName.equals(policy.getId()) || CartridgeSubscriptionUtils.getAutoscalerServiceClient().checkDefaultLBExistenceAgainstPolicy(deploymentPolicyName)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(" Default LB doesn't exist for deployment policy [" + deploymentPolicyName + "] "));
                        }
                        Properties lbProperties = new Properties();
                        if (lbCartridgeInfo2.getProperties() != null && lbCartridgeInfo2.getProperties().length > 0) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)" Combining LB properties ");
                            }
                            lbProperties.setProperties(CartridgeSubscriptionUtils.combine(lbCartridgeInfo2.getProperties(), new Property[]{lbRefProperty}));
                        } else {
                            lbProperties.setProperties(new Property[]{lbRefProperty});
                        }
                        lbDataCtxt.addLBProperties(lbProperties);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
                lbDataCtxt.setDeploymentPolicy(deploymentPolicyName);
                lbDataCtxt.setAutoscalePolicy(lbCartridgeInfo2.getDefaultAutoscalingPolicy());
                lbDataCtxt.addLoadBalancedServiceProperty(lbRefProperty);
                break;
            }
            if (!"service.aware.load.balancer".equals(name) || !"true".equals(value)) continue;
            lbDataCtxt.setLbCategory("service.aware.load.balancer");
            lbRefProperty.setValue(name);
            try {
                lbCartridgeInfo = CloudControllerServiceClient.getServiceClient().getCartridgeInfo(lbCartridgeType);
            }
            catch (Exception e) {
                String message = "Error getting info for " + lbCartridgeType;
                log.error((Object)message, (Throwable)e);
                throw new ADCException(message, e);
            }
            if (lbCartridgeInfo == null) {
                String msg = "Please specify a LB cartridge type for the cartridge: " + serviceType + " as category: " + "service.aware.load.balancer";
                log.error((Object)msg);
                throw new ADCException(msg);
            }
            lbDataCtxt.setLbCartridgeInfo(lbCartridgeInfo);
            Property loadBalancedServiceTypeProperty = new Property();
            loadBalancedServiceTypeProperty.setName("load.balanced.service.type");
            loadBalancedServiceTypeProperty.setValue(serviceType);
            if (log.isDebugEnabled()) {
                log.debug((Object)("This cartridge uses a service aware load balancer. [Type] " + serviceType));
            }
            try {
                DeploymentPolicy[] lbCartridgeDepPolicies;
                for (DeploymentPolicy policy : lbCartridgeDepPolicies = CartridgeSubscriptionUtils.getAutoscalerServiceClient().getDeploymentPolicies(lbCartridgeType)) {
                    if (!deploymentPolicyName.equals(policy.getId()) || CartridgeSubscriptionUtils.getAutoscalerServiceClient().checkServiceLBExistenceAgainstPolicy(serviceType, deploymentPolicyName)) continue;
                    Properties lbProperties = new Properties();
                    if (lbCartridgeInfo.getProperties() != null && lbCartridgeInfo.getProperties().length > 0) {
                        lbProperties.setProperties(CartridgeSubscriptionUtils.combine(lbCartridgeInfo.getProperties(), new Property[]{lbRefProperty, loadBalancedServiceTypeProperty}));
                    } else {
                        lbProperties.setProperties(new Property[]{lbRefProperty, loadBalancedServiceTypeProperty});
                    }
                    Property payloadProperty = new Property();
                    payloadProperty.setName("LOAD_BALANCED_SERVICE_TYPE");
                    payloadProperty.setValue(serviceType);
                    lbDataCtxt.addLBProperties(lbProperties);
                }
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            lbDataCtxt.setDeploymentPolicy(deploymentPolicyName);
            lbDataCtxt.setAutoscalePolicy(lbCartridgeInfo.getDefaultAutoscalingPolicy());
            lbDataCtxt.addLoadBalancedServiceProperty(lbRefProperty);
            break;
        }
        return lbDataCtxt;
    }

    private static AutoscalerServiceClient getAutoscalerServiceClient() throws ADCException {
        try {
            return AutoscalerServiceClient.getServiceClient();
        }
        catch (AxisFault axisFault) {
            String errorMsg = "Error in getting AutoscalerServiceClient instance";
            log.error((Object)errorMsg, (Throwable)axisFault);
            throw new ADCException(errorMsg, axisFault);
        }
    }

    private static Property[] combine(Property[] propertyArray1, Property[] propertyArray2) {
        int length = propertyArray1.length + propertyArray2.length;
        Property[] combinedProperties = new Property[length];
        System.arraycopy(propertyArray1, 0, combinedProperties, 0, propertyArray1.length);
        System.arraycopy(propertyArray2, 0, combinedProperties, propertyArray1.length, propertyArray2.length);
        return combinedProperties;
    }

    static class TenantSubscribedEventPublisher
    implements Runnable {
        int tenantId;
        String serviceName;

        public TenantSubscribedEventPublisher(int tenantId, String service) {
            this.tenantId = tenantId;
            this.serviceName = service;
        }

        @Override
        public void run() {
            block3: {
                try {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Publishing tenant subscribed event: [tenant-id] %d [service] %s", this.tenantId, this.serviceName));
                    }
                    TenantSubscribedEvent subscribedEvent = new TenantSubscribedEvent(this.tenantId, this.serviceName);
                    EventPublisher eventPublisher = EventPublisherPool.getPublisher((String)"tenant");
                    eventPublisher.publish((Event)subscribedEvent);
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)String.format("Could not publish tenant subscribed event: [tenant-id] %d [service] %s", this.tenantId, this.serviceName), (Throwable)e);
                }
            }
        }
    }
}

