/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.utils;

import com.gitblit.Constants;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.RpcUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.service.RepositoryInfoBean;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class RepositoryCreator
implements Runnable {
    private static final Log log = LogFactory.getLog(RepositoryCreator.class);
    private RepositoryInfoBean repoInfoBean;

    public RepositoryCreator(RepositoryInfoBean repoInfoBean) {
        this.repoInfoBean = repoInfoBean;
    }

    @Override
    public void run() {
        if (this.repoInfoBean != null) {
            try {
                this.createRepository(this.repoInfoBean.getCartridgeAlias(), this.repoInfoBean.getTenantDomain(), this.repoInfoBean.getUserName(), this.repoInfoBean.getPassword());
                this.createGitFolderStructure(this.repoInfoBean.getTenantDomain(), this.repoInfoBean.getCartridgeAlias(), this.repoInfoBean.getDirArray());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public org.apache.stratos.manager.repository.Repository createInternalRepository() throws Exception {
        org.apache.stratos.manager.repository.Repository repo = null;
        if (this.repoInfoBean != null) {
            try {
                repo = this.createRepository(this.repoInfoBean.getCartridgeAlias(), this.repoInfoBean.getTenantDomain(), this.repoInfoBean.getUserName(), this.repoInfoBean.getPassword());
                if (this.repoInfoBean.getDirArray() != null && this.repoInfoBean.getDirArray().length > 0) {
                    this.createGitFolderStructure(this.repoInfoBean.getTenantDomain(), this.repoInfoBean.getCartridgeAlias(), this.repoInfoBean.getDirArray());
                }
            }
            catch (Exception e) {
                String errorMsg = "Creating an internal repository failed for tenant " + this.repoInfoBean.getTenantDomain();
                log.error((Object)errorMsg, (Throwable)e);
                throw new Exception(errorMsg, e);
            }
        }
        return repo;
    }

    private org.apache.stratos.manager.repository.Repository createRepository(String cartridgeName, String tenantDomain, String userName, String password) throws Exception {
        org.apache.stratos.manager.repository.Repository repository = new org.apache.stratos.manager.repository.Repository();
        String repoName = tenantDomain + "/" + cartridgeName;
        try {
            log.info((Object)("Creating internal repo [" + repoName + "] "));
            RepositoryModel model = new RepositoryModel();
            model.name = repoName;
            model.accessRestriction = Constants.AccessRestrictionType.VIEW;
            char[] passwordArr = password.toCharArray();
            boolean isSuccess = RpcUtils.createRepository((RepositoryModel)model, (String)System.getProperty("internal.git.url"), (String)userName, (char[])passwordArr);
            if (!isSuccess) {
                throw new Exception("Exception is occurred when creating an internal git repo. ");
            }
        }
        catch (Exception e) {
            log.error((Object)(" Exception is occurred when creating an internal git repo. Reason :" + e.getMessage()));
            this.handleException(e.getMessage(), e);
        }
        repository.setUrl(System.getProperty("internal.git.url") + repoName);
        repository.setUserName(userName);
        repository.setPassword(password);
        log.info((Object)("Repository is created. : " + repository));
        return repository;
    }

    private void createGitFolderStructure(String tenantDomain, String cartridgeName, String[] dirArray) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating git repo folder structure  ");
        }
        String parentDirName = "/tmp/" + UUID.randomUUID().toString();
        UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(System.getProperty("internal.repo.username"), System.getProperty("internal.repo.password").toCharArray());
        FileRepository localRepo = null;
        try {
            localRepo = new FileRepository(new File(parentDirName + "/.git"));
        }
        catch (IOException e) {
            log.error((Object)("Exception occurred in creating a new file repository. Reason: " + e.getMessage()));
            throw e;
        }
        Git git = new Git((Repository)localRepo);
        CloneCommand cloneCmd = git.cloneRepository().setURI(System.getProperty("internal.git.url") + tenantDomain + "/" + cartridgeName + ".git").setDirectory(new File(parentDirName));
        cloneCmd.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        try {
            log.debug((Object)"Clonning git repo");
            cloneCmd.call();
        }
        catch (Exception e1) {
            log.error((Object)("Exception occurred in cloning Repo. Reason: " + e1.getMessage()));
            throw e1;
        }
        File parentDir = new File(parentDirName);
        parentDir.mkdir();
        for (String string : dirArray) {
            String[] arr = string.split("=");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating dir: " + arr[0]));
            }
            File parentFile = new File(parentDirName + "/" + arr[0]);
            parentFile.mkdirs();
            File filess = new File(parentFile, "README");
            String content = "Content goes here";
            filess.createNewFile();
            FileWriter fw = new FileWriter(filess.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(content);
            bw.close();
        }
        StatusCommand s = git.status();
        Status status = null;
        try {
            log.debug((Object)"Getting git repo status");
            status = s.call();
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred in git status check. Reason: " + e.getMessage()));
            throw e;
        }
        AddCommand addCmd = git.add();
        Iterator it = status.getUntracked().iterator();
        while (it.hasNext()) {
            addCmd.addFilepattern((String)it.next());
        }
        try {
            log.debug((Object)"Adding files to git repo");
            addCmd.call();
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred in adding files. Reason: " + e.getMessage()));
            throw e;
        }
        CommitCommand commitCmd = git.commit();
        commitCmd.setMessage("Adding directories");
        try {
            log.debug((Object)"Committing git repo");
            commitCmd.call();
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred in committing . Reason: " + e.getMessage()));
            throw e;
        }
        PushCommand pushCmd = git.push();
        pushCmd.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        try {
            log.debug((Object)"Git repo push");
            pushCmd.call();
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred in Git push . Reason: " + e.getMessage()));
            throw e;
        }
        try {
            this.deleteDirectory(new File(parentDirName));
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred in deleting temp files. Reason: " + e.getMessage()));
            throw e;
        }
        log.info((Object)" Folder structure  is created ..... ");
    }

    private void handleException(String msg, Exception e) throws Exception {
        log.error((Object)msg, (Throwable)e);
        throw new Exception(msg, e);
    }

    private void deleteDirectory(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                String[] files;
                for (String temp : files = file.list()) {
                    File fileDelete = new File(file, temp);
                    this.deleteDirectory(fileDelete);
                }
                if (file.list().length == 0) {
                    file.delete();
                }
            }
        } else {
            file.delete();
        }
    }
}

