/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.utils;

import java.util.UUID;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.management.GroupManagementCommand;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.CarbonAxisConfigurator;
import org.wso2.carbon.core.multitenancy.TenantAxisConfigurator;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;

public class SynchronizeRepositoryRequest
extends GroupManagementCommand {
    private static final long serialVersionUID = 8717694086109561127L;
    private static final transient Log log = LogFactory.getLog(SynchronizeRepositoryRequest.class);
    private int tenantId;
    private String tenantDomain;
    private UUID messageId;

    public SynchronizeRepositoryRequest() {
    }

    public SynchronizeRepositoryRequest(int tenantId, String tenantDomain, UUID messageId) {
        this.tenantId = tenantId;
        this.tenantDomain = tenantDomain;
        this.messageId = messageId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public void execute(ConfigurationContext configContext) throws ClusteringFault {
        log.info((Object)("Received  [" + (Object)((Object)this) + "] "));
        if (this.tenantId == -1234 || TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)configContext).get(this.tenantDomain) != null) {
            this.updateDeploymentRepository(configContext);
            this.doDeployment(configContext);
        }
    }

    private void doDeployment(ConfigurationContext configContext) {
        AxisConfigurator axisConfigurator = configContext.getAxisConfiguration().getConfigurator();
        if (axisConfigurator instanceof CarbonAxisConfigurator) {
            ((CarbonAxisConfigurator)axisConfigurator).runDeployment();
        } else if (axisConfigurator instanceof TenantAxisConfigurator) {
            ((TenantAxisConfigurator)axisConfigurator).runDeployment();
        }
    }

    private void updateDeploymentRepository(ConfigurationContext configContext) {
        log.info((Object)" Update Deployment Repo...");
    }

    private void setRepoUpdateFailed(ConfigurationContext configContext) {
        AxisConfigurator axisConfigurator = configContext.getAxisConfiguration().getConfigurator();
        if (axisConfigurator instanceof CarbonAxisConfigurator) {
            ((CarbonAxisConfigurator)axisConfigurator).setRepoUpdateFailed();
        } else if (axisConfigurator instanceof TenantAxisConfigurator) {
            ((TenantAxisConfigurator)axisConfigurator).setRepoUpdateFailed();
        }
    }

    public ClusteringCommand getResponse() {
        return null;
    }

    public String toString() {
        return "SynchronizeRepositoryRequest{tenantId=" + this.tenantId + ", tenantDomain='" + this.tenantDomain + '\'' + ", messageId=" + this.messageId + '}';
    }
}

