/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.validate.domain.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.util.CommonUtil;
import org.apache.stratos.validate.domain.internal.ValidateDomainServiceComponent;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class Util {
    private static final Log log = LogFactory.getLog(Util.class);
    private static RegistryService registryService;
    private static RealmService realmService;

    public static synchronized void setRegistryService(RegistryService service) {
        if (registryService == null) {
            registryService = service;
        }
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static synchronized void setRealmService(RealmService service) {
        if (realmService == null) {
            realmService = service;
        }
    }

    public static TenantManager getTenantManager() {
        return realmService.getTenantManager();
    }

    public static UserRegistry getGovernanceSystemRegistry(int tenantId) throws RegistryException {
        return registryService.getGovernanceSystemRegistry(tenantId);
    }

    public static boolean validateContent(String sourceURL, String content) throws RegistryException {
        URL url;
        try {
            if (sourceURL != null && sourceURL.toLowerCase().startsWith("file:")) {
                String msg = "The source URL must not be file in the server's local file system";
                throw new RegistryException(msg);
            }
            url = new URL(sourceURL);
        }
        catch (MalformedURLException e) {
            String msg = "Given source URL " + sourceURL + "is not valid.";
            throw new RegistryException(msg, (Throwable)e);
        }
        try {
            URLConnection uc = url.openConnection();
            InputStream in = uc.getInputStream();
            byte[] inByteArr = RegistryUtils.getByteArray((InputStream)in);
            String onlineContent = new String(inByteArr);
            return onlineContent.startsWith(content);
        }
        catch (IOException e) {
            String msg = "Could not read from the given URL: " + sourceURL;
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public static boolean checkDomainAvailability(String domainName) throws RegistryException {
        int tenantId;
        TenantManager tenantManager = Util.getTenantManager();
        try {
            tenantId = tenantManager.getTenantId(domainName);
        }
        catch (UserStoreException e) {
            String msg = "Error in checking the domain availability.";
            log.error((Object)msg);
            tenantId = -1;
        }
        return tenantId < 0;
    }

    public static boolean checkDomainValidity(String domain) {
        return !domain.contains("/") && !domain.contains("\\");
    }

    public static String getDomainValidationKeyWithoutLogin(String domain) throws RegistryException {
        return Util.generateDomainValidateKey(domain);
    }

    public static String getDomainValidationKeyWithLogin(String domain) throws RegistryException {
        String domainValidatorInfoPath;
        UserRegistry governanceSystemRegistry = Util.getGovernanceSystemRegistry(-1234);
        if (governanceSystemRegistry.resourceExists(domainValidatorInfoPath = "/repository/components/org.wso2.carbon.domain-validator-info/" + domain + "/" + "validation-key")) {
            Resource resource = governanceSystemRegistry.get(domainValidatorInfoPath);
            Object contentObj = resource.getContent();
            if (contentObj instanceof String) {
                return (String)contentObj;
            }
            if (contentObj instanceof byte[]) {
                return new String((byte[])contentObj);
            }
        }
        return Util.generateDomainValidateKey(domain);
    }

    private static String generateDomainValidateKey(String domain) throws RegistryException {
        UserRegistry governanceSystemRegistry = Util.getGovernanceSystemRegistry(-1234);
        String domainValidatorInfoPath = "/repository/components/org.wso2.carbon.domain-validator-info/" + domain + "/" + "validation-key";
        String domainValidationKey = UUIDGenerator.generateUUID();
        Resource resource = governanceSystemRegistry.newResource();
        resource.setContent((Object)domainValidationKey);
        ((ResourceImpl)resource).setVersionableChange(false);
        governanceSystemRegistry.put(domainValidatorInfoPath, resource);
        CommonUtil.setAnonAuthorization((String)("/_system/governance" + domainValidatorInfoPath), (UserRealm)governanceSystemRegistry.getUserRealm());
        return domainValidationKey;
    }

    public static String validateByDNSEntry(String domain) throws RegistryException {
        if (!Util.checkDomainValidity(domain)) {
            return "false";
        }
        UserRegistry governanceSystemRegistry = Util.getGovernanceSystemRegistry(-1234);
        String domainValidatorInfoPath = "/repository/components/org.wso2.carbon.domain-validator-info/" + domain + "/" + "validation-key";
        String domainValidationKey = "";
        if (!governanceSystemRegistry.resourceExists(domainValidatorInfoPath)) {
            return "false";
        }
        Resource resource = governanceSystemRegistry.get(domainValidatorInfoPath);
        Object content = resource.getContent();
        if (content instanceof String) {
            domainValidationKey = (String)content;
        } else if (content instanceof byte[]) {
            domainValidationKey = new String((byte[])content);
        }
        int httpPort = CarbonUtils.getTransportPort((ConfigurationContextService)ValidateDomainServiceComponent.getConfigContextService(), (String)"http");
        int httpProxyPort = CarbonUtils.getTransportProxyPort((ConfigurationContext)ValidateDomainServiceComponent.getConfigContextService().getServerConfigContext(), (String)"http");
        int portValue = httpProxyPort != -1 ? httpProxyPort : httpPort;
        String domainValidatorInfoAbsolutePath = RegistryUtils.getAbsolutePath((RegistryContext)governanceSystemRegistry.getRegistryContext(), (String)("/_system/governance" + domainValidatorInfoPath));
        String sourceUrl = "http://" + domainValidationKey + "." + domain + ":" + portValue + "/" + "registry" + "/" + "resource" + domainValidatorInfoAbsolutePath;
        if (Util.validateContent(sourceUrl, domainValidationKey)) {
            String successKey = UUIDGenerator.generateUUID();
            resource.setProperty("successKey", successKey);
            ((ResourceImpl)resource).setVersionableChange(false);
            governanceSystemRegistry.put(domainValidatorInfoPath, resource);
            return successKey;
        }
        return "false";
    }

    public static String validateByTextInRoot(String domain) throws RegistryException {
        if (!Util.checkDomainValidity(domain)) {
            return "false";
        }
        UserRegistry governanceSystemRegistry = Util.getGovernanceSystemRegistry(-1234);
        String domainValidatorInfoPath = "/repository/components/org.wso2.carbon.domain-validator-info/" + domain + "/" + "validation-key";
        String domainValidationKey = "";
        if (!governanceSystemRegistry.resourceExists(domainValidatorInfoPath)) {
            return "false";
        }
        Resource resource = governanceSystemRegistry.get(domainValidatorInfoPath);
        Object content = resource.getContent();
        if (content instanceof String) {
            domainValidationKey = (String)content;
        } else if (content instanceof byte[]) {
            domainValidationKey = new String((byte[])content);
        }
        String sourceUrl = "http://" + domain + "/wso2multitenancy.txt";
        if (Util.validateContent(sourceUrl, domainValidationKey)) {
            String successKey = UUIDGenerator.generateUUID();
            resource.setProperty("successKey", successKey);
            ((ResourceImpl)resource).setVersionableChange(false);
            governanceSystemRegistry.put(domainValidatorInfoPath, resource);
            return successKey;
        }
        return "false";
    }
}

