/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.core.nvp;

import com.paypal.sdk.core.APICallerBase;
import com.paypal.sdk.core.nvp.NVPDecoder;
import com.paypal.sdk.core.nvp.NVPEncoder;
import com.paypal.sdk.core.nvp.NVPSSLSocketFactory;
import com.paypal.sdk.exceptions.FatalException;
import com.paypal.sdk.exceptions.PayPalException;
import com.paypal.sdk.exceptions.TransactionException;
import com.paypal.sdk.exceptions.WarningException;
import com.paypal.sdk.profiles.APIProfile;
import com.paypal.sdk.profiles.CertificateAPIProfile;
import com.paypal.sdk.profiles.PermissionAPIProfile;
import com.paypal.sdk.profiles.SignatureAPIProfile;
import com.paypal.sdk.profiles.UniPayAPIProfile;
import com.paypal.sdk.util.MessageResources;
import com.paypal.sdk.util.Util;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NVPAPICaller
extends APICallerBase {
    private static Log log = LogFactory.getLog(NVPAPICaller.class);
    private URL url;
    private String header;
    private HttpConnectionManagerParams params;
    private Protocol myhttps;
    private int maximumRetries;
    private static final QName service = new QName("PayPalAPI");
    private String permissionHeader;

    @Override
    protected void validateProfile(APIProfile _profile) throws PayPalException {
        ArrayList<String> errors = new ArrayList<String>();
        if (Util.isEmpty(_profile.getEnvironment())) {
            errors.add(MessageResources.getMessage("API_ENVIRONMENT_EMPTY"));
        }
        if (_profile instanceof CertificateAPIProfile) {
            if (Util.isEmpty(_profile.getCertificateFile())) {
                errors.add(MessageResources.getMessage("API_CERTIFICATE_FILE_EMPTY"));
            } else {
                File file = new File(_profile.getCertificateFile());
                if (!file.exists()) {
                    errors.add(MessageResources.getMessage("API_CERTIFICATE_FILE_MISSING"));
                }
            }
            if (_profile.getPrivateKeyPassword() == null) {
                errors.add(MessageResources.getMessage("API_PRIVATE_KEY_PASSWORD_EMPTY"));
            }
        }
        if (_profile instanceof UniPayAPIProfile && Util.isEmpty(_profile.getFirstPartyEmail())) {
            errors.add("email is empty");
        }
        if (_profile instanceof SignatureAPIProfile) {
            if (Util.isEmpty(_profile.getAPIUsername())) {
                errors.add(MessageResources.getMessage("API_APIUSERNAME_EMPTY"));
            }
            if (Util.isEmpty(_profile.getAPIPassword())) {
                errors.add(MessageResources.getMessage("API_APIPASSWORD_EMPTY"));
            }
            if (Util.isEmpty(_profile.getSignature())) {
                errors.add(MessageResources.getMessage("API_SIGNATURE_EMPTY"));
            }
        }
        if (_profile instanceof PermissionAPIProfile) {
            if (Util.isEmpty(_profile.getOauth_Signature())) {
                errors.add(MessageResources.getMessage("API_PERMISSION_SIGNATURE_EMPTY"));
            }
            if (Util.isEmpty(_profile.getOauth_Timestamp())) {
                errors.add(MessageResources.getMessage("API_PERMISSION_TIMESTAMP_EMPTY"));
            }
            if (Util.isEmpty(_profile.getOauth_Token())) {
                errors.add(MessageResources.getMessage("API_PERMISSION_TOKEN_EMPTY"));
            }
        }
        if (!errors.isEmpty()) {
            StringBuffer msg = new StringBuffer(MessageResources.getMessage("PROFILE_INVALID"));
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                msg.append("\n" + (String)iterator.next());
            }
            throw new TransactionException(msg.toString());
        }
    }

    @Override
    public final synchronized void setupConnection(APIProfile _profile) throws PayPalException {
        super.setupConnection(_profile);
        String endpointUrl = null;
        boolean stage = Util.isStage(_profile.getEnvironment());
        endpointUrl = stage ? "https://api." + _profile.getEnvironment() + ".paypal.com/nvp" : this.getEndpointUrl(_profile, service);
        if (endpointUrl == null & Util.isEmpty(endpointUrl)) {
            throw new TransactionException(MessageFormat.format(MessageResources.getMessage("ENDPOINT_NOT_FOUND"), _profile.getEnvironment(), service.getLocalPart()));
        }
        try {
            this.url = new URL(endpointUrl);
        }
        catch (Exception e) {
            throw new TransactionException(MessageFormat.format(MessageResources.getMessage("ENDPOINT_INVALID"), endpointUrl));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format(MessageResources.getMessage("CONNECTION_OPEN"), service.getLocalPart(), endpointUrl));
        }
        NVPEncoder encoder = null;
        if (_profile instanceof PermissionAPIProfile) {
            StringBuffer authString = new StringBuffer();
            authString.append("token=" + _profile.getOauth_Token());
            authString.append(",");
            authString.append("signature=" + _profile.getOauth_Signature());
            authString.append(",");
            authString.append("timestamp=" + _profile.getOauth_Timestamp());
            this.permissionHeader = authString.toString();
            encoder = new NVPEncoder();
        } else {
            encoder = this.setCorrectProfile(_profile);
        }
        encoder.add("SOURCE", "PAYPAL_JAVA_SDK_65.1");
        this.header = encoder.encode();
        this.params = new HttpConnectionManagerParams();
        if (_profile.getTimeout() > 0) {
            this.params.setConnectionTimeout(_profile.getTimeout());
        } else {
            this.params.setConnectionTimeout(360000);
        }
        this.maximumRetries = _profile.getMaximumRetries();
        this.myhttps = new Protocol("https", (SecureProtocolSocketFactory)new NVPSSLSocketFactory(String.valueOf(this.hashCode())), 443);
    }

    private NVPEncoder setCorrectProfile(APIProfile _profile) {
        NVPEncoder encoder = new NVPEncoder();
        if (_profile instanceof UniPayAPIProfile && !Util.isEmpty(_profile.getFirstPartyEmail())) {
            encoder.add("SUBJECT", _profile.getFirstPartyEmail());
            return encoder;
        }
        if (!Util.isEmpty(_profile.getAPIUsername())) {
            encoder.add("USER", _profile.getAPIUsername());
        }
        if (!Util.isEmpty(_profile.getAPIPassword())) {
            encoder.add("PWD", _profile.getAPIPassword());
        }
        if (!Util.isEmpty(_profile.getSubject())) {
            encoder.add("SUBJECT", _profile.getSubject());
        }
        if (_profile instanceof SignatureAPIProfile && !Util.isEmpty(_profile.getSignature())) {
            encoder.add("SIGNATURE", _profile.getSignature());
        }
        return encoder;
    }

    public final String call(String payload) throws PayPalException {
        if (this.url == null) {
            throw new WarningException(MessageResources.getMessage("NO_PROFILE_SET"));
        }
        PostMethod httppost = null;
        try {
            int result;
            SimpleHttpConnectionManager manager = new SimpleHttpConnectionManager();
            manager.setParams(this.params);
            HttpClient httpclient = new HttpClient((HttpConnectionManager)manager);
            httpclient.getHostConfiguration().setHost(this.url.getHost(), 443, this.myhttps);
            httpclient.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(this.maximumRetries, false));
            if ("true".equalsIgnoreCase((String)System.getProperties().get("https.proxySet"))) {
                String host = (String)System.getProperties().get("https.proxyHost");
                int port = Integer.parseInt((String)System.getProperties().get("https.proxyPort"));
                httpclient.getHostConfiguration().setProxy(host, port);
                String username = (String)System.getProperties().get("https.proxyUser");
                String password = (String)System.getProperties().get("https.proxyPassword");
                if (username != null && password != null) {
                    UsernamePasswordCredentials userCredential = new UsernamePasswordCredentials(username, password);
                    httpclient.getState().setProxyCredentials(new AuthScope(host, port), (Credentials)userCredential);
                }
            }
            httppost = new PostMethod(this.url.getPath());
            Date startTime = new Date();
            if (this.permissionHeader != null && this.permissionHeader.length() > 0) {
                httppost.addRequestHeader("X_PP_AUTHORIZATION", this.permissionHeader);
            }
            StringBuffer request = new StringBuffer(payload);
            request.append("&");
            request.append(this.header);
            if (request.indexOf("VERSION") == -1) {
                request.append("&VERSION=65.1");
            }
            httppost.setRequestEntity((RequestEntity)new StringRequestEntity(request.toString(), "text/html", "UTF-8"));
            if (log.isInfoEnabled()) {
                NVPDecoder decoder = new NVPDecoder();
                String requestmask = request.toString();
                decoder.decode(requestmask);
                if (!Util.isEmpty(decoder.get("PWD"))) {
                    requestmask = requestmask.replaceAll(decoder.get("PWD"), "******");
                }
                if (!Util.isEmpty(decoder.get("SIGNATURE"))) {
                    requestmask = requestmask.replaceAll(decoder.get("SIGNATURE"), "**********");
                }
                if (!Util.isEmpty(decoder.get("CVV2"))) {
                    requestmask = requestmask.replaceAll(decoder.get("CVV2"), "****");
                }
                if (!Util.isEmpty(decoder.get("ACCT"))) {
                    requestmask = requestmask.replaceAll(decoder.get("ACCT"), "****************");
                }
                log.info((Object)MessageFormat.format(MessageResources.getMessage("TRANSACTION_SENT"), requestmask));
            }
            if ((result = httpclient.executeMethod((HttpMethod)httppost)) != 200) {
                throw new FatalException("HTTP Error code " + result + " received, transaction not submitted");
            }
            String response = httppost.getResponseBodyAsString();
            if (log.isInfoEnabled()) {
                Date endTime = new Date();
                log.info((Object)MessageFormat.format(MessageResources.getMessage("TRANSACTION_RESULT"), response, String.valueOf(result), new Long(endTime.getTime() - startTime.getTime())));
            }
            String string = response;
            return string;
        }
        catch (Exception e) {
            throw new FatalException(MessageResources.getMessage("TRANSACTION_FAILED"), e);
        }
        finally {
            httppost.releaseConnection();
        }
    }

    static {
        NVPAPICaller.readEndpoints("wsdl/paypal-endpoints-nvp.xml");
    }
}

