/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.profiles;

import com.paypal.sdk.exceptions.FatalException;
import com.paypal.sdk.exceptions.PayPalException;
import com.paypal.sdk.exceptions.WarningException;
import com.paypal.sdk.profiles.APIProfile;
import com.paypal.sdk.profiles.EWPProfile;
import com.paypal.sdk.profiles.ProfileHandler;
import com.paypal.sdk.profiles.Profiles;
import com.paypal.sdk.util.MessageResources;
import java.text.MessageFormat;
import java.util.List;

public class ProfilesManager {
    private static ProfilesManager profilesManager;
    private static final String handlerName = "com.paypal.sdk.profiles.DefaultProfileHandler";
    private ProfileHandler profileHandler;
    private Profiles profiles = new Profiles();

    protected ProfilesManager() throws PayPalException {
        this.profileHandler = this.loadHandler(handlerName);
    }

    public static synchronized ProfilesManager getInstance() throws PayPalException {
        if (profilesManager == null) {
            profilesManager = new ProfilesManager();
        }
        return profilesManager;
    }

    public void retrieve() throws PayPalException {
        this.profiles = this.profileHandler.retrieve();
    }

    public void store() throws PayPalException {
        this.profileHandler.store(this.profiles);
    }

    public void store(Profiles profiles) throws PayPalException {
        this.profileHandler.store(profiles);
    }

    public APIProfile getAPIProfile(int index) throws PayPalException {
        if (index < 0 || index >= this.profiles.getAPIProfiles().size()) {
            throw new WarningException(MessageFormat.format(MessageResources.getMessage("INDEX_OUT_OF_RANGE"), "" + index, "" + this.profiles.getAPIProfiles().size()));
        }
        return (APIProfile)this.profiles.getAPIProfiles().get(index);
    }

    public APIProfile getAPIProfile(String apiUsername) throws PayPalException {
        for (APIProfile profile : this.profiles.getAPIProfiles()) {
            if (!profile.getAPIUsername().equalsIgnoreCase(apiUsername)) continue;
            return profile;
        }
        throw new WarningException(MessageFormat.format(MessageResources.getMessage("PROFILE_DOES_NOT_EXIST"), apiUsername));
    }

    public EWPProfile getEWPProfile(int index) throws PayPalException {
        if (index < 0 || index >= this.profiles.getEWPProfiles().size()) {
            throw new WarningException(MessageFormat.format(MessageResources.getMessage("INDEX_OUT_OF_RANGE"), "" + index, "" + this.profiles.getEWPProfiles().size()));
        }
        return (EWPProfile)this.profiles.getEWPProfiles().get(index);
    }

    public void addAPIProfile(APIProfile profile) throws PayPalException {
        this.profiles.getAPIProfiles().add(profile);
    }

    public void addAPIProfile(int index, APIProfile profile) throws PayPalException {
        if (index < 0 || index > this.profiles.getAPIProfiles().size()) {
            throw new WarningException(MessageFormat.format(MessageResources.getMessage("INDEX_OUT_OF_RANGE"), "" + index, "" + this.profiles.getAPIProfiles().size()));
        }
        this.profiles.getAPIProfiles().set(index, profile);
    }

    public void addEWPProfile(EWPProfile profile) throws PayPalException {
        this.profiles.getEWPProfiles().add(profile);
    }

    public void addEWPProfile(int index, EWPProfile profile) throws PayPalException {
        if (index < 0 || index > this.profiles.getAPIProfiles().size()) {
            throw new WarningException(MessageFormat.format(MessageResources.getMessage("INDEX_OUT_OF_RANGE"), "" + index, "" + this.profiles.getEWPProfiles().size()));
        }
        this.profiles.getEWPProfiles().set(index, profile);
    }

    public void deleteAPIProfile(int index) throws PayPalException {
        if (index < 0 || index >= this.profiles.getAPIProfiles().size()) {
            throw new WarningException(MessageFormat.format(MessageResources.getMessage("INDEX_OUT_OF_RANGE"), "" + index, "" + this.profiles.getAPIProfiles().size()));
        }
        this.profiles.getAPIProfiles().remove(index);
    }

    public void deleteEWPProfile(int index) throws PayPalException {
        if (index < 0 || index >= this.profiles.getEWPProfiles().size()) {
            throw new WarningException(MessageFormat.format(MessageResources.getMessage("INDEX_OUT_OF_RANGE"), "" + index, "" + this.profiles.getEWPProfiles().size()));
        }
        this.profiles.getEWPProfiles().remove(index);
    }

    public boolean isEmpty() {
        return this.profiles.isEmpty();
    }

    public void clean() {
        this.profiles.clear();
    }

    public List getAPIProfiles() {
        return this.profiles.getAPIProfiles();
    }

    public List getEWPProfiles() {
        return this.profiles.getEWPProfiles();
    }

    private ProfileHandler loadHandler(String className) throws PayPalException {
        try {
            Class<?> handlerClass = Class.forName(className);
            return (ProfileHandler)handlerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new FatalException(MessageResources.getMessage("PROFILE_HANDLER_CLASS_MISSING") + ": " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new FatalException(MessageResources.getMessage("PROFILE_HANDLER_CLASS_LOADER") + ": " + className, e);
        }
        catch (InstantiationException e) {
            throw new FatalException(MessageResources.getMessage("PROFILE_HANDLER_CLASS_CREATE") + ": " + className, e);
        }
        catch (ClassCastException e) {
            throw new FatalException(MessageResources.getMessage("PROFILE_HANDLER_CLASS_MISSING") + ": " + className, e);
        }
    }
}

