/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.business.messaging.paypal.integration;

import com.paypal.sdk.exceptions.PayPalException;
import com.paypal.sdk.profiles.APIProfile;
import com.paypal.sdk.profiles.ProfileFactory;
import com.paypal.soap.api.AbstractRequestType;

public abstract class AbstractProxy<T> {
    protected String operation;
    protected APIProfile profile;
    protected String version = "51.0";
    protected String environment = "sandbox";

    public AbstractProxy(String apiUsername, String apiPassword, String apiSignature) throws PayPalException {
        this.profile = ProfileFactory.createSignatureAPIProfile();
        this.profile.setAPIUsername(apiUsername);
        this.profile.setAPIPassword(apiPassword);
        this.profile.setSignature(apiSignature);
        this.profile.setEnvironment(this.environment);
    }

    public AbstractProxy(APIProfile profile) throws PayPalException {
        this.profile = profile;
    }

    public abstract T call(String var1, AbstractRequestType var2) throws PayPalException;

    public abstract T call(String var1) throws PayPalException;

    public void setAPIVersion(String version) {
        this.version = version;
    }

    public void setEnvironment(String env) {
        this.environment = env;
        this.profile.setEnvironment(this.environment);
    }
}

