/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.business.messaging.paypal.integration;

import com.paypal.sdk.core.nvp.NVPDecoder;
import com.paypal.sdk.core.nvp.NVPEncoder;
import com.paypal.sdk.exceptions.PayPalException;
import com.paypal.sdk.profiles.APIProfile;
import com.paypal.sdk.services.NVPCallerServices;
import com.paypal.soap.api.AbstractRequestType;
import com.paypal.soap.api.AbstractResponseType;
import org.wso2.carbon.business.messaging.paypal.integration.AbstractProxy;

public class PaypalNVPProxy
extends AbstractProxy {
    private NVPCallerServices caller;
    private NVPEncoder encoder;
    private NVPDecoder decoder = new NVPDecoder();

    private PaypalNVPProxy(APIProfile profile) throws PayPalException {
        super(profile);
        this.caller = new NVPCallerServices();
        this.caller.setAPIProfile(this.profile);
    }

    private PaypalNVPProxy(String apiUsername, String apiPassword) throws PayPalException {
        this(apiUsername, apiPassword, null);
    }

    private PaypalNVPProxy(String apiUsername, String apiPassword, String apiSignature) throws PayPalException {
        super(apiUsername, apiPassword, apiSignature);
        this.caller = new NVPCallerServices();
        this.caller.setAPIProfile(this.profile);
    }

    public String call(String operation) throws PayPalException {
        this.encoder.add("METHOD", operation);
        String NVPRequest = this.encoder.encode();
        String NVPResponse = this.caller.call(NVPRequest);
        this.decoder.decode(NVPResponse);
        return NVPResponse;
    }

    public AbstractResponseType call(String operation, AbstractRequestType request) {
        return null;
    }

    public void setEncoder(NVPEncoder encoder) {
        this.encoder = encoder;
        this.encoder.add("VERSION", this.version);
    }

    public NVPDecoder getDecoder() {
        return this.decoder;
    }

    public boolean isSuccess() {
        return Boolean.getBoolean(this.decoder.get("ACK"));
    }

    public static PaypalNVPProxy createPaypalNVPProxy(APIProfile profile) throws PayPalException {
        return new PaypalNVPProxy(profile);
    }

    public static PaypalNVPProxy createPaypalNVPProxy(String apiUsername, String apiPassword) throws PayPalException {
        return new PaypalNVPProxy(apiUsername, apiPassword);
    }

    public static PaypalNVPProxy createPaypalNVPProxy(String apiUsername, String apiPassword, String apiSignature) throws PayPalException {
        return new PaypalNVPProxy(apiUsername, apiPassword, apiSignature);
    }
}

