/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.services.mgt.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.stratos.common.config.CloudServiceConfig;
import org.apache.stratos.common.config.CloudServicesDescConfig;
import org.apache.stratos.manager.services.mgt.beans.CloudService;
import org.apache.stratos.manager.services.mgt.util.Util;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class CloudManagerService
extends AbstractAdmin {
    public CloudService[] retrieveCloudServiceInfo() throws Exception {
        UserRegistry registry = (UserRegistry)this.getConfigUserRegistry();
        int tenantId = registry.getTenantId();
        CloudServicesDescConfig cloudServicesDesc = Util.getCloudServicesDescConfig();
        Map cloudServiceConfigs = cloudServicesDesc.getCloudServiceConfigs();
        ArrayList<CloudService> cloudServices = new ArrayList<CloudService>();
        if (cloudServiceConfigs != null) {
            Set configKeys = cloudServiceConfigs.keySet();
            for (String configKey : configKeys) {
                CloudServiceConfig cloudServiceConfig = (CloudServiceConfig)cloudServiceConfigs.get(configKey);
                String label = cloudServiceConfig.getLabel();
                if (label == null) continue;
                CloudService cloudService = new CloudService();
                String name = cloudServiceConfig.getName();
                cloudService.setName(name);
                cloudService.setLabel(label);
                cloudService.setLink(cloudServiceConfig.getLink());
                cloudService.setIcon(cloudServiceConfig.getIcon());
                cloudService.setDescription(cloudServiceConfig.getDescription());
                cloudService.setProductPageURL(cloudServiceConfig.getProductPageURL());
                boolean active = Util.isCloudServiceActive(name, tenantId);
                cloudService.setActive(tenantId == 0 || active);
                cloudServices.add(cloudService);
            }
        }
        return cloudServices.toArray(new CloudService[cloudServices.size()]);
    }

    public void saveCloudServicesActivity(String[] activeServiceNames) throws Exception {
        UserRegistry registry = (UserRegistry)this.getConfigUserRegistry();
        int tenantId = registry.getTenantId();
        CloudServicesDescConfig cloudServicesDesc = Util.getCloudServicesDescConfig();
        Map cloudServiceConfigMap = cloudServicesDesc.getCloudServiceConfigs();
        List<String> activeServiceNamesList = Arrays.asList(activeServiceNames);
        if (cloudServiceConfigMap != null) {
            for (String cloudServiceName : cloudServiceConfigMap.keySet()) {
                if (activeServiceNamesList.contains(cloudServiceName)) {
                    if (Util.isCloudServiceActive(cloudServiceName, tenantId)) continue;
                    Util.setCloudServiceActive(true, cloudServiceName, tenantId);
                    continue;
                }
                if (!Util.isCloudServiceActive(cloudServiceName, tenantId)) continue;
                Util.setCloudServiceActive(false, cloudServiceName, tenantId);
            }
        }
        Util.setCloudServiceActive(true, "WSO2 Stratos Identity", tenantId);
        Util.setCloudServiceActive(true, "WSO2 Stratos Governance", tenantId);
    }

    public void activate(String cloudServiceName) throws Exception {
        UserRegistry registry = (UserRegistry)this.getConfigUserRegistry();
        int tenantId = registry.getTenantId();
        if (!Util.isCloudServiceActive(cloudServiceName, tenantId)) {
            Util.setCloudServiceActive(true, cloudServiceName, tenantId);
        }
    }

    public void deactivate(String cloudServiceName) throws Exception {
        if ("WSO2 Stratos Identity".equals(cloudServiceName) || "WSO2 Stratos Governance".equals(cloudServiceName)) {
            return;
        }
        UserRegistry registry = (UserRegistry)this.getConfigUserRegistry();
        int tenantId = registry.getTenantId();
        if (Util.isCloudServiceActive(cloudServiceName, tenantId)) {
            Util.setCloudServiceActive(false, cloudServiceName, tenantId);
        }
    }
}

