/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.account.mgt.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.account.mgt.internal.AccountMgtServiceComponent;
import org.apache.stratos.account.mgt.util.Util;
import org.apache.stratos.common.beans.TenantInfoBean;
import org.apache.stratos.common.util.CommonUtil;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class EmailValidationService {
    private static final Log log = LogFactory.getLog(EmailValidationService.class);

    public void proceedUpdateContact(String domain, String email, String confirmationKey) throws Exception {
        Tenant tenant;
        int tenantId;
        TenantManager tenantManager = Util.getTenantManager();
        try {
            tenantId = tenantManager.getTenantId(domain);
        }
        catch (UserStoreException e) {
            String msg = "Error in adding tenant, tenant domain: " + domain + ".";
            log.error((Object)msg);
            throw new RegistryException(msg, (Throwable)e);
        }
        UserRegistry superTenantSystemRegistry = Util.getGovernanceSystemRegistry(-1234);
        String emailVerificationPath = "/repository/components/org.wso2.carbon.email-confirmation-flag/" + tenantId;
        if (!superTenantSystemRegistry.resourceExists(emailVerificationPath)) {
            String msg = "The confirmationKey doesn't exist in service.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        Resource resource = superTenantSystemRegistry.get(emailVerificationPath);
        String actualConfirmationKey = null;
        Object content = resource.getContent();
        if (content instanceof String) {
            actualConfirmationKey = (String)content;
        } else if (content instanceof byte[]) {
            actualConfirmationKey = new String((byte[])content);
        }
        if (actualConfirmationKey == null || !actualConfirmationKey.equals(confirmationKey)) {
            String msg = "The email confirmation key is not matching";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        resource.setProperty(email, "true");
        try {
            tenant = tenantManager.getTenant(tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant information for the tenant id: " + tenantId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        if (!CommonUtil.isTenantActivationModerated()) {
            tenant.setEmail(email);
        }
        try {
            tenantManager.updateTenant(tenant);
        }
        catch (UserStoreException e) {
            String msg = "Error in updating the tenant information for the tenant id: " + tenantId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        if ("false".equals(resource.getProperty("isEmailValidated"))) {
            tenantManager.activateTenant(tenantId);
            resource.editPropertyValue("isEmailValidated", "false", "true");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant : " + tenantId + " is activated after validating the " + "email of the tenant admin."));
            }
            Util.alertTenantInitialActivation(tenantId);
            try {
                AccountMgtServiceComponent.getBillingService().activateUsagePlan(domain);
            }
            catch (Exception e) {
                log.error((Object)("Error occurred while activating the usage plan for tenant: " + domain + " tenant Id: " + tenantId), (Throwable)e);
            }
        }
        TenantInfoBean tenantInfoBean = new TenantInfoBean();
        tenantInfoBean.setTenantId(tenantId);
        tenantInfoBean.setTenantDomain(domain);
        tenantInfoBean.setEmail(email);
        Util.alertTenantUpdate(tenantInfoBean);
        superTenantSystemRegistry.put(emailVerificationPath, resource);
    }
}

