/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.tenant.mgt.email.sender.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.beans.TenantInfoBean;
import org.apache.stratos.common.exception.StratosException;
import org.apache.stratos.common.listeners.TenantMgtListener;
import org.apache.stratos.tenant.mgt.email.sender.util.TenantMgtEmailSenderUtil;

public class EmailSenderListener
implements TenantMgtListener {
    private static final int EXEC_ORDER = 20;
    private static final Log log = LogFactory.getLog(EmailSenderListener.class);

    public void onTenantCreate(TenantInfoBean tenantInfoBean) throws StratosException {
        try {
            TenantMgtEmailSenderUtil.sendTenantCreationVerification(tenantInfoBean);
        }
        catch (Exception e) {
            String message = "Error sending tenant creation Mail to tenant domain " + tenantInfoBean.getTenantDomain();
            log.error((Object)message, (Throwable)e);
            throw new StratosException(message, (Throwable)e);
        }
        TenantMgtEmailSenderUtil.notifyTenantCreationToSuperAdmin(tenantInfoBean);
    }

    public int getListenerOrder() {
        return 20;
    }

    public void onTenantRename(int tenantId, String oldDomainName, String newDomainName) throws StratosException {
    }

    public void onTenantUpdate(TenantInfoBean tenantInfoBean) throws StratosException {
        if (tenantInfoBean.getAdminPassword() != null && !tenantInfoBean.getAdminPassword().equals("")) {
            try {
                TenantMgtEmailSenderUtil.notifyResetPassword(tenantInfoBean);
            }
            catch (Exception e) {
                String message = "Error sending tenant update Mail to tenant domain " + tenantInfoBean.getTenantDomain();
                log.error((Object)message, (Throwable)e);
                throw new StratosException(message, (Throwable)e);
            }
        }
    }

    public void onTenantInitialActivation(int tenantId) throws StratosException {
        TenantMgtEmailSenderUtil.notifyTenantInitialActivation(tenantId);
    }

    public void onTenantActivation(int tenantId) throws StratosException {
    }

    public void onTenantDeactivation(int tenantId) throws StratosException {
    }

    public void onSubscriptionPlanChange(int tenentId, String oldPlan, String newPlan) throws StratosException {
    }
}

