/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.core.nvp;

import com.paypal.sdk.exceptions.FatalException;
import com.paypal.sdk.exceptions.PayPalException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class NVPEncoder {
    private static final String ENCODE_TYPE = "UTF-8";
    private HashMap nvp = new HashMap();

    public final synchronized void add(String name, String value) {
        this.nvp.put(name, value);
    }

    public final synchronized void remove(String name) {
        this.nvp.remove(name);
    }

    public final synchronized void clear() {
        this.nvp.clear();
    }

    public final synchronized String encode() throws PayPalException {
        try {
            StringBuffer buffer = new StringBuffer();
            Set keys = this.nvp.keySet();
            Iterator iter = keys.iterator();
            boolean firstpair = true;
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (!firstpair) {
                    buffer.append("&");
                }
                buffer.append(URLEncoder.encode(key, ENCODE_TYPE));
                buffer.append("=");
                buffer.append(URLEncoder.encode("" + this.nvp.get(key), ENCODE_TYPE));
                firstpair = false;
            }
            return buffer.toString();
        }
        catch (Exception e) {
            throw new FatalException(e.getMessage(), e);
        }
    }
}

