/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.core.nvp;

import com.paypal.sdk.core.Keys;
import com.paypal.sdk.util.Util;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class NVPSSLSocketFactory
implements SecureProtocolSocketFactory {
    String callerID = null;

    public NVPSSLSocketFactory(String _callerID) {
        this.callerID = _callerID;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return Util.getSSLContext(null).getSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return Util.getSSLContext(null).getSocketFactory().createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException {
        SSLSocketFactory socketfactory = Util.getSSLContext(Keys.getKeyManagers(this.callerID)).getSocketFactory();
        return socketfactory.createSocket(host, port, localAddress, localPort);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocketFactory socketfactory = Util.getSSLContext(Keys.getKeyManagers(this.callerID)).getSocketFactory();
        return socketfactory.createSocket(socket, host, port, autoClose);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(NVPSSLSocketFactory.class);
    }

    public int hashCode() {
        return NVPSSLSocketFactory.class.hashCode();
    }
}

