/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.core.soap;

import com.paypal.sdk.core.APICallerBase;
import com.paypal.sdk.core.soap.AxisSSLFactory;
import com.paypal.sdk.core.soap.MethodComparator;
import com.paypal.sdk.exceptions.FatalException;
import com.paypal.sdk.exceptions.PayPalException;
import com.paypal.sdk.exceptions.TransactionException;
import com.paypal.sdk.exceptions.WarningException;
import com.paypal.sdk.profiles.APIProfile;
import com.paypal.sdk.profiles.CertificateAPIProfile;
import com.paypal.sdk.profiles.PermissionAPIProfile;
import com.paypal.sdk.profiles.SignatureAPIProfile;
import com.paypal.sdk.profiles.UniPayAPIProfile;
import com.paypal.sdk.util.MessageResources;
import com.paypal.sdk.util.Util;
import com.paypal.soap.api.AbstractRequestType;
import com.paypal.soap.api.AbstractResponseType;
import com.paypal.soap.api.ErrorType;
import com.paypal.soap.api.PayPalAPIInterfaceServiceLocator;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisProperties;
import org.apache.axis.client.Stub;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPAPICaller
extends APICallerBase {
    private static Log log = LogFactory.getLog(SOAPAPICaller.class);
    private List bindings = new ArrayList();
    private PayPalAPIInterfaceServiceLocator service = new PayPalAPIInterfaceServiceLocator();
    private int maximumRetries = 1;
    private int delayTime = 0;

    @Override
    protected void validateProfile(APIProfile _profile) throws PayPalException {
        ArrayList<String> errors = new ArrayList<String>();
        if (Util.isEmpty(_profile.getEnvironment())) {
            errors.add(MessageResources.getMessage("API_ENVIRONMENT_EMPTY"));
        }
        if (_profile instanceof SignatureAPIProfile) {
            if (Util.isEmpty(_profile.getAPIUsername())) {
                errors.add(MessageResources.getMessage("API_APIUSERNAME_EMPTY"));
            }
            if (Util.isEmpty(_profile.getAPIPassword())) {
                errors.add(MessageResources.getMessage("API_APIPASSWORD_EMPTY"));
            }
            if (Util.isEmpty(_profile.getSignature())) {
                errors.add(MessageResources.getMessage("API_SIGNATURE_EMPTY"));
            }
        } else if (_profile instanceof CertificateAPIProfile) {
            if (Util.isEmpty(_profile.getAPIUsername())) {
                errors.add(MessageResources.getMessage("API_APIUSERNAME_EMPTY"));
            }
            if (Util.isEmpty(_profile.getAPIPassword())) {
                errors.add(MessageResources.getMessage("API_APIPASSWORD_EMPTY"));
            }
            if (Util.isEmpty(_profile.getCertificateFile())) {
                errors.add(MessageResources.getMessage("API_CERTIFICATE_FILE_EMPTY"));
            } else {
                File file = new File(_profile.getCertificateFile());
                if (!file.exists()) {
                    errors.add(MessageResources.getMessage("API_CERTIFICATE_FILE_MISSING"));
                }
            }
            if (_profile.getPrivateKeyPassword() == null || _profile.getPrivateKeyPassword().length() < 1) {
                errors.add(MessageResources.getMessage("API_PRIVATE_KEY_PASSWORD_EMPTY"));
            }
        } else if (_profile instanceof UniPayAPIProfile && Util.isEmpty(_profile.getFirstPartyEmail())) {
            errors.add(MessageResources.getMessage("First party email address is empty"));
        }
        if (_profile instanceof PermissionAPIProfile) {
            if (Util.isEmpty(_profile.getOauth_Signature())) {
                errors.add(MessageResources.getMessage("API_PERMISSION_SIGNATURE_EMPTY"));
            }
            if (Util.isEmpty(_profile.getOauth_Timestamp())) {
                errors.add(MessageResources.getMessage("API_PERMISSION_TIMESTAMP_EMPTY"));
            }
            if (Util.isEmpty(_profile.getOauth_Token())) {
                errors.add(MessageResources.getMessage("API_PERMISSION_TOKEN_EMPTY"));
            }
        }
        if (!errors.isEmpty()) {
            StringBuffer msg = new StringBuffer(MessageResources.getMessage("PROFILE_INVALID"));
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                msg.append("\n" + (String)iterator.next());
            }
            throw new TransactionException(msg.toString());
        }
    }

    @Override
    public final synchronized void setupConnection(APIProfile _profile) throws PayPalException {
        super.setupConnection(_profile);
        this.bindings.clear();
        try {
            Iterator it = this.service.getPorts();
            while (it.hasNext()) {
                QName name = (QName)it.next();
                String endpointUrl = this.getEndpointUrl(_profile, name);
                if (!Util.isEmpty(endpointUrl)) {
                    try {
                        this.service.setEndpointAddress(name, endpointUrl);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)MessageFormat.format(MessageResources.getMessage("ENDPOINT_SET"), name.getLocalPart(), endpointUrl));
                        }
                    }
                    catch (Exception e) {}
                } else {
                    throw new TransactionException(MessageFormat.format(MessageResources.getMessage("ENDPOINT_NOT_FOUND"), _profile.getEnvironment(), name.getLocalPart()));
                }
                Stub binding = (Stub)this.service.getPort(name, null);
                PrefixedQName pqn = new PrefixedQName("urn:ebay:api:PayPalAPI", "RequesterCredentials", "");
                SOAPHeaderElement eblSecurity = new SOAPHeaderElement((Name)pqn);
                eblSecurity.setMustUnderstand(true);
                MessageElement credentials = new MessageElement("Credentials", "ebl", "urn:ebay:apis:eBLBaseComponents");
                MessageElement username = new MessageElement("urn:ebay:apis:eBLBaseComponents", "ebl:Username");
                MessageElement password = new MessageElement("urn:ebay:apis:eBLBaseComponents", "ebl:Password");
                MessageElement signature = new MessageElement("urn:ebay:apis:eBLBaseComponents", "ebl:Signature");
                MessageElement subject = new MessageElement("urn:ebay:apis:eBLBaseComponents", "ebl:Subject");
                if (_profile instanceof CertificateAPIProfile) {
                    username.setObjectValue((Object)_profile.getAPIUsername());
                    credentials.addChild(username);
                    password.setObjectValue((Object)_profile.getAPIPassword());
                    credentials.addChild(password);
                    signature.setObjectValue((Object)_profile.getSignature());
                    credentials.addChild(signature);
                    subject.setObjectValue((Object)_profile.getSubject());
                    credentials.addChild(subject);
                }
                if (_profile instanceof SignatureAPIProfile) {
                    username.setObjectValue((Object)_profile.getAPIUsername());
                    credentials.addChild(username);
                    password.setObjectValue((Object)_profile.getAPIPassword());
                    credentials.addChild(password);
                    signature.setObjectValue((Object)_profile.getSignature());
                    credentials.addChild(signature);
                    subject.setObjectValue((Object)_profile.getSubject());
                    credentials.addChild(subject);
                }
                if (_profile instanceof UniPayAPIProfile) {
                    subject.setObjectValue((Object)_profile.getFirstPartyEmail());
                    credentials.addChild(subject);
                }
                if (_profile instanceof PermissionAPIProfile) {
                    PermissionAPIProfile profile = (PermissionAPIProfile)_profile;
                    this.setHttpHeader(binding, profile);
                }
                eblSecurity.addChild(credentials);
                binding.setHeader(eblSecurity);
                if (_profile.getTimeout() > 0) {
                    binding.setTimeout(_profile.getTimeout());
                }
                this.maximumRetries = _profile.getMaximumRetries() + 1;
                this.delayTime = _profile.getDelayTime();
                binding.setUsername(new Integer(this.hashCode()).toString());
                this.bindings.add(binding);
            }
        }
        catch (ServiceException e) {
            throw new FatalException(MessageResources.getMessage("SOAP_CONNECTION_ERROR"), e);
        }
        catch (SOAPException e) {
            throw new FatalException(MessageResources.getMessage("SOAP_HEADER_ERROR"), e);
        }
        catch (RuntimeException e) {
            throw new FatalException(MessageResources.getMessage("SOAP_CONNECTION_ERROR"), e);
        }
    }

    private void setHttpHeader(Stub stub, PermissionAPIProfile profile) {
        Hashtable<String, String> headers = (Hashtable<String, String>)stub._getProperty("HTTP-Request-Headers");
        if (headers == null) {
            headers = new Hashtable<String, String>();
            stub._setProperty("HTTP-Request-Headers", headers);
        }
        StringBuffer authString = new StringBuffer();
        authString.append("timestamp=" + profile.getOauth_Timestamp());
        authString.append(",");
        authString.append("token=" + profile.getOauth_Token());
        authString.append(",");
        authString.append("signature=" + profile.getOauth_Signature());
        headers.put("X_PP_AUTHORIZATION", authString.toString());
    }

    public AbstractResponseType call(String operationName, AbstractRequestType request) throws PayPalException {
        if (this.bindings.isEmpty()) {
            throw new WarningException(MessageResources.getMessage("NO_PROFILE_SET"));
        }
        Stub binding = null;
        Method method = null;
        Iterator it = this.bindings.iterator();
        while (it.hasNext() && (method = this.getOperation(operationName, binding = (Stub)it.next())) == null) {
        }
        if (method == null) {
            throw new TransactionException(MessageFormat.format(MessageResources.getMessage("SOAP_OPERATION_ERROR"), operationName));
        }
        if (request.getVersion() == null) {
            request.setVersion("65.1");
        }
        try {
            Class<?>[] pars = method.getParameterTypes();
            if (pars[0].getName().equals(request.getClass().getName())) {
                return this.callSOAP(method, binding, new Object[]{request});
            }
            Object reqObject = null;
            Constructor<?>[] ctors = pars[0].getDeclaredConstructors();
            for (int i = 0; i < ctors.length; ++i) {
                if (ctors[i].getParameterTypes().length != 1) continue;
                reqObject = ctors[i].newInstance(request);
                break;
            }
            if (reqObject == null) {
                throw new FatalException(MessageResources.getMessage("SOAP_PARAMETER_ERROR"));
            }
            Date startTime = new Date();
            if (log.isInfoEnabled()) {
                log.info((Object)MessageFormat.format(MessageResources.getMessage("TRANSACTION_SENT"), method.getName()));
            }
            AbstractResponseType response = this.callSOAP(method, binding, new Object[]{reqObject});
            if (log.isInfoEnabled()) {
                Date endTime = new Date();
                log.info((Object)MessageFormat.format(MessageResources.getMessage("TRANSACTION_RESULT"), method.getName(), response.getAck(), new Long(endTime.getTime() - startTime.getTime())));
                if (response.getErrors() != null) {
                    ErrorType[] errors = response.getErrors();
                    for (int i = 0; i < errors.length; ++i) {
                        log.info((Object)MessageFormat.format(MessageResources.getMessage("TRANSACTION_ERROR"), method.getName(), errors[i].getLongMessage()));
                    }
                }
            }
            return response;
        }
        catch (SecurityException e) {
            throw new FatalException(MessageResources.getMessage("SECURITY_INFO_ACCESS_DENIED"), e);
        }
        catch (IllegalAccessException e) {
            throw new FatalException(MessageResources.getMessage("CONSTRUCTOR_INACCESSIBLE"), e);
        }
        catch (IllegalArgumentException e) {
            throw new FatalException(MessageResources.getMessage("PARAMETER_COUNT_DIFFERENT"), e);
        }
        catch (InstantiationException e) {
            throw new FatalException(MessageResources.getMessage("CONSTRUCTOR_ABSTRACT"), e);
        }
        catch (InvocationTargetException e) {
            throw new FatalException(MessageResources.getMessage("CONSTRUCTOR_ERROR"), e);
        }
        catch (ExceptionInInitializerError e) {
            throw new FatalException(MessageResources.getMessage("METHOD_ERROR"), e);
        }
        catch (NullPointerException e) {
            throw new FatalException(MessageResources.getMessage("METHOD_NULL"), e);
        }
    }

    protected AbstractResponseType callSOAP(Method method, Object obj, Object[] args) throws PayPalException {
        Exception callex = null;
        for (int retry = 0; retry < this.maximumRetries; ++retry) {
            if (retry > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)callex.getMessage(), (Throwable)callex);
                    log.debug((Object)("Retry " + method.getName() + " #" + retry + "..."));
                }
                try {
                    Thread.sleep(this.delayTime);
                }
                catch (Exception ex) {
                    throw new TransactionException(ex.getMessage(), ex);
                }
            }
            try {
                return (AbstractResponseType)method.invoke(obj, args);
            }
            catch (Exception e) {
                callex = e;
                continue;
            }
        }
        if (callex instanceof InvocationTargetException) {
            throw new TransactionException(callex.getCause().getMessage(), callex);
        }
        throw new TransactionException(callex.getMessage(), callex);
    }

    public Collection getAvailableOperations() throws PayPalException {
        try {
            TreeSet<Method> methods = new TreeSet<Method>(new MethodComparator());
            Iterator it = this.service.getPorts();
            while (it.hasNext()) {
                Method[] array = this.service.getPort((QName)it.next(), null).getClass().getDeclaredMethods();
                for (int i = 0; i < array.length; ++i) {
                    if (!Modifier.isPublic(array[i].getModifiers()) || Modifier.isStatic(array[i].getModifiers())) continue;
                    methods.add(array[i]);
                }
            }
            return methods;
        }
        catch (ServiceException e) {
            throw new FatalException(MessageResources.getMessage("SOAP_PORT_ERROR"), e);
        }
    }

    public Method getOperation(String operationName) throws PayPalException {
        try {
            Iterator it = this.service.getPorts();
            while (it.hasNext()) {
                Method[] array = this.service.getPort((QName)it.next(), null).getClass().getDeclaredMethods();
                for (int i = 0; i < array.length; ++i) {
                    if (!Modifier.isPublic(array[i].getModifiers()) || Modifier.isStatic(array[i].getModifiers()) || !array[i].getName().toLowerCase().equals(operationName.toLowerCase())) continue;
                    return array[i];
                }
            }
            return null;
        }
        catch (ServiceException e) {
            throw new FatalException(MessageResources.getMessage("SOAP_PORT_ERROR"), e);
        }
    }

    private Method getOperation(String operationName, Stub binding) {
        Method[] array = binding.getClass().getDeclaredMethods();
        for (int i = 0; i < array.length; ++i) {
            if (!Modifier.isPublic(array[i].getModifiers()) || Modifier.isStatic(array[i].getModifiers()) || !array[i].getName().toLowerCase().equals(operationName.toLowerCase())) continue;
            return array[i];
        }
        return null;
    }

    static {
        AxisProperties.setProperty((String)"axis.socketSecureFactory", (String)AxisSSLFactory.class.getName());
        APICallerBase.readEndpoints("wsdl/paypal-endpoints.xml");
    }
}

