/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.tenant.activity.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.tenant.activity.beans.TenantDataBean;
import org.apache.stratos.tenant.activity.commands.GetActiveTenantsInMemberRequest;
import org.apache.stratos.tenant.activity.commands.GetActiveTenantsInMemberResponse;
import org.apache.stratos.tenant.activity.util.Util;

public class TenantActivityUtil {
    private static final Log log = LogFactory.getLog(TenantActivityUtil.class);

    public static List<TenantDataBean> getActiveTenantsInCluster() throws AxisFault {
        ArrayList<TenantDataBean> tenants = new ArrayList<TenantDataBean>();
        try {
            ClusteringAgent agent = TenantActivityUtil.getClusteringAgent();
            List list = agent.sendMessage((ClusteringMessage)new GetActiveTenantsInMemberRequest(), true);
            if (log.isDebugEnabled()) {
                log.debug((Object)"sent cluster command to to get Active tenants on cluster");
            }
            for (ClusteringCommand command : list) {
                if (!(command instanceof GetActiveTenantsInMemberResponse)) continue;
                GetActiveTenantsInMemberResponse response = (GetActiveTenantsInMemberResponse)command;
                for (TenantDataBean tenant : response.getTenants()) {
                    tenants.add(tenant);
                }
            }
        }
        catch (AxisFault f) {
            String msg = "Error in getting active tenant by cluster commands";
            log.error((Object)msg, (Throwable)f);
            throw new AxisFault(msg);
        }
        return tenants;
    }

    private static ClusteringAgent getClusteringAgent() throws AxisFault {
        AxisConfiguration axisConfig = Util.getConfigurationContextService().getServerConfigContext().getAxisConfiguration();
        return axisConfig.getClusteringAgent();
    }

    public static int indexOfTenantInList(List<TenantDataBean> list, TenantDataBean tenant) {
        for (int i = 0; i < list.size(); ++i) {
            if (!tenant.getDomain().equalsIgnoreCase(list.get(i).getDomain())) continue;
            return i;
        }
        return -1;
    }
}

