/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.tenant.activity.ui.clients;

import java.rmi.RemoteException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.tenant.activity.stub.TenantActivityServiceExceptionException;
import org.apache.stratos.tenant.activity.stub.TenantActivityServiceStub;
import org.apache.stratos.tenant.activity.stub.beans.xsd.PaginatedTenantDataBean;
import org.apache.stratos.tenant.activity.ui.internal.TenantActivityUIServiceComponent;
import org.wso2.carbon.authenticator.proxy.AuthenticationAdminClient;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.user.core.UserStoreException;

public class TenantActivityServiceClient {
    private static final Log log = LogFactory.getLog(TenantActivityServiceClient.class);
    private TenantActivityServiceStub stub;
    private String epr;

    public TenantActivityServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "TenantMonitorService";
        try {
            this.stub = new TenantActivityServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate TenantMonitorService service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public TenantActivityServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "TenantActivityService";
        try {
            this.stub = new TenantActivityServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate TenantMonitorService service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public TenantActivityServiceClient(String url, ServletConfig config, HttpSession session) throws Exception {
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        try {
            String cookie = this.login(url + "/services/", TenantActivityUIServiceComponent.stratosConfiguration.getAdminUserName(), TenantActivityUIServiceComponent.stratosConfiguration.getAdminPassword(), configContext);
            this.epr = url + "/services/TenantActivityService";
            this.stub = new TenantActivityServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate TenantMonitorService service client. ";
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public int getActiveTenantCount() throws TenantActivityServiceExceptionException, RemoteException {
        int count = this.stub.getActiveTenantCount();
        return count;
    }

    public PaginatedTenantDataBean getPaginatedActiveTenantList(int pageNumber) throws TenantActivityServiceExceptionException, RemoteException {
        return this.stub.retrievePaginatedActiveTenants(pageNumber);
    }

    public boolean isTenantActiveInService(String domainName) throws TenantActivityServiceExceptionException, RemoteException {
        return this.stub.isActiveTenantOnService(domainName);
    }

    private String login(String serverUrl, String userName, String password, ConfigurationContext confContext) throws UserStoreException {
        String sessionCookie = null;
        try {
            AuthenticationAdminClient client = new AuthenticationAdminClient(confContext, serverUrl, null, null, false);
            boolean isLogin = client.login(userName, password, "127.0.0.1");
            if (isLogin) {
                sessionCookie = client.getAdminCookie();
            }
        }
        catch (Exception e) {
            throw new UserStoreException("Error in login to the server server: " + serverUrl + "username: " + userName + ".", (Throwable)e);
        }
        return sessionCookie;
    }
}

