/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.tenant.mgt.ui.utils;

import java.util.Calendar;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.tenant.mgt.stub.beans.xsd.TenantInfoBean;
import org.apache.stratos.tenant.mgt.ui.clients.TenantServiceClient;

public class TenantMgtUtil {
    private static final Log log = LogFactory.getLog(TenantMgtUtil.class);

    public static void addTenantConfigBean(HttpServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        TenantInfoBean tenantInfoBean = new TenantInfoBean();
        try {
            tenantInfoBean.setAdmin(request.getParameter("admin"));
            tenantInfoBean.setFirstname(request.getParameter("admin-firstname"));
            tenantInfoBean.setLastname(request.getParameter("admin-lastname"));
            tenantInfoBean.setAdminPassword(request.getParameter("admin-password"));
            tenantInfoBean.setTenantDomain(request.getParameter("domain"));
            tenantInfoBean.setEmail(request.getParameter("admin-email"));
            tenantInfoBean.setUsagePlan(request.getParameter("usage-plan-name"));
            tenantInfoBean.setCreatedDate(Calendar.getInstance());
            TenantServiceClient serviceClient = new TenantServiceClient(config, session);
            serviceClient.addTenant(tenantInfoBean);
        }
        catch (Exception e) {
            String msg = "Failed to add tenant config. tenant-domain: " + tenantInfoBean.getTenantDomain() + ", " + "tenant-admin: " + tenantInfoBean.getAdmin() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public static void updateTenantConfigBean(HttpServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        TenantInfoBean tenantInfoBean = new TenantInfoBean();
        try {
            int tenantId;
            String tenantIdStr = request.getParameter("tenantId");
            try {
                tenantId = Integer.parseInt(tenantIdStr);
            }
            catch (Exception e) {
                String msg = "Error in converting tenant id: " + tenantIdStr + " to a number.";
                log.error((Object)msg);
                throw new Exception(msg, e);
            }
            tenantInfoBean.setTenantId(tenantId);
            tenantInfoBean.setAdmin(request.getParameter("admin"));
            tenantInfoBean.setFirstname(request.getParameter("admin-firstname"));
            tenantInfoBean.setLastname(request.getParameter("admin-lastname"));
            tenantInfoBean.setAdminPassword(request.getParameter("admin-password"));
            tenantInfoBean.setTenantDomain(request.getParameter("domain"));
            tenantInfoBean.setEmail(request.getParameter("admin-email"));
            tenantInfoBean.setUsagePlan(request.getParameter("usage-plan-name"));
            TenantServiceClient serviceClient = new TenantServiceClient(config, session);
            serviceClient.updateTenant(tenantInfoBean);
        }
        catch (Exception e) {
            String msg = "Failed to update the tenant config. tenant-domain: " + tenantInfoBean.getTenantDomain() + ", " + "tenant-admin: " + tenantInfoBean.getAdmin() + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public static TenantInfoBean[] getTenants(HttpServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        try {
            TenantServiceClient serviceClient = new TenantServiceClient(config, session);
            return serviceClient.retrieveTenants();
        }
        catch (Exception e) {
            String msg = "Failed to get the minimum information bean of tenants. ";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public static TenantInfoBean getTenant(HttpServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        String tenantDomain = "";
        try {
            tenantDomain = request.getParameter("domain");
            TenantServiceClient serviceClient = new TenantServiceClient(config, session);
            TenantInfoBean tenantBean = serviceClient.getTenant(tenantDomain);
            return tenantBean;
        }
        catch (Exception e) {
            String msg = "Failed to get existing details of the tenant:" + tenantDomain;
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public static void activateTenant(HttpServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        String tenantDomain = "";
        try {
            tenantDomain = request.getParameter("activate.domain");
            TenantServiceClient serviceClient = new TenantServiceClient(config, session);
            serviceClient.activateTenant(tenantDomain);
        }
        catch (Exception e) {
            String msg = "Failed to activate the tenant:" + tenantDomain;
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public static void deactivateTenant(HttpServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        String tenantDomain = "";
        try {
            tenantDomain = request.getParameter("activate.domain");
            TenantServiceClient serviceClient = new TenantServiceClient(config, session);
            serviceClient.deactivateTenant(tenantDomain);
        }
        catch (Exception e) {
            String msg = "Failed to deactivate the tenant:" + tenantDomain;
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public static String removeHtmlElements(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

