/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.usage.api;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.util.CommonUtil;
import org.apache.stratos.usage.beans.APIManagerUsageStats;
import org.apache.stratos.usage.beans.BandwidthStatistics;
import org.apache.stratos.usage.beans.CartridgeStatistics;
import org.apache.stratos.usage.beans.InstanceUsageStatics;
import org.apache.stratos.usage.beans.RequestStatistics;
import org.apache.stratos.usage.beans.TenantDataCapacity;
import org.apache.stratos.usage.beans.TenantUsage;
import org.apache.stratos.usage.util.DataAccessObject;
import org.apache.stratos.usage.util.Util;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class TenantUsageRetriever {
    private static final Log log = LogFactory.getLog(TenantUsageRetriever.class);
    private static final String DEFAULT_SERVICE_NAME = "Stratos";
    private static final String METERING_ENDPOINT = "local://services/MeteringQueryDS";
    private static final String TOTAL_LABEL = "Total";
    public static final int REG_BANDWIDTH_INDEX = 0;
    public static final int SVC_BANDWIDTH_INDEX = 1;
    public static final int WEBAPP_BANDWIDTH_INDEX = 2;
    public static final int API_CALL_STATS = 3;
    private RegistryService registryService;
    private DataAccessObject dao;

    public TenantUsageRetriever(RegistryService registryService, ConfigurationContext configContext) throws Exception {
        this.registryService = registryService;
        this.dao = new DataAccessObject();
    }

    public TenantDataCapacity getDataCapacity(int tenantId, Calendar startDate, Calendar endDate, boolean currentMonth) throws Exception {
        TenantDataCapacity dataCapacity = null;
        if (currentMonth) {
            dataCapacity = this.dao.getTenantDataCapacity(tenantId);
        }
        return dataCapacity;
    }

    public int getCurrentUserCount(int tenantId) throws RegistryException {
        int usersCount;
        UserRealm userRealm = this.registryService.getUserRealm(tenantId);
        try {
            String[] users = userRealm.getUserStoreManager().listUsers("*", -1);
            usersCount = users.length;
        }
        catch (UserStoreException e) {
            String msg = "Error in getting the current users.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        return usersCount;
    }

    public BandwidthStatistics[][] getBandwidthStatistics(int tenantId, Calendar startDate, Calendar endDate, boolean currentMonth) throws Exception {
        BandwidthStatistics[] stats;
        if (currentMonth) {
            List<Object> bwsList = new ArrayList();
            bwsList = this.dao.getDailyBandwidthStats(tenantId, startDate, endDate);
            Calendar startHour = Calendar.getInstance();
            startHour.set(10, 0);
            startHour.set(12, 0);
            startHour.set(13, 0);
            Calendar endHour = Calendar.getInstance();
            bwsList.addAll(this.dao.getHourlyBandwidthStats(tenantId, startHour, endHour));
            stats = this.convertBWListToArray(bwsList);
        } else {
            Calendar monthCal = (Calendar)endDate.clone();
            monthCal.set(5, 0);
            monthCal.set(10, 0);
            monthCal.set(12, 0);
            monthCal.set(13, 0);
            stats = this.convertBWListToArray(this.dao.getMonthlyBandwidthStats(tenantId, monthCal));
        }
        HashMap<String, BandwidthStatistics> regBwMap = new HashMap<String, BandwidthStatistics>();
        HashMap svcBwMap = new HashMap();
        HashMap webappBwMap = new HashMap();
        if (stats != null) {
            for (BandwidthStatistics stat : stats) {
                HashMap<String, BandwidthStatistics> bwMap;
                if (stat.getIncomingBandwidth() == 0L && stat.getOutgoingBandwidth() == 0L) continue;
                String serverName = this.extractServiceNameFromUrl(stat.getServerUrl());
                String bandwidthName = stat.getKey();
                if (bandwidthName.equals("RegistryBandwidth-In") || bandwidthName.equals("RegistryBandwidth-Out")) {
                    bwMap = regBwMap;
                } else if (bandwidthName.equals("ServiceBandwidth-In") || bandwidthName.equals("ServiceBandwidth-Out")) {
                    bwMap = svcBwMap;
                } else if (bandwidthName.equals("WebappBandwidth-In") || bandwidthName.equals("WebappBandwidth-Out")) {
                    bwMap = webappBwMap;
                } else {
                    log.warn((Object)("Unable to identify bandwidth name " + bandwidthName));
                    continue;
                }
                BandwidthStatistics reqStat = (BandwidthStatistics)bwMap.get(serverName);
                if (reqStat == null) {
                    reqStat = new BandwidthStatistics(serverName);
                    bwMap.put(serverName, reqStat);
                }
                reqStat.setIncomingBandwidth(reqStat.getIncomingBandwidth() + stat.getIncomingBandwidth());
                reqStat.setOutgoingBandwidth(reqStat.getOutgoingBandwidth() + stat.getOutgoingBandwidth());
            }
        }
        BandwidthStatistics[][] returnValue = new BandwidthStatistics[3][];
        Collection values = regBwMap.values();
        returnValue[0] = values.toArray(new BandwidthStatistics[values.size()]);
        values = svcBwMap.values();
        returnValue[1] = values.toArray(new BandwidthStatistics[values.size()]);
        values = webappBwMap.values();
        returnValue[2] = values.toArray(new BandwidthStatistics[values.size()]);
        return returnValue;
    }

    public APIManagerUsageStats[] getAPIManagerUsageStats(int tenantId, Calendar startDate, Calendar endDate, boolean currentMonth) throws Exception {
        APIManagerUsageStats[] stats;
        if (currentMonth) {
            List<Object> bwsList = new ArrayList();
            bwsList = this.dao.getDailyAPIManagerUsageStats(tenantId, startDate, endDate);
            Calendar startHour = Calendar.getInstance();
            startHour.set(10, 0);
            startHour.set(12, 0);
            startHour.set(13, 0);
            Calendar endHour = Calendar.getInstance();
            bwsList.addAll(this.dao.getHourlyAPIManagerUsageStats(tenantId, startHour, endHour));
            stats = this.convertAPIStatListToArray(bwsList);
        } else {
            Calendar monthCal = (Calendar)endDate.clone();
            monthCal.set(5, 0);
            monthCal.set(10, 0);
            monthCal.set(12, 0);
            monthCal.set(13, 0);
            stats = this.convertAPIStatListToArray(this.dao.getMonthlyAPIManagerUsageStats(tenantId, monthCal));
        }
        HashMap<String, APIManagerUsageStats> statMap = new HashMap<String, APIManagerUsageStats>();
        if (stats != null) {
            for (APIManagerUsageStats stat : stats) {
                if (stat.getRequestCount() == 0L) continue;
                String serverName = this.extractServiceNameFromUrl(stat.getServerUrl());
                String statName = stat.getKey();
                if (!statName.equals("API-Call")) {
                    log.warn((Object)("Unable to identify bandwidth name " + statName));
                    continue;
                }
                HashMap<String, APIManagerUsageStats> statsHashMap = statMap;
                APIManagerUsageStats reqStat = (APIManagerUsageStats)statsHashMap.get(serverName);
                if (reqStat == null) {
                    reqStat = new APIManagerUsageStats(serverName);
                    statsHashMap.put(serverName, reqStat);
                }
                reqStat.setRequestCount(stat.getRequestCount());
            }
        }
        APIManagerUsageStats[] returnValue = new APIManagerUsageStats[]{};
        Collection values = statMap.values();
        returnValue = values.toArray(new APIManagerUsageStats[values.size()]);
        return returnValue;
    }

    public RequestStatistics[] getRequestStatistics(int tenantId, Calendar startDate, Calendar endDate, boolean currentMonth) throws Exception {
        RequestStatistics[] stats;
        if (currentMonth) {
            List<Object> rsList = new ArrayList();
            rsList = this.dao.getDailyRequestStats(tenantId, startDate, endDate);
            Calendar startHour = Calendar.getInstance();
            startHour.set(10, 0);
            startHour.set(12, 0);
            startHour.set(13, 0);
            Calendar endHour = Calendar.getInstance();
            rsList.addAll(this.dao.getHourlyRequestStats(tenantId, startHour, endHour));
            stats = this.convertRSListToArray(rsList);
        } else {
            Calendar monthCal = (Calendar)endDate.clone();
            monthCal.set(5, 0);
            monthCal.set(10, 0);
            monthCal.set(12, 0);
            monthCal.set(13, 0);
            stats = this.convertRSListToArray(this.dao.getMonthlyRequestStats(tenantId, monthCal));
        }
        HashMap<String, RequestStatistics> tempReqStatMap = new HashMap<String, RequestStatistics>();
        if (stats != null) {
            for (RequestStatistics stat : stats) {
                if (stat.getRequestCount() == 0L) continue;
                String serverName = this.extractServiceNameFromUrl(stat.getKey());
                RequestStatistics reqStat = (RequestStatistics)tempReqStatMap.get(serverName);
                if (reqStat == null) {
                    reqStat = new RequestStatistics(serverName);
                    tempReqStatMap.put(serverName, reqStat);
                }
                reqStat.setRequestCount(reqStat.getRequestCount() + stat.getRequestCount());
                reqStat.setResponseCount(reqStat.getResponseCount() + stat.getResponseCount());
                reqStat.setFaultCount(reqStat.getFaultCount() + stat.getFaultCount());
            }
        }
        Collection values = tempReqStatMap.values();
        return values.toArray(new RequestStatistics[values.size()]);
    }

    public CartridgeStatistics[] getCartridgeStatistics(int tenantId, Calendar startDate, Calendar endDate, boolean currentMonth) throws Exception {
        ArrayList<CartridgeStatistics> csList = new ArrayList();
        csList = this.dao.getHourlyCartridgeStats(tenantId, startDate, endDate);
        CartridgeStatistics[] stats = this.convertCSListToArray(csList);
        HashMap<String, CartridgeStatistics> tempCartridgeStatMap = new HashMap<String, CartridgeStatistics>();
        if (stats != null) {
            for (CartridgeStatistics stat : stats) {
                if (stat.getCartridgeHours() == 0L) continue;
                CartridgeStatistics cartridgeStat = (CartridgeStatistics)tempCartridgeStatMap.get(stat.getKey());
                if (cartridgeStat == null) {
                    cartridgeStat = new CartridgeStatistics(stat.getKey());
                    tempCartridgeStatMap.put(stat.getKey(), cartridgeStat);
                }
                cartridgeStat.setCartridgeHours(cartridgeStat.getCartridgeHours() + stat.getCartridgeHours());
                cartridgeStat.setInstanceId(stat.getInstanceId());
            }
        }
        Collection values = tempCartridgeStatMap.values();
        return values.toArray(new CartridgeStatistics[values.size()]);
    }

    public TenantUsage getTenantUsage(int tenantId, String yearMonth) throws Exception {
        TenantDataCapacity capacity;
        TenantManager tenantManger = Util.getRealmService().getTenantManager();
        String domain = tenantManger.getDomain(tenantId);
        TenantUsage tenantUsage = new TenantUsage(tenantId, domain);
        Date date = CommonUtil.getDateFromMonthString((String)yearMonth);
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(date);
        Calendar endDate = (Calendar)startDate.clone();
        endDate.add(2, 1);
        boolean isCurrentMonth = Calendar.getInstance().compareTo(endDate) <= 0;
        try {
            capacity = this.getDataCapacity(tenantId, startDate, endDate, isCurrentMonth);
        }
        catch (Exception e) {
            String msg = "Error in getting data capacity from metering service.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        tenantUsage.setRegistryCapacity(capacity);
        RequestStatistics[] reqStats = null;
        try {
            reqStats = this.getRequestStatistics(tenantId, startDate, endDate, isCurrentMonth);
        }
        catch (Exception e) {
            String msg = "Error in getting request statistics from metering service.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        tenantUsage.setRequestStatistics(reqStats);
        RequestStatistics totalReqStat = new RequestStatistics(TOTAL_LABEL);
        long totalReq = 0L;
        long totalRes = 0L;
        long totalFault = 0L;
        if (reqStats != null) {
            for (RequestStatistics stat : reqStats) {
                totalReq += stat.getRequestCount();
                totalRes += stat.getResponseCount();
                totalFault += stat.getFaultCount();
            }
            totalReqStat.setRequestCount(totalReq);
            totalReqStat.setResponseCount(totalRes);
            totalReqStat.setFaultCount(totalFault);
        }
        tenantUsage.setTotalRequestStatistics(totalReqStat);
        BandwidthStatistics[][] bwStats = null;
        try {
            bwStats = this.getBandwidthStatistics(tenantId, startDate, endDate, isCurrentMonth);
        }
        catch (Exception e) {
            String msg = "Error in getting bandwidth statistics from metering service.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        tenantUsage.setRegistryBandwidthStatistics(bwStats[0]);
        tenantUsage.setServiceBandwidthStatistics(bwStats[1]);
        tenantUsage.setWebappBandwidthStatistics(bwStats[2]);
        int index = 0;
        for (BandwidthStatistics[] bwArray : bwStats) {
            long incomingBandwidth = 0L;
            long outgoingBandwidth = 0L;
            for (BandwidthStatistics bandwidth : bwArray) {
                incomingBandwidth += bandwidth.getIncomingBandwidth();
                outgoingBandwidth += bandwidth.getOutgoingBandwidth();
            }
            BandwidthStatistics total = new BandwidthStatistics(TOTAL_LABEL);
            total.setIncomingBandwidth(incomingBandwidth);
            total.setOutgoingBandwidth(outgoingBandwidth);
            switch (index) {
                case 0: {
                    tenantUsage.setTotalRegistryBandwidth(total);
                    break;
                }
                case 1: {
                    tenantUsage.setTotalServiceBandwidth(total);
                    break;
                }
                case 2: {
                    tenantUsage.setTotalWebappBandwidth(total);
                }
            }
            ++index;
        }
        if (isCurrentMonth) {
            int usersCount = this.getCurrentUserCount(tenantId);
            tenantUsage.setNumberOfUsers(usersCount);
        }
        APIManagerUsageStats[] apiStats = null;
        try {
            apiStats = this.getAPIManagerUsageStats(tenantId, startDate, endDate, isCurrentMonth);
        }
        catch (Exception e) {
            String msg = "Error in getting bandwidth statistics from metering service.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        tenantUsage.setApiManagerUsageStats(apiStats);
        CartridgeStatistics[] cartridgeStatistics = this.getCartridgeStatistics(tenantId, startDate, endDate, isCurrentMonth);
        tenantUsage.setCartridgeStatistics(cartridgeStatistics);
        long totalCartridgeHours = 0L;
        if (cartridgeStatistics != null && cartridgeStatistics.length > 0) {
            for (CartridgeStatistics cs : cartridgeStatistics) {
                totalCartridgeHours += cs.getCartridgeHours();
            }
        }
        CartridgeStatistics totalCS = new CartridgeStatistics();
        totalCS.setCartridgeHours(totalCartridgeHours);
        tenantUsage.setTotalCartridgeHours(totalCS);
        return tenantUsage;
    }

    private String extractServiceNameFromUrl(String serviceURL) {
        if (serviceURL == null || serviceURL.equals("")) {
            return DEFAULT_SERVICE_NAME;
        }
        int startIndex = serviceURL.indexOf("://");
        startIndex = startIndex != -1 ? (startIndex += 3) : 0;
        int endIndex = serviceURL.indexOf(46, startIndex);
        if (endIndex == -1 && (endIndex = serviceURL.indexOf(58, startIndex)) == -1 && (endIndex = serviceURL.indexOf(47, startIndex)) == -1) {
            endIndex = serviceURL.length();
        }
        return serviceURL.substring(startIndex, endIndex);
    }

    public InstanceUsageStatics[] getInstanceUsages() throws Exception {
        return null;
    }

    private BandwidthStatistics[] convertBWListToArray(List<BandwidthStatistics> bwsList) {
        BandwidthStatistics[] bwsArray = new BandwidthStatistics[bwsList.size()];
        bwsArray = bwsList.toArray(bwsArray);
        return bwsArray;
    }

    private APIManagerUsageStats[] convertAPIStatListToArray(List<APIManagerUsageStats> bwsList) {
        APIManagerUsageStats[] bwsArray = new APIManagerUsageStats[bwsList.size()];
        bwsArray = bwsList.toArray(bwsArray);
        return bwsArray;
    }

    private RequestStatistics[] convertRSListToArray(List<RequestStatistics> rsList) {
        RequestStatistics[] rsArray = new RequestStatistics[rsList.size()];
        rsArray = rsList.toArray(rsArray);
        return rsArray;
    }

    private CartridgeStatistics[] convertCSListToArray(List<CartridgeStatistics> csList) {
        CartridgeStatistics[] csArray = new CartridgeStatistics[csList.size()];
        csArray = csList.toArray(csArray);
        return csArray;
    }
}

