/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.usage.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.usage.api.TenantUsageRetriever;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.ndatasource.core.DataSourceService;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class Util {
    private static final Log log = LogFactory.getLog(Util.class);
    private static RegistryService registryService;
    private static RealmService realmService;
    private static TenantUsageRetriever tenantUsageRetriever;
    private static ConfigurationContextService configurationContextService;
    private static DataSourceService dataSourceService;
    public static String BILLING_DATA_SOURCE_NAME;

    public static synchronized void setRegistryService(RegistryService service) {
        if (registryService == null) {
            registryService = service;
        }
    }

    public static void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        Util.configurationContextService = configurationContextService;
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return configurationContextService;
    }

    public static synchronized void setRealmService(RealmService service) {
        if (realmService == null) {
            realmService = service;
        }
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static TenantUsageRetriever getTenantUsageRetriever() {
        return tenantUsageRetriever;
    }

    public static UserRealm getUserRealm(int tenantId) throws RegistryException {
        return registryService.getUserRealm(tenantId);
    }

    public static UserRegistry getSuperTenantGovernanceSystemRegistry() throws RegistryException {
        return registryService.getGovernanceSystemRegistry();
    }

    public static void registerRetrieverServices(BundleContext bundleContext) throws Exception {
        ConfigurationContextService confCtxSvc = Util.getConfigurationContextService();
        tenantUsageRetriever = new TenantUsageRetriever(registryService, confCtxSvc.getServerConfigContext());
        bundleContext.registerService(TenantUsageRetriever.class.getName(), (Object)tenantUsageRetriever, null);
    }

    public static DataSourceService getDataSourceService() {
        return dataSourceService;
    }

    public static void setDataSourceService(DataSourceService dataSourceService) {
        Util.dataSourceService = dataSourceService;
    }

    static {
        BILLING_DATA_SOURCE_NAME = "WSO2BillingDS";
    }
}

