/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.util.UIResourceProvider;

public class BundleBasedUIResourceProvider
implements UIResourceProvider {
    protected static final Log log = LogFactory.getLog(BundleBasedUIResourceProvider.class);
    private Map<String, Bundle> bundleResourceMap;
    private Map<Bundle, List<String>> inverseBundleResourceMap;
    private String bundleResourcePath;

    public BundleBasedUIResourceProvider(String bundleResourcePath) {
        this.bundleResourcePath = bundleResourcePath;
        this.bundleResourceMap = new HashMap<String, Bundle>();
        this.inverseBundleResourceMap = new HashMap<Bundle, List<String>>();
    }

    @Override
    public URL getUIResource(String name) {
        Enumeration entryPaths;
        String resourceName = this.bundleResourcePath + name;
        int lastSlash = resourceName.lastIndexOf(47);
        if (lastSlash == -1) {
            return null;
        }
        String path = resourceName.substring(0, lastSlash);
        if (path.length() == 0) {
            path = "/";
        }
        String file = resourceName.substring(lastSlash + 1);
        String resourcePath = CarbonUIUtil.getBundleResourcePath(name);
        Bundle resourceBundle = this.bundleResourceMap.get(resourcePath);
        if (resourceBundle != null && (entryPaths = resourceBundle.findEntries(path, file, false)) != null && entryPaths.hasMoreElements()) {
            return (URL)entryPaths.nextElement();
        }
        return null;
    }

    @Override
    public Set<String> getUIResourcePaths(String name) {
        Enumeration e;
        HashSet<String> result = new HashSet<String>();
        String resourcePath = CarbonUIUtil.getBundleResourcePath(name);
        Bundle resourceBundle = this.bundleResourceMap.get(resourcePath);
        if (resourceBundle != null && (e = resourceBundle.findEntries(this.bundleResourcePath + name, null, false)) != null) {
            while (e.hasMoreElements()) {
                URL entryURL = (URL)e.nextElement();
                result.add(entryURL.getFile().substring(this.bundleResourcePath.length()));
            }
        }
        return result;
    }

    public void addBundleResourcePaths(Bundle bundle) {
        LinkedList<String> resourcePathList = new LinkedList<String>();
        Enumeration entries = bundle.findEntries("web", "*", false);
        while (entries != null && entries.hasMoreElements()) {
            URL url = (URL)entries.nextElement();
            String path = url.getPath();
            if (!path.endsWith("/")) continue;
            String bundleResourcePath = path.substring("/web/".length(), path.length() - 1);
            this.bundleResourceMap.put(bundleResourcePath, bundle);
            resourcePathList.add(bundleResourcePath);
        }
        this.inverseBundleResourceMap.put(bundle, resourcePathList);
    }

    public void removeBundleResourcePaths(Bundle bundle) {
        List<String> resourcePathList = this.inverseBundleResourceMap.get(bundle);
        for (String str : resourcePathList) {
            if (!this.bundleResourceMap.containsKey(str)) continue;
            System.out.println("Removing the resource Path : " + str);
            this.bundleResourceMap.remove(str);
        }
    }

    public Bundle getBundle(String resourcePath) {
        return this.bundleResourceMap.get(resourcePath);
    }
}

