/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.deployment.beans.BreadCrumbItem;
import org.wso2.carbon.ui.deployment.beans.CarbonUIDefinitions;
import org.wso2.carbon.ui.deployment.beans.Menu;

public class MenuAdminClient {
    private static Log log = LogFactory.getLog(MenuAdminClient.class);
    private Menu[] menus;
    private StringBuffer menuContent;
    private Map<String, Menu> parentMenuItems;
    private Map<String, ArrayList<Menu>> childMenuItems;
    private Map<String, String> breadcrumbMap = new HashMap<String, String>();
    private Map<String, String> indexPageBreadcrumbParamMap;
    public static final String USER_MENU_ITEMS = "UserMenuItems";
    public static final String USER_CUSTOM_MENU_ITEMS = "UserCustomMenuItems";
    public static final String USER_MENU_ITEMS_FILTERED = "UserMenuItemsFiltered";

    public Map<String, String> getBreadcrumbMap() {
        return this.breadcrumbMap;
    }

    public void setBreadcrumbMap(HashMap<String, String> breadcrumbMap) {
        this.breadcrumbMap = breadcrumbMap;
    }

    private void populateMenuDefinitionsFromOSGiService(String loggedInUserName, boolean isSuperTenant, ArrayList<String> userPermission, HttpServletRequest request) {
        if (loggedInUserName != null) {
            String filtered;
            Menu[] userMenus = (Menu[])request.getSession().getAttribute(USER_MENU_ITEMS);
            if (userMenus != null) {
                LinkedHashSet<Menu> menuList = new LinkedHashSet<Menu>();
                menuList.addAll(Arrays.asList(userMenus));
                Menu[] customMenus = (Menu[])request.getSession().getAttribute(USER_CUSTOM_MENU_ITEMS);
                if (customMenus != null) {
                    menuList.addAll(Arrays.asList(customMenus));
                }
                this.menus = menuList.toArray(new Menu[menuList.size()]);
            }
            if (this.menus == null) {
                this.setDefaultMenus(loggedInUserName, isSuperTenant, userPermission, request);
            }
            if ("false".equals(filtered = (String)request.getSession().getAttribute(USER_MENU_ITEMS_FILTERED))) {
                CarbonUIDefinitions o = new CarbonUIDefinitions();
                Menu[] filteredMenus = o.getMenuDefinitions(loggedInUserName, isSuperTenant, userPermission, request, this.menus);
                this.menus = filteredMenus;
                request.getSession().setAttribute(USER_MENU_ITEMS, (Object)this.menus);
            }
            if (this.menus != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Loaded menu items from user session");
                }
                return;
            }
        }
        this.setDefaultMenus(loggedInUserName, isSuperTenant, userPermission, request);
    }

    private void setDefaultMenus(String loggedInUserName, boolean isSuperTenant, ArrayList<String> userPermission, HttpServletRequest request) {
        CarbonUIDefinitions carbonUIDefinitions;
        Menu[] userMenus;
        ServiceReference reference;
        BundleContext bundleContext = CarbonUIUtil.getBundleContext();
        if (bundleContext != null && (reference = bundleContext.getServiceReference(CarbonUIDefinitions.class.getName())) != null && (userMenus = (carbonUIDefinitions = (CarbonUIDefinitions)bundleContext.getService(reference)).getMenuDefinitions(loggedInUserName, isSuperTenant, userPermission, request)) != null) {
            LinkedHashSet<Menu> menuList = new LinkedHashSet<Menu>();
            menuList.addAll(Arrays.asList(userMenus));
            Menu[] customMenus = (Menu[])request.getSession().getAttribute(USER_CUSTOM_MENU_ITEMS);
            if (customMenus != null) {
                menuList.addAll(Arrays.asList(customMenus));
            }
            this.menus = menuList.toArray(new Menu[menuList.size()]);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found exiting menu items in OSGI context");
            }
        }
    }

    private String findNavigationPathFromRoot(String lastMenuItem, String path) {
        for (int a = 0; a < this.menus.length; ++a) {
            Menu menu = this.menus[a];
            if (log.isDebugEnabled()) {
                log.debug((Object)(a + " : " + lastMenuItem + " : " + menu.getId()));
            }
            if (menu.getId() == null || !menu.getId().equals(lastMenuItem)) continue;
            path = "," + menu.getId() + path;
            String parentMenuId = menu.getParentMenu();
            if (parentMenuId.trim().length() <= 0) break;
            path = this.findNavigationPathFromRoot(parentMenuId, path);
        }
        return path;
    }

    public void setBreadCrumbMap(HttpServletRequest request) {
        HashMap<String, BreadCrumbItem> breadCrumbs = new HashMap<String, BreadCrumbItem>();
        if (this.menus != null) {
            for (int a = 0; a < this.menus.length; ++a) {
                ResourceBundle bundle;
                BreadCrumbItem bc;
                Menu menu;
                block10: {
                    menu = this.menus[a];
                    if (menu.getId() == null) continue;
                    bc = new BreadCrumbItem();
                    CarbonUIUtil.setLocaleToSession(request);
                    Locale locale = CarbonUIUtil.getLocaleFromSession(request);
                    bundle = null;
                    try {
                        if (menu.getI18nBundle() != null) {
                            bundle = ResourceBundle.getBundle(menu.getI18nBundle(), locale);
                        }
                    }
                    catch (MissingResourceException e) {
                        if (!log.isDebugEnabled()) break block10;
                        log.debug((Object)("Cannot find resource bundle : " + menu.getI18nBundle()));
                    }
                }
                String menuText = menu.getI18nKey();
                if (bundle != null) {
                    String tmp;
                    block11: {
                        tmp = null;
                        try {
                            if (menu.getI18nKey() != null) {
                                tmp = bundle.getString(menu.getI18nKey());
                            }
                        }
                        catch (MissingResourceException e) {
                            if (!log.isDebugEnabled()) break block11;
                            log.debug((Object)("Cannot find resource for key :" + menu.getI18nKey()));
                        }
                    }
                    if (tmp != null) {
                        menuText = tmp;
                    }
                }
                bc.setConvertedText(menuText);
                bc.setI18nBundle(menu.getI18nBundle());
                bc.setI18nKey(menu.getI18nKey());
                bc.setId(menu.getId());
                bc.setLink(menu.getLink() + "?region=" + menu.getRegion() + "&amp;item=" + menu.getId() + (menu.getUrlParameters() != null ? "&amp;" + menu.getUrlParameters() : "") + "&amp;ordinal=0");
                breadCrumbs.put(menu.getId(), bc);
            }
        }
        request.getSession().setAttribute("breadcrumbs", breadCrumbs);
    }

    public String getMenuContent(String region, HttpServletRequest request) {
        boolean authenticated = this.isAuthenticated(request);
        ArrayList userPermission = new ArrayList();
        String loggedInUserName = null;
        boolean isSuperTenant = false;
        if (authenticated) {
            loggedInUserName = (String)request.getSession().getAttribute("logged-user");
            userPermission = (ArrayList)request.getSession().getAttribute("user-permissions");
            isSuperTenant = CarbonUIUtil.isSuperTenant(request);
        }
        this.populateMenuDefinitionsFromOSGiService(loggedInUserName, isSuperTenant, userPermission, request);
        this.checkForIndexPageBreadcrumbParamMap(request);
        if (this.menus != null && this.menus.length > 0) {
            int a;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Size of menu items for region : " + region + " is " + this.menus.length));
                for (a = 0; a < this.menus.length; ++a) {
                    log.debug((Object)this.menus[a]);
                }
            }
            this.menuContent = new StringBuffer();
            this.appendMenuHeader();
            if (region.equals("region1")) {
                Locale locale = CarbonUIUtil.getLocaleFromSession(request);
                this.appendHomeLink(locale);
            }
            this.parentMenuItems = new HashMap<String, Menu>();
            this.childMenuItems = new HashMap<String, ArrayList<Menu>>();
            for (a = 0; a < this.menus.length; ++a) {
                boolean display = false;
                if (!authenticated) {
                    if (!this.menus[a].getRequireAuthentication()) {
                        display = true;
                    }
                } else {
                    display = true;
                }
                if (!region.equals(this.menus[a].getRegion()) || !display) continue;
                if ("".equals(this.menus[a].getParentMenu())) {
                    this.parentMenuItems.put(this.menus[a].getId(), this.menus[a]);
                    continue;
                }
                ArrayList<Menu> childMenus = this.childMenuItems.get(this.menus[a].getParentMenu());
                if (childMenus != null && childMenus.size() > 0) {
                    childMenus.add(this.menus[a]);
                    continue;
                }
                ArrayList<Menu> tmp = new ArrayList<Menu>();
                tmp.add(this.menus[a]);
                this.childMenuItems.put(this.menus[a].getParentMenu(), tmp);
            }
            String[] sortedParentMenuIds = this.sortMenuItems(this.parentMenuItems);
            for (int a2 = 0; a2 < sortedParentMenuIds.length; ++a2) {
                String key = sortedParentMenuIds[a2];
                Menu menu = this.parentMenuItems.get(key);
                ArrayList<Menu> childMenusForParent = this.childMenuItems.get(menu.getId());
                if (childMenusForParent == null) continue;
                this.menuContent.append(this.getHtmlForMenuItem(menu, request));
                this.prepareHTMLForChildMenuItems(menu.getId(), request);
            }
            this.appendMenuFooter();
            request.getSession().setAttribute(region + "menu-id-breadcrumb-map", this.breadcrumbMap);
            request.getSession().setAttribute("index-page-breadcrumb-param-map", this.indexPageBreadcrumbParamMap);
            return this.menuContent.toString();
        }
        return "";
    }

    private void checkForIndexPageBreadcrumbParamMap(HttpServletRequest request) {
        HashMap<Object, Object> tmp = (HashMap<Object, Object>)request.getSession().getAttribute("index-page-breadcrumb-param-map");
        this.indexPageBreadcrumbParamMap = tmp != null ? tmp : new HashMap<String, String>();
    }

    private boolean isAuthenticated(HttpServletRequest request) {
        Boolean authenticatedObj = (Boolean)request.getSession().getAttribute("authenticated");
        boolean authenticated = false;
        if (authenticatedObj != null) {
            authenticated = authenticatedObj;
        }
        return authenticated;
    }

    private String[] sortMenuItems(Map menuItems) {
        Iterator itrMenuKeys = menuItems.keySet().iterator();
        int[] menuOrder = new int[menuItems.size()];
        String[] menuIds = new String[menuItems.size()];
        int index = 0;
        while (itrMenuKeys.hasNext()) {
            int ordinal;
            String key = (String)itrMenuKeys.next();
            Menu menu = (Menu)menuItems.get(key);
            try {
                ordinal = Integer.parseInt(menu.getOrder());
            }
            catch (NumberFormatException e) {
                ordinal = 200;
                log.debug((Object)("Hey...whoever defined the menu item : " + menu.getId() + ",please provide a integer value for 'order'"), (Throwable)e);
            }
            menuOrder[index] = ordinal;
            menuIds[index] = menu.getId();
            ++index;
        }
        MenuAdminClient.sortArray(menuOrder, menuIds);
        return menuIds;
    }

    private void prepareHTMLForChildMenuItems(String parentMenuId, HttpServletRequest request) {
        Locale locale = request.getLocale();
        ArrayList<Menu> childMenusForParent = this.childMenuItems.get(parentMenuId);
        if (childMenusForParent != null) {
            Iterator<Menu> itrChildMenusForParent = childMenusForParent.iterator();
            HashMap<String, Menu> childMenus = new HashMap<String, Menu>();
            while (itrChildMenusForParent.hasNext()) {
                Menu menu = itrChildMenusForParent.next();
                childMenus.put(menu.getId(), menu);
            }
            String[] sortedMenuIds = this.sortMenuItems(childMenus);
            if (sortedMenuIds.length > 0) {
                this.menuContent.append("<li class=\"normal\">");
                this.menuContent.append("<ul class=\"sub\">");
                for (int a = 0; a < sortedMenuIds.length; ++a) {
                    Menu menu = (Menu)childMenus.get(sortedMenuIds[a]);
                    ArrayList<Menu> childs = this.childMenuItems.get(menu.getId());
                    if (childs == null) {
                        if (menu.getLink().equals("#") || menu.getLink().trim().length() <= 0) continue;
                        this.menuContent.append(this.getHtmlForMenuItem(menu, request));
                        continue;
                    }
                    this.menuContent.append(this.getHtmlForMenuItem(menu, request));
                    this.prepareHTMLForChildMenuItems(menu.getId(), request);
                }
                this.menuContent.append("</ul>");
                this.menuContent.append("</li>");
            }
        }
    }

    private String getHtmlForMenuItem(Menu menu, HttpServletRequest request) {
        ResourceBundle bundle;
        block13: {
            CarbonUIUtil.setLocaleToSession(request);
            Locale locale = CarbonUIUtil.getLocaleFromSession(request);
            bundle = null;
            try {
                if (menu.getI18nBundle() != null) {
                    bundle = ResourceBundle.getBundle(menu.getI18nBundle(), locale);
                }
            }
            catch (MissingResourceException e) {
                if (!log.isDebugEnabled()) break block13;
                log.debug((Object)("Cannot find resource bundle : " + menu.getI18nBundle()));
            }
        }
        String menuText = menu.getI18nKey();
        if (bundle != null) {
            String tmp;
            block14: {
                tmp = null;
                try {
                    tmp = bundle.getString(menu.getI18nKey());
                }
                catch (MissingResourceException e) {
                    if (!log.isDebugEnabled()) break block14;
                    log.debug((Object)("Cannot find resource for key :" + menu.getI18nKey()));
                }
            }
            if (tmp != null) {
                menuText = tmp;
            }
        }
        String html = "";
        if (menu.getParentMenu().trim().length() == 0 || menu.getLink().trim().length() == 0) {
            html = "<li id=\"" + menu.getRegion() + "_" + menu.getId() + "\" class=\"menu-header\"  onclick=\"mainMenuCollapse(this.childNodes[0])\" style=\"cursor:pointer\">" + "<img src=\"../admin/images/up-arrow.gif\" " + "class=\"mMenuHeaders\" id=\"" + menu.getRegion() + "_" + menu.getId() + "\"/>" + menuText + "</li>";
        } else {
            String link = menu.getLink() + "?region=" + menu.getRegion() + "&amp;item=" + menu.getId();
            String urlParameters = menu.getUrlParameters();
            if (urlParameters != null && urlParameters.trim().length() > 0) {
                link = link + "&amp;" + menu.getUrlParameters();
            }
            String iconPath = "../admin/images/default-menu-icon.gif";
            if (menu.getIcon() != null && menu.getIcon().trim().length() > 0) {
                iconPath = menu.getIcon();
            }
            String breadCrumbPath = this.findNavigationPathFromRoot(menu.getId(), "");
            breadCrumbPath = breadCrumbPath.replaceFirst(",", "");
            this.breadcrumbMap.put(menu.getRegion().trim() + "-" + menu.getId().trim(), breadCrumbPath);
            String params = menu.getRegion().trim() + "," + menu.getId().trim();
            this.indexPageBreadcrumbParamMap.put(link, params);
            String style = "";
            if (menu.getLink().equals("#")) {
                style = "menu-disabled-link";
                html = "<li class=\"" + style + "\" style=\"background-image: url(" + iconPath + ");\">" + menuText + "</li>" + "\n";
            } else {
                style = "menu-default";
                html = "<li><a href=\"" + link + "\" class=\"" + style + "\" style=\"background-image: url(" + iconPath + ");\">" + menuText + "</a></li>" + "\n";
            }
        }
        return html;
    }

    private void appendHomeLink(Locale locale) {
        String homeText = CarbonUIUtil.geti18nString("component.home", "org.wso2.carbon.i18n.Resources", locale);
        this.menuContent.append("<li><a href=\"" + CarbonUIUtil.getHomePage() + "\" class=\"menu-home\">" + homeText + "</a></li>");
    }

    private void appendMenuHeader() {
        this.menuContent.append("<div id=\"menu\">");
        this.menuContent.append(" <ul class=\"main\">");
    }

    private void appendMenuFooter() {
        this.menuContent.append(" </ul>");
        this.menuContent.append("</div>");
    }

    static void sortArray(int[] a, String[] names) {
        for (int i = 0; i < a.length - 1; ++i) {
            for (int j = i + 1; j < a.length; ++j) {
                if (a[i] <= a[j]) continue;
                int temp = a[i];
                String name = names[i];
                a[i] = a[j];
                names[i] = names[j];
                a[j] = temp;
                names[j] = name;
            }
        }
    }
}

