/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.wso2.carbon.ui.JspServlet;
import org.wso2.carbon.ui.UIResourceRegistry;
import org.wso2.carbon.ui.action.ActionHelper;
import org.wso2.carbon.ui.deployment.beans.CarbonUIDefinitions;

public class TilesJspServlet
extends JspServlet {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(TilesJspServlet.class);

    public TilesJspServlet(Bundle bundle, UIResourceRegistry uiResourceRegistry) {
        super(bundle, uiResourceRegistry);
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String actionUrl = request.getRequestURI();
        String resourceURI = actionUrl.replaceFirst(request.getContextPath() + "/", "../");
        HashMap<Object, Object> urlsToBeByPassed = new HashMap();
        if (this.bundle != null) {
            ServiceReference reference = this.bundle.getBundleContext().getServiceReference(CarbonUIDefinitions.class.getName());
            CarbonUIDefinitions carbonUIDefinitions = null;
            if (reference != null && (carbonUIDefinitions = (CarbonUIDefinitions)this.bundle.getBundleContext().getService(reference)) != null) {
                urlsToBeByPassed = carbonUIDefinitions.getSkipTilesUrls();
            }
        }
        if (!urlsToBeByPassed.isEmpty() && urlsToBeByPassed.containsKey(resourceURI)) {
            super.service(request, response);
            return;
        }
        if (actionUrl.lastIndexOf("/admin/layout/template.jsp") > -1 || actionUrl.lastIndexOf("ajaxprocessor.jsp") > -1 || actionUrl.indexOf("gadgets/js") > -1) {
            super.service(request, response);
        } else if (actionUrl.startsWith("/carbon/registry/web/resources/foo/bar")) {
            String resourcePath = actionUrl.replaceFirst("/carbon/registry/web/", "");
            String pathToRegistry = "path=" + resourcePath;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Forwarding to registry : " + pathToRegistry));
            }
            RequestDispatcher dispatcher = request.getRequestDispatcher("../registry/registry-web.jsp?" + pathToRegistry);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("request.getContextPath() : " + request.getContextPath()));
                    log.debug((Object)("actionUrl : " + actionUrl));
                }
                String newPath = actionUrl.replaceFirst(request.getContextPath(), "");
                ActionHelper.render(newPath, request, response);
            }
            catch (Exception e) {
                log.fatal((Object)"Fatal error occurred while rendering UI using Tiles.", (Throwable)e);
            }
        }
    }
}

