/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.deployment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.http.helper.ContextPathServletAdaptor;
import org.eclipse.equinox.http.helper.FilterServletAdaptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.ui.BundleBasedUIResourceProvider;
import org.wso2.carbon.ui.deployment.ComponentBuilder;
import org.wso2.carbon.ui.deployment.beans.CarbonUIDefinitions;
import org.wso2.carbon.ui.deployment.beans.Component;
import org.wso2.carbon.ui.deployment.beans.CustomUIDefenitions;
import org.wso2.carbon.ui.deployment.beans.FileUploadExecutorConfig;
import org.wso2.carbon.ui.deployment.beans.Menu;
import org.wso2.carbon.ui.deployment.beans.Servlet;
import org.wso2.carbon.ui.internal.CarbonUIServiceComponent;
import org.wso2.carbon.ui.transports.fileupload.FileUploadExecutorManager;
import org.wso2.carbon.ui.util.UIResourceProvider;

public class UIBundleDeployer
implements SynchronousBundleListener {
    private static Log log = LogFactory.getLog(UIBundleDeployer.class);
    private String bundleResourcePath = "/web";
    private BundleContext bundleContext;
    private HttpContext httpContext;
    private ServiceTracker fileUploadExecManagerTracker;
    private BundleBasedUIResourceProvider bundleBasedUIResourceProvider = new BundleBasedUIResourceProvider(this.bundleResourcePath);
    private ArrayList<String> hideMenuIds = new ArrayList();

    public UIResourceProvider getBundleBasedUIResourcePrvider() {
        return this.bundleBasedUIResourceProvider;
    }

    public void deploy(BundleContext bundleContext, HttpContext context) {
        this.bundleContext = bundleContext;
        this.httpContext = context;
        this.fileUploadExecManagerTracker = new ServiceTracker(bundleContext, FileUploadExecutorManager.class.getName(), null);
        this.fileUploadExecManagerTracker.open();
        this.hideMenuIds.addAll(Arrays.asList(ServerConfiguration.getInstance().getProperties("HideMenuItemIds.HideMenuItemId")));
        for (Bundle bundle : bundleContext.getBundles()) {
            if ((bundle.getState() & 3) != 0) continue;
            try {
                this.processUIBundle(bundle, "add-ui-component");
            }
            catch (Exception e) {
                log.error((Object)("Error occured when processing ui bundle " + bundle.getSymbolicName()), (Throwable)e);
            }
        }
        try {
            bundleContext.addServiceListener((ServiceListener)new ServletServiceListener(), "(objectClass=" + javax.servlet.Servlet.class.getName() + ")");
        }
        catch (InvalidSyntaxException e) {
            log.error((Object)e);
        }
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received new bundle event  : " + event.getType()));
        }
        try {
            switch (event.getType()) {
                case 32: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Add ui component event received....");
                    }
                    this.processUIBundle(bundle, "add-ui-component");
                    break;
                }
                case 64: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Remove ui component event received....");
                    }
                    this.processUIBundle(bundle, "remove-ui-component");
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occured when processing component xml in bundle " + bundle.getSymbolicName()), (Throwable)e);
            e.printStackTrace();
        }
    }

    private void processUIBundle(Bundle bundle, String action) throws CarbonException {
        Dictionary headers = bundle.getHeaders();
        String value = (String)headers.get("Carbon-Component");
        if (value != null && "UIBundle".equals(value)) {
            if ("add-ui-component".equals(action)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("UI component add action received in UIBundleDeployer  : " + action));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding bundle resource paths  : " + bundle));
                }
                this.bundleBasedUIResourceProvider.addBundleResourcePaths(bundle);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("processComponentXML in   : " + bundle + "   " + action));
                }
                this.processComponentXML(bundle, action);
            } else if ("remove-ui-component".equals(action)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("UI component add action received in UIBundleDeployer  : " + action));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing bundle resource paths  : " + bundle));
                }
                this.bundleBasedUIResourceProvider.removeBundleResourcePaths(bundle);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("processComponentXML in   : " + bundle + "   " + action));
                }
                this.processComponentXML(bundle, action);
            }
        }
    }

    private void processComponentXML(Bundle bundle, String action) throws CarbonException {
        Component component;
        if (this.bundleContext.getBundle() == bundle) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing component xml in the bundle...");
        }
        if ((component = ComponentBuilder.build(bundle, this.bundleContext)) == null) {
            return;
        }
        ServiceReference reference = this.bundleContext.getServiceReference(CarbonUIDefinitions.class.getName());
        CarbonUIDefinitions carbonUIDefinitions = null;
        if (reference != null) {
            carbonUIDefinitions = (CarbonUIDefinitions)this.bundleContext.getService(reference);
        }
        if (carbonUIDefinitions != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found carbonUIDefinitions in OSGi context");
            }
            if ("add-ui-component".equals(action)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Adding UI component using existing Carbon Definition");
                }
                ArrayList<Menu> menusToAdd = new ArrayList<Menu>();
                for (Menu menu : component.getMenus()) {
                    if (this.hideMenuIds.contains(menu.getId())) continue;
                    menusToAdd.add(menu);
                }
                if (menusToAdd.size() > 0) {
                    Menu[] menus = new Menu[menusToAdd.size()];
                    menus = menusToAdd.toArray(menus);
                    carbonUIDefinitions.addMenuItems(menus);
                }
                carbonUIDefinitions.addServletItems(component.getServlets());
                carbonUIDefinitions.addUnauthenticatedUrls(component.getUnauthenticatedUrlList());
                carbonUIDefinitions.addSkipTilesUrls(component.getSkipTilesUrlList());
                carbonUIDefinitions.addHttpUrls(component.getSkipHttpsUrlList());
                carbonUIDefinitions.addContexts(component.getContextsList());
            } else if ("remove-ui-component".equals(action)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Removing UI component using existing carbon definition");
                }
                carbonUIDefinitions.removeMenuItems(component.getMenus());
                carbonUIDefinitions.removeServletItems(component.getServlets());
                carbonUIDefinitions.removeUnauthenticatedUrls(component.getUnauthenticatedUrlList());
                carbonUIDefinitions.removeSkipTilesUrls(component.getSkipTilesUrlList());
                carbonUIDefinitions.removeHttpUrls(component.getSkipHttpsUrlList());
                carbonUIDefinitions.removeContexts(component.getContextsList());
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"CarbonUIDefinitions is NULL. Registering new...");
            }
            carbonUIDefinitions = new CarbonUIDefinitions();
            carbonUIDefinitions.addMenuItems(component.getMenus());
            carbonUIDefinitions.addServletItems(component.getServlets());
            carbonUIDefinitions.addUnauthenticatedUrls(component.getUnauthenticatedUrlList());
            carbonUIDefinitions.addSkipTilesUrls(component.getSkipTilesUrlList());
            carbonUIDefinitions.addHttpUrls(component.getSkipHttpsUrlList());
            carbonUIDefinitions.addContexts(component.getContextsList());
            this.bundleContext.registerService(CarbonUIDefinitions.class.getName(), (Object)carbonUIDefinitions, null);
        }
        this.processServletDefinitions(component, action);
        this.processCustomRegistryDefinitions(component, action);
        this.processFileUploadExecutorDefinitions(component, action);
    }

    private void processFileUploadExecutorDefinitions(Component component, String action) throws CarbonException {
        if (component.getFileUploadExecutorConfigs() != null && component.getFileUploadExecutorConfigs().length > 0) {
            FileUploadExecutorConfig[] executorConfigs;
            FileUploadExecutorManager executorManager = (FileUploadExecutorManager)this.fileUploadExecManagerTracker.getService();
            if (executorManager == null) {
                log.error((Object)"FileUploadExecutorManager service is not available");
                return;
            }
            for (FileUploadExecutorConfig executorConfig : executorConfigs = component.getFileUploadExecutorConfigs()) {
                String[] mappingActions;
                for (String mappingAction : mappingActions = executorConfig.getMappingActionList()) {
                    if ("add-ui-component".equals(action)) {
                        executorManager.addExecutor(mappingAction, executorConfig.getFUploadExecClass());
                        continue;
                    }
                    if (!"remove-ui-component".equals(action)) continue;
                    executorManager.removeExecutor(mappingAction);
                }
            }
        }
    }

    private void processServletDefinitions(Component component, String action) throws CarbonException {
        if (component != null && component.getServlets() != null && component.getServlets().length > 0) {
            HttpService httpService;
            try {
                httpService = CarbonUIServiceComponent.getHttpService();
            }
            catch (Exception e) {
                throw new CarbonException("An instance of HttpService is not available");
            }
            Servlet[] servletDefinitions = component.getServlets();
            for (int a = 0; a < servletDefinitions.length; ++a) {
                Servlet servlet = servletDefinitions[a];
                if ("add-ui-component".equals(action)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Registering sevlet : " + servlet));
                    }
                    try {
                        Class<?> clazz = Class.forName(servlet.getServletClass());
                        Hashtable params = new Hashtable();
                        httpService.registerServlet(servlet.getUrlPatten(), (javax.servlet.Servlet)clazz.newInstance(), params, this.httpContext);
                    }
                    catch (ClassNotFoundException e) {
                        log.error((Object)("Servlet class : " + servlet.getServletClass() + " not found."), (Throwable)e);
                    }
                    catch (ServletException e) {
                        log.error((Object)("Problem registering Servlet class : " + servlet.getServletClass() + "."), (Throwable)e);
                    }
                    catch (NamespaceException e) {
                        log.error((Object)("Problem registering Servlet class : " + servlet.getServletClass() + "."), (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        log.error((Object)("Problem registering Servlet class : " + servlet.getServletClass() + "."), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        log.error((Object)("Problem registering Servlet class : " + servlet.getServletClass() + "."), (Throwable)e);
                    }
                    continue;
                }
                if (!"remove-ui-component".equals(action)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Unregistering sevlet : " + servlet));
                }
                httpService.unregister(servlet.getUrlPatten());
            }
        }
    }

    private void processCustomRegistryDefinitions(Component component, String action) throws CarbonException {
        if (component != null) {
            ServiceReference reference = this.bundleContext.getServiceReference(CustomUIDefenitions.class.getName());
            CustomUIDefenitions customUIDefinitions = null;
            if (reference != null) {
                customUIDefinitions = (CustomUIDefenitions)this.bundleContext.getService(reference);
            }
            if (customUIDefinitions == null) {
                String msg = "Custom UI defenitions service is not available.";
                log.error((Object)msg);
                throw new CarbonException(msg);
            }
            for (String mediaType : component.getCustomViewUIMap().keySet()) {
                String uiPath = component.getCustomViewUIMap().get(mediaType);
                if ("add-ui-component".equals(action)) {
                    if (customUIDefinitions.getCustomViewUI(mediaType) == null) {
                        customUIDefinitions.addCustomViewUI(mediaType, uiPath);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Registered the custom view UI media type: " + mediaType + ", UI path: " + uiPath));
                        continue;
                    }
                    String msg = "Custom view UI is already registered for media type: " + mediaType + ". Custom UI with media type: " + mediaType + " and UI path: " + uiPath + " will not be registered.";
                    log.error((Object)msg);
                    continue;
                }
                if (!"remove-ui-component".equals(action)) continue;
            }
            for (String mediaType : component.getCustomAddUIMap().keySet()) {
                String uiPath = component.getCustomAddUIMap().get(mediaType);
                if ("add-ui-component".equals(action)) {
                    if (customUIDefinitions.getCustomAddUI(mediaType) == null) {
                        customUIDefinitions.addCustomAddUI(mediaType, uiPath);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Registered the custom add UI media type: " + mediaType + ", UI path: " + uiPath));
                        continue;
                    }
                    String msg = "Custom add UI is already registered for media type: " + mediaType + ". Custom UI with media type: " + mediaType + " and UI path: " + uiPath + " will not be registered.";
                    log.error((Object)msg);
                    continue;
                }
                if (!"remove-ui-component".equals(action)) continue;
            }
        }
    }

    public void registerServlet(javax.servlet.Servlet servlet, String urlPattern, Dictionary params, Dictionary servletAttrs, int event, Filter associatedFilter) throws CarbonException {
        HttpService httpService;
        try {
            httpService = CarbonUIServiceComponent.getHttpService();
        }
        catch (Exception e) {
            throw new CarbonException("An instance of HttpService is not available");
        }
        try {
            if (event == 1) {
                ContextPathServletAdaptor adaptedJspServlet = new ContextPathServletAdaptor(servlet, urlPattern);
                if (associatedFilter == null) {
                    httpService.registerServlet(urlPattern, (javax.servlet.Servlet)adaptedJspServlet, params, this.httpContext);
                } else {
                    httpService.registerServlet(urlPattern, (javax.servlet.Servlet)new FilterServletAdaptor(associatedFilter, null, (javax.servlet.Servlet)adaptedJspServlet), params, this.httpContext);
                }
                if (servletAttrs != null) {
                    Enumeration enm = servletAttrs.keys();
                    while (enm.hasMoreElements()) {
                        String key = (String)enm.nextElement();
                        adaptedJspServlet.getServletConfig().getServletContext().setAttribute(key, servletAttrs.get(key));
                    }
                }
            } else if (event == 4) {
                httpService.unregister(urlPattern);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while registering servlet", (Throwable)e);
        }
    }

    public class ServletServiceListener
    implements ServiceListener {
        public ServletServiceListener() {
            try {
                ServiceReference[] servletSRs = UIBundleDeployer.this.bundleContext.getServiceReferences((String)null, "(objectClass=" + javax.servlet.Servlet.class.getName() + ")");
                if (servletSRs != null) {
                    for (ServiceReference sr : servletSRs) {
                        this.registerServletFromSR(sr, 1);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to obtain registerd services. Invalid filter Syntax.", (Throwable)e);
            }
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 1) {
                this.registerServletFromSR(event.getServiceReference(), event.getType());
            }
        }

        public void registerServletFromSR(ServiceReference sr, int event) {
            javax.servlet.Servlet servlet = (javax.servlet.Servlet)UIBundleDeployer.this.bundleContext.getService(sr);
            if (servlet == null) {
                log.error((Object)"Servlet instance cannot be null");
                return;
            }
            Object urlPatternObj = sr.getProperty("url-pattern");
            if (urlPatternObj == null || !(urlPatternObj instanceof String) || urlPatternObj.equals("")) {
                log.error((Object)"URL pattern should not be null");
                return;
            }
            String urlPattern = (String)urlPatternObj;
            Object paramsObj = sr.getProperty("servlet-params");
            if (paramsObj != null && !(paramsObj instanceof Dictionary)) {
                log.error((Object)"Servlet params instances should be type of Dictionary");
                return;
            }
            Dictionary params = (Dictionary)paramsObj;
            Object attributesObj = sr.getProperty("servlet-attribute");
            if (attributesObj != null && !(attributesObj instanceof Dictionary)) {
                log.error((Object)"Servlet attributes instances should be type of Dictionary");
                return;
            }
            Dictionary attributes = (Dictionary)attributesObj;
            Object associatedFilterObj = sr.getProperty("associated-filter");
            Filter associatedFilter = null;
            if (associatedFilterObj != null) {
                associatedFilter = (Filter)associatedFilterObj;
            }
            try {
                UIBundleDeployer.this.registerServlet(servlet, urlPattern, params, attributes, event, associatedFilter);
            }
            catch (CarbonException e) {
                log.error((Object)e);
            }
        }
    }
}

