/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.taglibs;

import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ui.BreadCrumbGenerator;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.deployment.beans.BreadCrumbItem;

public class Breadcrumb
extends BodyTagSupport {
    private static final long serialVersionUID = 3086447243740241245L;
    private static final Log log = LogFactory.getLog(Breadcrumb.class);
    private String label;
    private String resourceBundle;
    private boolean topPage;
    private HttpServletRequest request;
    private boolean hidden = false;
    private String disableBreadCrumbsProperty = "org.wso2.carbon.ui.disableBreadCrumbs";

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public boolean isTopPage() {
        return this.topPage;
    }

    public void setTopPage(boolean topPage) {
        this.topPage = topPage;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public int doEndTag() throws JspException {
        String disableBreadCrumbs = System.getProperty(this.disableBreadCrumbsProperty);
        boolean isBreadCrumbDisabled = disableBreadCrumbs == null ? false : disableBreadCrumbs.equalsIgnoreCase("true");
        String breadcrumbConent = "";
        String cookieContent = "";
        JspWriter writer = this.pageContext.getOut();
        if (isBreadCrumbDisabled) {
            try {
                writer.write("");
            }
            catch (IOException e) {
                // empty catch block
            }
            return 0;
        }
        StringBuffer content = new StringBuffer();
        if (this.request != null) {
            String retainLastBreadcrumbStr = this.request.getParameter("retainlastbc");
            if (log.isDebugEnabled()) {
                log.debug((Object)("BreadcrumbTag : " + this.request.getPathTranslated()));
            }
            String path = (String)this.request.getAttribute("javax.servlet.include.request_uri");
            int carbonLocation = path.lastIndexOf("carbon");
            String jspFilePath = path.substring(carbonLocation, path.length());
            jspFilePath = jspFilePath.replaceFirst("carbon", "..");
            int lastIndexofSlash = jspFilePath.lastIndexOf(47);
            String subContextToJSP = jspFilePath.substring(0, lastIndexofSlash);
            String jspFileName = jspFilePath.substring(lastIndexofSlash + 1, jspFilePath.length());
            String queryString = this.request.getQueryString();
            BreadCrumbItem breadCrumbItem = new BreadCrumbItem();
            breadCrumbItem.setId(jspFileName);
            Locale locale = CarbonUIUtil.getLocaleFromSession(this.request);
            String text = CarbonUIUtil.geti18nString(this.label, this.resourceBundle, locale);
            breadCrumbItem.setConvertedText(text);
            String topPageParameter = this.request.getParameter("toppage");
            if (topPageParameter != null) {
                boolean topPageParamValue = Boolean.valueOf(topPageParameter);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("toppage value set from request parameter.(" + topPageParamValue + ")."));
                }
                this.topPage = topPageParamValue;
            }
            if (!this.topPage) {
                HashMap links = (HashMap)this.request.getSession().getAttribute("page-breadcrumbs");
                String partUrl = "";
                partUrl = queryString != null ? jspFilePath + "?" + queryString : jspFilePath;
                if (links != null) {
                    ArrayList<BreadCrumbItem> breadcrumbsForSubContext = (ArrayList<BreadCrumbItem>)links.get(subContextToJSP);
                    int size = 0;
                    if (breadcrumbsForSubContext != null) {
                        int sizeOfSubContextBreadcrumbs = breadcrumbsForSubContext.size();
                        ArrayList<Integer> idsToRemove = new ArrayList<Integer>();
                        for (int a = 0; a < sizeOfSubContextBreadcrumbs; ++a) {
                            if (!((BreadCrumbItem)breadcrumbsForSubContext.get(a)).getId().equals(jspFileName)) continue;
                            idsToRemove.add(a);
                        }
                        if (idsToRemove.size() > 0) {
                            for (Object e : idsToRemove) {
                                Integer i = (Integer)e;
                                breadcrumbsForSubContext.remove(i);
                            }
                        }
                        size = breadcrumbsForSubContext.size();
                        breadCrumbItem.setOrder(size + 1);
                        breadCrumbItem.setLink(partUrl);
                        breadcrumbsForSubContext.add(breadCrumbItem);
                        links.put(subContextToJSP, breadcrumbsForSubContext);
                        this.request.getSession().setAttribute("page-breadcrumbs", (Object)links);
                    } else {
                        breadcrumbsForSubContext = new ArrayList<BreadCrumbItem>();
                        breadCrumbItem.setOrder(size + 1);
                        breadCrumbItem.setLink(partUrl);
                        breadcrumbsForSubContext.add(breadCrumbItem);
                        links.put(subContextToJSP, breadcrumbsForSubContext);
                        this.request.getSession().setAttribute("page-breadcrumbs", (Object)links);
                    }
                } else {
                    HashMap tmp = new HashMap();
                    breadCrumbItem.setOrder(1);
                    breadCrumbItem.setLink(partUrl);
                    ArrayList<BreadCrumbItem> list = new ArrayList<BreadCrumbItem>();
                    list.add(breadCrumbItem);
                    tmp.put(subContextToJSP, list);
                    this.request.getSession().setAttribute("page-breadcrumbs", tmp);
                }
            }
            boolean retainLastBreadcrumb = false;
            if (retainLastBreadcrumbStr != null) {
                retainLastBreadcrumb = Boolean.parseBoolean(retainLastBreadcrumbStr);
            }
            BreadCrumbGenerator breadCrumbGenerator = new BreadCrumbGenerator();
            HashMap<String, String> generatedContent = breadCrumbGenerator.getBreadCrumbContent(this.request, breadCrumbItem, jspFilePath, this.topPage, retainLastBreadcrumb);
            breadcrumbConent = generatedContent.get("html-content");
            cookieContent = generatedContent.get("cookie-content");
        }
        content.append("<script type=\"text/javascript\">\n");
        content.append("    setCookie('current-breadcrumb', '" + cookieContent + "');\n");
        content.append("    document.onload=setBreadcrumDiv();\n");
        content.append("    function setBreadcrumDiv () {\n");
        content.append("        var breadcrumbDiv = document.getElementById('breadcrumb-div');\n");
        if (!this.hidden) {
            content.append("        breadcrumbDiv.innerHTML = '" + breadcrumbConent + "';\n");
        } else {
            content.append("        breadcrumbDiv.innerHTML = '';\n");
        }
        content.append("    }\n");
        content.append("</script>\n");
        try {
            writer.write(content.toString());
        }
        catch (IOException e) {
            String msg = "Cannot write breadcrumb tag content";
            log.error((Object)msg, (Throwable)e);
            try {
                writer.write("");
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        return 0;
    }

    private static String replaceBacklash(String str) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(str);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\\') {
                result.append("/");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}

