/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
YAHOO.namespace("tool");YAHOO.tool.TestLogger=function(B,A){YAHOO.tool.TestLogger.superclass.constructor.call(this,B,A);this.init();};YAHOO.lang.extend(YAHOO.tool.TestLogger,YAHOO.widget.LogReader,{footerEnabled:true,newestOnTop:false,formatMsg:function(B){var A=B.category;var C=this.html2Text(B.msg);return"<pre><p><span class=\""+A+"\">"+A.toUpperCase()+"</span> "+C+"</p></pre>";},init:function(){if(YAHOO.tool.TestRunner){this.setTestRunner(YAHOO.tool.TestRunner);}this.hideSource("global");this.hideSource("LogReader");this.hideCategory("warn");this.hideCategory("window");this.hideCategory("time");this.clearConsole();},clearTestRunner:function(){if(this._runner){this._runner.unsubscribeAll();this._runner=null;}},setTestRunner:function(A){if(this._runner){this.clearTestRunner();}this._runner=A;A.subscribe(A.TEST_PASS_EVENT,this._handleTestRunnerEvent,this,true);A.subscribe(A.TEST_FAIL_EVENT,this._handleTestRunnerEvent,this,true);A.subscribe(A.TEST_IGNORE_EVENT,this._handleTestRunnerEvent,this,true);A.subscribe(A.BEGIN_EVENT,this._handleTestRunnerEvent,this,true);A.subscribe(A.COMPLETE_EVENT,this._handleTestRunnerEvent,this,true);A.subscribe(A.TEST_SUITE_BEGIN_EVENT,this._handleTestRunnerEvent,this,true);A.subscribe(A.TEST_SUITE_COMPLETE_EVENT,this._handleTestRunnerEvent,this,true);A.subscribe(A.TEST_CASE_BEGIN_EVENT,this._handleTestRunnerEvent,this,true);A.subscribe(A.TEST_CASE_COMPLETE_EVENT,this._handleTestRunnerEvent,this,true);},_handleTestRunnerEvent:function(D){var A=YAHOO.tool.TestRunner;var C="";var B="";switch(D.type){case A.BEGIN_EVENT:C="Testing began at "+(new Date()).toString()+".";B="info";break;case A.COMPLETE_EVENT:C="Testing completed at "+(new Date()).toString()+".\nPassed:"+D.results.passed+" Failed:"+D.results.failed+" Total:"+D.results.total;B="info";break;case A.TEST_FAIL_EVENT:C=D.testName+": "+D.error.getMessage();B="fail";break;case A.TEST_IGNORE_EVENT:C=D.testName+": ignored.";B="ignore";break;case A.TEST_PASS_EVENT:C=D.testName+": passed.";B="pass";break;case A.TEST_SUITE_BEGIN_EVENT:C="Test suite \""+D.testSuite.name+"\" started.";B="info";break;case A.TEST_SUITE_COMPLETE_EVENT:C="Test suite \""+D.testSuite.name+"\" completed.\nPassed:"+D.results.passed+" Failed:"+D.results.failed+" Total:"+D.results.total;B="info";break;case A.TEST_CASE_BEGIN_EVENT:C="Test case \""+D.testCase.name+"\" started.";B="info";break;case A.TEST_CASE_COMPLETE_EVENT:C="Test case \""+D.testCase.name+"\" completed.\nPassed:"+D.results.passed+" Failed:"+D.results.failed+" Total:"+D.results.total;B="info";break;default:C="Unexpected event "+D.type;C="info";}YAHOO.log(C,B,"TestRunner");}});YAHOO.namespace("tool");YAHOO.tool.TestRunner=(function(){function A(){A.superclass.constructor.apply(this,arguments);this.items=[];var C=[this.TEST_CASE_BEGIN_EVENT,this.TEST_CASE_COMPLETE_EVENT,this.TEST_SUITE_BEGIN_EVENT,this.TEST_SUITE_COMPLETE_EVENT,this.TEST_PASS_EVENT,this.TEST_FAIL_EVENT,this.TEST_IGNORE_EVENT,this.COMPLETE_EVENT,this.BEGIN_EVENT];for(var B=0;B<C.length;B++){this.createEvent(C[B],{scope:this});}}YAHOO.lang.extend(A,YAHOO.util.EventProvider,{TEST_CASE_BEGIN_EVENT:"testcasebegin",TEST_CASE_COMPLETE_EVENT:"testcasecomplete",TEST_SUITE_BEGIN_EVENT:"testsuitebegin",TEST_SUITE_COMPLETE_EVENT:"testsuitecomplete",TEST_PASS_EVENT:"pass",TEST_FAIL_EVENT:"fail",TEST_IGNORE_EVENT:"ignore",COMPLETE_EVENT:"complete",BEGIN_EVENT:"begin",_runTestCase:function(H){var J={};this.fireEvent(this.TEST_CASE_BEGIN_EVENT,{testCase:H});var F=[];for(var C in H){if(C.indexOf("test")===0&&typeof H[C]=="function"){F.push(C);}}var O=H._should.fail||{};var G=H._should.error||{};var L=H._should.ignore||{};var D=0;var B=0;var E=0;for(var I=0;I<F.length;I++){if(L[F[I]]){this.fireEvent(this.TEST_IGNORE_EVENT,{testCase:H,testName:F[I]});continue;}var K=false;var M=null;H.setUp();try{H[F[I]]();if(O[F[I]]){M=new YAHOO.util.ShouldFail();K=true;}else{if(G[F[I]]){M=new YAHOO.util.ShouldError();K=true;}}}catch(N){if(N instanceof YAHOO.util.AssertionError){if(!O[F[I]]){M=N;K=true;}}else{if(!G[F[I]]){M=new YAHOO.util.UnexpectedError(N);K=true;}else{if(YAHOO.lang.isString(G[F[I]])){if(N.message!=G[F[I]]){M=new YAHOO.util.UnexpectedError(N);K=true;}}else{if(YAHOO.lang.isObject(G[F[I]])){if(!(N instanceof G[F[I]].constructor)||N.message!=G[F[I]].message){M=new YAHOO.util.UnexpectedError(N);K=true;}}}}}}finally{if(K){this.fireEvent(this.TEST_FAIL_EVENT,{testCase:H,testName:F[I],error:M});}else{this.fireEvent(this.TEST_PASS_EVENT,{testCase:H,testName:F[I]});}}H.tearDown();J[F[I]]={result:K?"fail":"pass",message:M?M.getMessage():"Test passed"};E++;D+=(K?1:0);B+=(K?0:1);}J.total=E;J.failed=D;J.passed=B;this.fireEvent(this.TEST_CASE_COMPLETE_EVENT,{testCase:H,results:J});return J;},_runTestSuite:function(E){var D={passed:0,failed:0,total:0};this.fireEvent(this.TEST_SUITE_BEGIN_EVENT,{testSuite:E});for(var C=0;C<E.items.length;C++){var B=null;if(E.items[C] instanceof YAHOO.tool.TestSuite){B=this._runTestSuite(E.items[C]);}else{if(E.items[C] instanceof YAHOO.tool.TestCase){B=this._runTestCase(E.items[C]);}}if(B!==null){D.total+=B.total;D.passed+=B.passed;D.failed+=B.failed;D[E.items[C].name]=B;}}this.fireEvent(this.TEST_SUITE_COMPLETE_EVENT,{testSuite:E,results:D});return D;},_run:function(B){if(YAHOO.lang.isObject(B)){if(B instanceof YAHOO.tool.TestSuite){return this._runTestSuite(B);}else{if(B instanceof YAHOO.tool.TestCase){return this._runTestCase(B);}else{throw new TypeError("_run(): Expected either YAHOO.tool.TestCase or YAHOO.tool.TestSuite.");}}}},fireEvent:function(B,C){C=C||{};C.type=B;A.superclass.fireEvent.call(this,B,C);},add:function(B){this.items.push(B);},clear:function(){while(this.items.length){this.items.pop();}},run:function(C){var E=null;this.fireEvent(this.BEGIN_EVENT);if(YAHOO.lang.isObject(C)){E=this._run(C);}else{E={passed:0,failed:0,total:0};for(var D=0;D<this.items.length;D++){var B=this._run(this.items[D]);E.passed+=B.passed;E.failed+=B.failed;E.total+=B.total;E[this.items[D].name]=B;}}this.fireEvent(this.COMPLETE_EVENT,{results:E});
}});return new A();})();YAHOO.namespace("tool");YAHOO.tool.TestSuite=function(A){this.name=A||YAHOO.util.Dom.generateId(null,"testSuite");this.items=[];};YAHOO.tool.TestSuite.prototype={add:function(A){if(A instanceof YAHOO.tool.TestSuite||A instanceof YAHOO.tool.TestCase){this.items.push(A);}}};YAHOO.namespace("tool");YAHOO.tool.TestCase=function(A){this._should={};for(var B in A){this[B]=A[B];}if(!YAHOO.lang.isString(this.name)){this.name=YAHOO.util.Dom.generateId(null,"testCase");}};YAHOO.tool.TestCase.prototype={setUp:function(){},tearDown:function(){}};YAHOO.namespace("util");YAHOO.util.Assert={fail:function(A){throw new YAHOO.util.AssertionError(A||"Test force-failed.");},areEqual:function(B,C,A){if(B!=C){throw new YAHOO.util.ComparisonFailure(A||"Values should be equal.",B,C);}},areNotEqual:function(A,C,B){if(A==C){throw new YAHOO.util.UnexpectedValue(B||"Values should not be equal.",A);}},areNotSame:function(A,C,B){if(A===C){throw new YAHOO.util.UnexpectedValue(B||"Values should not be the same.",A);}},areSame:function(B,C,A){if(B!==C){throw new YAHOO.util.ComparisonFailure(A||"Values should be the same.",B,C);}},isFalse:function(B,A){if(false!==B){throw new YAHOO.util.ComparisonFailure(A||"Value should be false.",false,B);}},isTrue:function(B,A){if(true!==B){throw new YAHOO.util.ComparisonFailure(A||"Value should be true.",true,B);}},isNaN:function(B,A){if(!isNaN(B)){throw new YAHOO.util.ComparisonFailure(A||"Value should be NaN.",NaN,B);}},isNotNaN:function(B,A){if(isNaN(B)){throw new YAHOO.util.UnexpectedValue(A||"Values should not be NaN.",NaN);}},isNotNull:function(B,A){if(YAHOO.lang.isNull(B)){throw new YAHOO.util.UnexpectedValue(A||"Values should not be null.",null);}},isNotUndefined:function(B,A){if(YAHOO.lang.isUndefined(B)){throw new YAHOO.util.UnexpectedValue(A||"Value should not be undefined.",undefined);}},isNull:function(B,A){if(!YAHOO.lang.isNull(B)){throw new YAHOO.util.ComparisonFailure(A||"Value should be null.",null,B);}},isUndefined:function(B,A){if(!YAHOO.lang.isUndefined(B)){throw new YAHOO.util.ComparisonFailure(A||"Value should be undefined.",undefined,B);}},isArray:function(B,A){if(!YAHOO.lang.isArray(B)){throw new YAHOO.util.UnexpectedValue(A||"Value should be an array.",B);}},isBoolean:function(B,A){if(!YAHOO.lang.isBoolean(B)){throw new YAHOO.util.UnexpectedValue(A||"Value should be a Boolean.",B);}},isFunction:function(B,A){if(!YAHOO.lang.isFunction(B)){throw new YAHOO.util.UnexpectedValue(A||"Value should be a function.",B);}},isInstanceOf:function(B,C,A){if(!(C instanceof B)){throw new YAHOO.util.ComparisonFailure(A||"Value isn't an instance of expected type.",B,C);}},isNumber:function(B,A){if(!YAHOO.lang.isNumber(B)){throw new YAHOO.util.UnexpectedValue(A||"Value should be a number.",B);}},isObject:function(B,A){if(!YAHOO.lang.isObject(B)){throw new YAHOO.util.UnexpectedValue(A||"Value should be an object.",B);}},isString:function(B,A){if(!YAHOO.lang.isString(B)){throw new YAHOO.util.UnexpectedValue(A||"Value should be a string.",B);}},isTypeOf:function(A,C,B){if(typeof C!=A){throw new YAHOO.util.ComparisonFailure(B||"Value should be of type "+expected+".",expected,typeof actual);}}};YAHOO.util.AssertionError=function(A){arguments.callee.superclass.constructor.call(this,A);this.message=A;this.name="AssertionError";};YAHOO.lang.extend(YAHOO.util.AssertionError,Error,{getMessage:function(){return this.message;},toString:function(){return this.name+": "+this.getMessage();},valueOf:function(){return this.toString();}});YAHOO.util.ComparisonFailure=function(B,A,C){arguments.callee.superclass.constructor.call(this,B);this.expected=A;this.actual=C;this.name="ComparisonFailure";};YAHOO.lang.extend(YAHOO.util.ComparisonFailure,YAHOO.util.AssertionError,{getMessage:function(){return this.message+"\nExpected: "+this.expected+" ("+(typeof this.expected)+")\nActual:"+this.actual+" ("+(typeof this.actual)+")";}});YAHOO.util.UnexpectedValue=function(B,A){arguments.callee.superclass.constructor.call(this,B);this.unexpected=A;this.name="UnexpectedValue";};YAHOO.lang.extend(YAHOO.util.UnexpectedValue,YAHOO.util.AssertionError,{getMessage:function(){return this.message+"\nUnexpected: "+this.unexpected+" ("+(typeof this.unexpected)+") ";}});YAHOO.util.ShouldFail=function(A){arguments.callee.superclass.constructor.call(this,A||"This test should fail but didn't.");this.name="ShouldFail";};YAHOO.lang.extend(YAHOO.util.ShouldFail,YAHOO.util.AssertionError);YAHOO.util.ShouldError=function(A){arguments.callee.superclass.constructor.call(this,A||"This test should have thrown an error but didn't.");this.name="ShouldError";};YAHOO.lang.extend(YAHOO.util.ShouldError,YAHOO.util.AssertionError);YAHOO.util.UnexpectedError=function(A){arguments.callee.superclass.constructor.call(this,"Unexpected error: "+A.message);this.cause=A;this.name="UnexpectedError";};YAHOO.lang.extend(YAHOO.util.UnexpectedError,YAHOO.util.AssertionError);YAHOO.util.ArrayAssert={contains:function(E,D,B){var C=false;for(var A=0;A<D.length&&!C;A++){if(D[A]===E){C=true;}}if(!C){YAHOO.util.Assert.fail(B||"Value ("+E+") not found in array.");}},containsItems:function(C,D,B){for(var A=0;A<C.length;A++){this.contains(C[A],D,B);}if(!found){YAHOO.util.Assert.fail(B||"Value not found in array.");}},containsMatch:function(E,D,B){if(typeof E!="function"){throw new TypeError("ArrayAssert.containsMatch(): First argument must be a function.");}var C=false;for(var A=0;A<D.length&&!C;A++){if(E(D[A])){C=true;}}if(!C){YAHOO.util.Assert.fail(B||"No match found in array.");}},doesNotContain:function(E,D,B){var C=false;for(var A=0;A<D.length&&!C;A++){if(D[A]===E){C=true;}}if(C){YAHOO.util.Assert.fail(B||"Value found in array.");}},doesNotContainItems:function(C,D,B){for(var A=0;A<C.length;A++){this.doesNotContain(C[A],D,B);}},doesNotContainMatch:function(E,D,B){if(typeof E!="function"){throw new TypeError("ArrayAssert.doesNotContainMatch(): First argument must be a function.");}var C=false;for(var A=0;A<D.length&&!C;A++){if(E(D[A])){C=true;
}}if(C){YAHOO.util.Assert.fail(B||"Value found in array.");}},indexOf:function(E,D,A,C){for(var B=0;B<D.length;B++){if(D[B]===E){YAHOO.util.Assert.areEqual(A,B,C||"Value exists at index "+B+" but should be at index "+A+".");return ;}}YAHOO.util.Assert.fail(C||"Value doesn't exist in array.");},itemsAreEqual:function(D,E,C){var A=Math.max(D.length,E.length);for(var B=0;B<A;B++){YAHOO.util.Assert.areEqual(D[B],E[B],C||"Values in position "+B+" are not equal.");}},itemsAreEquivalent:function(E,F,B,D){if(typeof B!="function"){throw new TypeError("ArrayAssert.itemsAreEquivalent(): Third argument must be a function.");}var A=Math.max(E.length,F.length);for(var C=0;C<A;C++){if(!B(E[C],F[C])){throw new YAHOO.util.ComparisonFailure(D||"Values in position "+C+" are not equivalent.",E[C],F[C]);}}},isEmpty:function(B,A){if(B.length>0){YAHOO.util.Assert.fail(A||"Array should be empty.");}},isNotEmpty:function(B,A){if(B.length===0){YAHOO.util.Assert.fail(A||"Array should not be empty.");}},itemsAreSame:function(D,E,C){var A=Math.max(D.length,E.length);for(var B=0;B<A;B++){YAHOO.util.Assert.areSame(D[B],E[B],C||"Values in position "+B+" are not the same.");}},lastIndexOf:function(E,D,A,C){for(var B=D.length;B>=0;B--){if(D[B]===E){YAHOO.util.Assert.areEqual(A,B,C||"Value exists at index "+B+" but should be at index "+A+".");return ;}}YAHOO.util.Assert.fail(C||"Value doesn't exist in array.");}};YAHOO.namespace("util");YAHOO.util.ObjectAssert={propertiesAreEqual:function(D,F,C){var B=[];for(var E in D){B.push(E);}for(var A=0;A<B.length;A++){YAHOO.util.Assert.isNotUndefined(F[B[A]],C||"Property'"+B[A]+"' expected.");}},hasProperty:function(A,B,C){if(YAHOO.lang.isUndefined(B[A])){YAHOO.util.Assert.fail(C||"Property "+A+" not found on object.");}},hasOwnProperty:function(A,B,C){if(!YAHOO.lang.hasOwnProperty(B,A)){YAHOO.util.Assert.fail(C||"Property "+A+" not found on object instance.");}}};YAHOO.util.DateAssert={datesAreEqual:function(B,C,A){if(B instanceof Date&&C instanceof Date){YAHOO.util.Assert.areEqual(B.getFullYear(),C.getFullYear(),A||"Years should be equal.");YAHOO.util.Assert.areEqual(B.getMonth(),C.getMonth(),A||"Months should be equal.");YAHOO.util.Assert.areEqual(B.getDate(),C.getDate(),A||"Day of month should be equal.");}else{throw new TypeError("DateAssert.datesAreEqual(): Expected and actual values must be Date objects.");}},timesAreEqual:function(B,C,A){if(B instanceof Date&&C instanceof Date){YAHOO.util.Assert.areEqual(B.getHours(),C.getHours(),A||"Hours should be equal.");YAHOO.util.Assert.areEqual(B.getMinutes(),C.getMinutes(),A||"Minutes should be equal.");YAHOO.util.Assert.areEqual(B.getSeconds(),C.getSeconds(),A||"Seconds should be equal.");}else{throw new TypeError("DateAssert.timesAreEqual(): Expected and actual values must be Date objects.");}}};YAHOO.namespace("util");YAHOO.util.UserAction={simulateKeyEvent:function(G,J,F,D,L,C,A,K,I,N,M){G=YAHOO.util.Dom.get(G);if(!G){throw new Error("simulateKeyEvent(): Invalid target.");}if(YAHOO.lang.isString(J)){J=J.toLowerCase();switch(J){case"keyup":case"keydown":case"keypress":break;case"textevent":J="keypress";break;default:throw new Error("simulateKeyEvent(): Event type '"+J+"' not supported.");}}else{throw new Error("simulateKeyEvent(): Event type must be a string.");}if(!YAHOO.lang.isBoolean(F)){F=true;}if(!YAHOO.lang.isBoolean(D)){D=true;}if(!YAHOO.lang.isObject(L)){L=window;}if(!YAHOO.lang.isBoolean(C)){C=false;}if(!YAHOO.lang.isBoolean(A)){A=false;}if(!YAHOO.lang.isBoolean(K)){K=false;}if(!YAHOO.lang.isBoolean(I)){I=false;}if(!YAHOO.lang.isNumber(N)){N=0;}if(!YAHOO.lang.isNumber(M)){M=0;}if(YAHOO.lang.isFunction(document.createEvent)){var B=null;try{B=document.createEvent("KeyEvents");B.initKeyEvent(J,F,D,L,C,A,K,I,N,M);}catch(H){try{B=document.createEvent("Events");}catch(E){B=document.createEvent("UIEvents");}finally{B.initEvent(J,F,D);B.view=L;B.altKey=A;B.ctrlKey=C;B.shiftKey=K;B.metaKey=I;B.keyCode=N;B.charCode=M;}}G.dispatchEvent(B);}else{if(YAHOO.lang.isObject(document.createEventObject)){B=document.createEventObject();B.bubbles=F;B.cancelable=D;B.view=L;B.ctrlKey=C;B.altKey=A;B.shiftKey=K;B.metaKey=I;B.keyCode=(M>0)?M:N;G.fireEvent("on"+J,B);}else{throw new Error("simulateKeyEvent(): No event simulation framework present.");}}},simulateMouseEvent:function(L,P,I,F,Q,K,H,G,E,C,D,A,O,N,J,M){L=YAHOO.util.Dom.get(L);if(!L){throw new Error("simulateMouseEvent(): Invalid target.");}if(YAHOO.lang.isString(P)){P=P.toLowerCase();switch(P){case"mouseover":case"mouseout":case"mousedown":case"mouseup":case"click":case"dblclick":case"mousemove":break;default:throw new Error("simulateMouseEvent(): Event type '"+P+"' not supported.");}}else{throw new Error("simulateMouseEvent(): Event type must be a string.");}if(!YAHOO.lang.isBoolean(I)){I=true;}if(!YAHOO.lang.isBoolean(F)){F=(P!="mousemove");}if(!YAHOO.lang.isObject(Q)){Q=window;}if(!YAHOO.lang.isNumber(K)){K=1;}if(!YAHOO.lang.isNumber(H)){H=0;}if(!YAHOO.lang.isNumber(G)){G=0;}if(!YAHOO.lang.isNumber(E)){E=0;}if(!YAHOO.lang.isNumber(C)){C=0;}if(!YAHOO.lang.isBoolean(D)){D=false;}if(!YAHOO.lang.isBoolean(A)){A=false;}if(!YAHOO.lang.isBoolean(O)){O=false;}if(!YAHOO.lang.isBoolean(N)){N=false;}if(!YAHOO.lang.isNumber(J)){J=0;}if(YAHOO.lang.isFunction(document.createEvent)){var B=document.createEvent("MouseEvents");if(B.initMouseEvent){B.initMouseEvent(P,I,F,Q,K,H,G,E,C,D,A,O,N,J,M);}else{B=document.createEvent("UIEvents");B.initEvent(P,I,F);B.view=Q;B.detail=K;B.screenX=H;B.screenY=G;B.clientX=E;B.clientY=C;B.ctrlKey=D;B.altKey=A;B.metaKey=N;B.shiftKey=O;B.button=J;B.relatedTarget=M;}if(M&&!B.relatedTarget){if(P=="mouseout"){B.toElement=M;}else{if(P=="mouseover"){B.fromElement=M;}}}L.dispatchEvent(B);}else{if(YAHOO.lang.isObject(document.createEventObject)){B=document.createEventObject();B.bubbles=I;B.cancelable=F;B.view=Q;B.detail=K;B.screenX=H;B.screenY=G;B.clientX=E;B.clientY=C;B.ctrlKey=D;B.altKey=A;B.metaKey=N;B.shiftKey=O;switch(J){case 0:B.button=1;break;case 1:B.button=4;break;case 2:break;
default:B.button=0;}B.relatedTarget=M;L.fireEvent("on"+P,B);}else{throw new Error("simulateMouseEvent(): No event simulation framework present.");}}},fireMouseEvent:function(C,B,A){A=A||{};this.simulateMouseEvent(C,B,A.bubbles,A.cancelable,A.view,A.detail,A.screenX,A.screenY,A.clientX,A.clientY,A.ctrlKey,A.altKey,A.shiftKey,A.metaKey,A.button,A.relatedTarget);},click:function(B,A){this.fireMouseEvent(B,"click",A);},dblclick:function(B,A){this.fireMouseEvent(B,"dblclick",A);},mousedown:function(B,A){this.fireMouseEvent(B,"mousedown",A);},mousemove:function(B,A){this.fireMouseEvent(B,"mousemove",A);},mouseout:function(B,A){this.fireMouseEvent(B,"mouseout",A);},mouseover:function(B,A){this.fireMouseEvent(B,"mouseover",A);},mouseup:function(B,A){this.fireMouseEvent(B,"mouseup",A);},fireKeyEvent:function(B,C,A){A=A||{};this.simulateKeyEvent(C,B,A.bubbles,A.cancelable,A.view,A.ctrlKey,A.altKey,A.shiftKey,A.metaKey,A.keyCode,A.charCode);},keydown:function(B,A){this.fireKeyEvent("keydown",B,A);},keypress:function(B,A){this.fireKeyEvent("keypress",B,A);},keyup:function(B,A){this.fireKeyEvent("keyup",B,A);}};YAHOO.namespace("tool");YAHOO.tool.TestManager={TEST_PAGE_BEGIN_EVENT:"testpagebegin",TEST_PAGE_COMPLETE_EVENT:"testpagecomplete",TEST_MANAGER_BEGIN_EVENT:"testmanagerbegin",TEST_MANAGER_COMPLETE_EVENT:"testmanagercomplete",_curPage:null,_frame:null,_logger:null,_timeoutId:0,_pages:[],_results:null,_handleTestRunnerComplete:function(A){this.fireEvent(this.TEST_PAGE_COMPLETE_EVENT,{page:this._curPage,results:A.results});this._processResults(this._curPage,A.results);this._logger.clearTestRunner();if(this._pages.length){this._timeoutId=setTimeout(function(){YAHOO.tool.TestManager._run();},1000);}},_processResults:function(C,A){var B=this._results;B.page_results[C]=A;if(A.passed){B.pages_passed++;B.tests_passed+=A.passed;}if(A.failed){B.pages_failed++;B.tests_failed+=A.failed;B.failed.push(C);}else{B.passed.push(C);}if(!this._pages.length){this.fireEvent(this.TEST_MANAGER_COMPLETE_EVENT,this._results);}},_run:function(){this._curPage=this._pages.shift();this.fireEvent(this.TEST_PAGE_BEGIN_EVENT,this._curPage);this._frame.location.replace(this._curPage);},load:function(){if(parent.YAHOO.tool.TestManager!==this){parent.YAHOO.tool.TestManager.load();}else{if(this._frame){var A=this._frame.YAHOO.tool.TestRunner;this._logger.setTestRunner(A);A.subscribe(A.COMPLETE_EVENT,this._handleTestRunnerComplete,this,true);A.run();}}},setPages:function(A){this._pages=A;},start:function(){if(!this._initialized){this.createEvent(this.TEST_PAGE_BEGIN_EVENT);this.createEvent(this.TEST_PAGE_COMPLETE_EVENT);this.createEvent(this.TEST_MANAGER_BEGIN_EVENT);this.createEvent(this.TEST_MANAGER_COMPLETE_EVENT);if(!this._frame){var A=document.createElement("iframe");A.style.visibility="hidden";A.style.position="absolute";document.body.appendChild(A);this._frame=A.contentWindow||A.contentDocument.ownerWindow;}if(!this._logger){this._logger=new YAHOO.tool.TestLogger();}this._initialized=true;}this._results={pages_passed:0,pages_failed:0,tests_passed:0,tests_failed:0,passed:[],failed:[],page_results:{}};this.fireEvent(this.TEST_MANAGER_BEGIN_EVENT,null);this._run();},stop:function(){clearTimeout(this._timeoutId);}};YAHOO.lang.augmentObject(YAHOO.tool.TestManager,YAHOO.util.EventProvider.prototype);YAHOO.register("yuitest",YAHOO.tool.TestRunner,{version:"2.3.1",build:"541"});