/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.core.StreamsProcessor;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathFilter
implements StreamsProcessor {
    private static final String STREAMS_ID = "JsonPathFilter";
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPathFilter.class);
    private ObjectMapper mapper = new StreamsJacksonMapper();
    private String pathExpression;
    private JsonPath jsonPath;
    private String destNodeName;

    public JsonPathFilter() {
        LOGGER.info("creating JsonPathFilter");
    }

    public JsonPathFilter(String pathExpression) {
        this.pathExpression = pathExpression;
        LOGGER.info("creating JsonPathFilter for " + this.pathExpression);
    }

    public List<StreamsDatum> process(StreamsDatum entry) {
        ObjectNode document;
        ArrayList result;
        block23: {
            result = Lists.newArrayList();
            String json = null;
            document = null;
            LOGGER.debug("{} processing {}", (Object)STREAMS_ID);
            if (entry.getDocument() instanceof ObjectNode) {
                document = (ObjectNode)entry.getDocument();
                try {
                    json = this.mapper.writeValueAsString((Object)document);
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
            } else if (entry.getDocument() instanceof String) {
                json = (String)entry.getDocument();
                try {
                    document = (ObjectNode)this.mapper.readValue(json, ObjectNode.class);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            Preconditions.checkNotNull((Object)document);
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                Object srcResult = null;
                try {
                    srcResult = this.jsonPath.read(json);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.warn(e.getMessage());
                }
                Preconditions.checkNotNull((Object)srcResult);
                String[] path = StringUtils.split((String)this.pathExpression, (char)'.');
                ObjectNode node = document;
                for (int i = 1; i < path.length - 1; ++i) {
                    node = (ObjectNode)document.get(path[i]);
                }
                Preconditions.checkNotNull((Object)node);
                if (srcResult instanceof JSONArray) {
                    try {
                        ArrayNode jsonNode = (ArrayNode)this.mapper.convertValue(srcResult, ArrayNode.class);
                        if (jsonNode.size() == 1) {
                            JsonNode item = jsonNode.get(0);
                            node.set(this.destNodeName, item);
                            break block23;
                        }
                        node.set(this.destNodeName, (JsonNode)jsonNode);
                    }
                    catch (Exception e) {
                        LOGGER.warn(e.getMessage());
                    }
                } else if (srcResult instanceof JSONObject) {
                    try {
                        ObjectNode jsonNode = (ObjectNode)this.mapper.convertValue(srcResult, ObjectNode.class);
                        node.set(this.destNodeName, (JsonNode)jsonNode);
                    }
                    catch (Exception e) {
                        LOGGER.warn(e.getMessage());
                    }
                } else if (srcResult instanceof String) {
                    try {
                        node.put(this.destNodeName, (String)srcResult);
                    }
                    catch (Exception e) {
                        LOGGER.warn(e.getMessage());
                    }
                }
            }
        }
        result.add(new StreamsDatum((Object)document));
        return result;
    }

    public void prepare(Object configurationObject) {
        if (configurationObject instanceof Map) {
            Map params = (Map)configurationObject;
            this.pathExpression = (String)params.get("pathExpression");
            this.jsonPath = JsonPath.compile((String)this.pathExpression, (Filter[])new Filter[0]);
            this.destNodeName = this.pathExpression.substring(this.pathExpression.lastIndexOf(".") + 1);
        }
        this.mapper.registerModule((Module)new JsonOrgModule());
    }

    public void cleanUp() {
        LOGGER.info("shutting down JsonPathFilter for " + this.pathExpression);
    }
}

