/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.data;

import com.moreover.api.Article;
import com.moreover.api.ArticlesResponse;
import com.moreover.api.ObjectFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.SerializationException;
import org.apache.streams.data.ActivitySerializer;
import org.apache.streams.data.util.MoreoverUtils;
import org.apache.streams.pojo.json.Activity;

public class MoreoverXmlActivitySerializer
implements ActivitySerializer<String> {
    private final JAXBContext articleContext = this.createContext(Article.class);
    private final JAXBContext articlesContext = this.createContext(ArticlesResponse.class);

    public String serializationFormat() {
        return "application/xml+vnd.moreover.com.v1";
    }

    public String serialize(Activity deserialized) {
        throw new UnsupportedOperationException("Cannot currently serialize to Moreover");
    }

    public Activity deserialize(String serialized) {
        Article article = this.deserializeMoreover(serialized);
        return MoreoverUtils.convert(article);
    }

    public List<Activity> deserializeAll(List<String> serializedList) {
        LinkedList<Activity> activities = new LinkedList<Activity>();
        for (String item : serializedList) {
            ArticlesResponse response = this.deserializeMoreoverResponse(item);
            for (Article article : response.getArticles().getArticle()) {
                activities.add(MoreoverUtils.convert(article));
            }
        }
        return activities;
    }

    private Article deserializeMoreover(String serialized) {
        try {
            Unmarshaller unmarshaller = this.articleContext.createUnmarshaller();
            return (Article)unmarshaller.unmarshal((Reader)new StringReader(serialized));
        }
        catch (JAXBException e) {
            throw new SerializationException("Unable to deserialize Moreover data", (Throwable)e);
        }
    }

    private ArticlesResponse deserializeMoreoverResponse(String serialized) {
        try {
            Unmarshaller unmarshaller = this.articlesContext.createUnmarshaller();
            return (ArticlesResponse)((JAXBElement)unmarshaller.unmarshal((Reader)new StringReader(serialized))).getValue();
        }
        catch (JAXBException e) {
            throw new SerializationException("Unable to deserialize Moreover data", (Throwable)e);
        }
    }

    private JAXBContext createContext(Class articleClass) {
        JAXBContext context;
        try {
            context = JAXBContext.newInstance((String)articleClass.getPackage().getName(), (ClassLoader)ObjectFactory.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unable to create JAXB Context for Moreover data", e);
        }
        return context;
    }
}

