/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.data.util;

import com.moreover.api.Article;
import com.moreover.api.Author;
import com.moreover.api.AuthorPublishingPlatform;
import com.moreover.api.Feed;
import com.moreover.api.Source;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.streams.data.util.ActivityUtil;
import org.apache.streams.pojo.extensions.ExtensionUtil;
import org.apache.streams.pojo.json.Activity;
import org.apache.streams.pojo.json.ActivityObject;
import org.apache.streams.pojo.json.Actor;
import org.apache.streams.pojo.json.Provider;
import org.joda.time.DateTime;

public class MoreoverUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    private MoreoverUtils() {
    }

    public static Activity convert(Article article) {
        Activity activity = new Activity();
        Source source = article.getSource();
        activity.setActor(MoreoverUtils.convert(article.getAuthor(), source.getName()));
        activity.setProvider(MoreoverUtils.convert(source));
        activity.setTarget(MoreoverUtils.convertTarget(source));
        activity.setObject(MoreoverUtils.convertObject(article));
        activity.setPublished(DateTime.parse((String)article.getPublishedDate()));
        activity.setContent(article.getContent());
        activity.setTitle(article.getTitle());
        activity.setVerb("posted");
        MoreoverUtils.fixActivityId(activity);
        MoreoverUtils.addLocationExtension(activity, source);
        MoreoverUtils.addLanguageExtension(activity, article);
        activity.setLinks(MoreoverUtils.convertLinks(article));
        return activity;
    }

    private static void fixActivityId(Activity activity) {
        if (activity.getId() != null && activity.getId().matches("\\{[a-z]*\\}")) {
            activity.setId(null);
        }
    }

    private static List convertLinks(Article article) {
        LinkedList<String> list = new LinkedList<String>();
        Article.OutboundUrls outboundUrls = article.getOutboundUrls();
        if (outboundUrls != null) {
            for (String url : outboundUrls.getOutboundUrl()) {
                list.add(url);
            }
        }
        return list;
    }

    public static ActivityObject convertTarget(Source source) {
        ActivityObject object = new ActivityObject();
        object.setUrl(source.getHomeUrl());
        object.setDisplayName(source.getName());
        return object;
    }

    public static ActivityObject convertObject(Article article) {
        ActivityObject object = new ActivityObject();
        object.setContent(article.getContent());
        object.setSummary(article.getTitle());
        object.setUrl(article.getOriginalUrl());
        object.setObjectType(article.getDataFormat());
        String type = article.getDataFormat().equals("text") ? "article" : article.getDataFormat();
        object.setId(ActivityUtil.getObjectId((String)MoreoverUtils.getProviderID(article.getSource().getFeed()), (String)type, (String)article.getId()));
        object.setPublished(DateTime.parse((String)article.getPublishedDate()));
        return object;
    }

    public static Provider convert(Source source) {
        Provider provider = new Provider();
        Feed feed = source.getFeed();
        String display = MoreoverUtils.getProviderID(feed);
        provider.setId(ActivityUtil.getProviderId((String)display.trim().toLowerCase().replace(" ", "_")));
        provider.setDisplayName(display);
        provider.setUrl(feed.getUrl());
        return provider;
    }

    public static Actor convert(Author author, String platformName) {
        Actor actor = new Actor();
        AuthorPublishingPlatform platform = author.getPublishingPlatform();
        String userId = platform.getUserId();
        if (userId != null) {
            actor.setId(ActivityUtil.getPersonId((String)MoreoverUtils.getProviderID(platformName), (String)userId));
        }
        actor.setDisplayName(author.getName());
        actor.setUrl(author.getHomeUrl());
        actor.setSummary(author.getDescription());
        actor.setAdditionalProperty("email", (Object)author.getEmail());
        return actor;
    }

    public static void addLocationExtension(Activity activity, Source value) {
        String country;
        Map extensions = ExtensionUtil.ensureExtensions((Activity)activity);
        String string = country = value.getLocation().getCountryCode() == null ? value.getLocation().getCountry() : value.getLocation().getCountryCode();
        if (country != null) {
            HashMap<String, String> location = new HashMap<String, String>();
            location.put("country", country);
            extensions.put("location", location);
        }
    }

    public static void addLanguageExtension(Activity activity, Article value) {
        Map extensions = ExtensionUtil.ensureExtensions((Activity)activity);
        String language = value.getLanguage();
        if (language != null) {
            extensions.put("language", language);
        }
    }

    public static Date parse(String str) {
        SimpleDateFormat fmt = new SimpleDateFormat(DATE_FORMAT);
        try {
            return fmt.parse(str);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid date format", e);
        }
    }

    private static String getProviderID(Feed feed) {
        return MoreoverUtils.getProviderID(feed.getPublishingPlatform() == null ? feed.getMediaType() : feed.getPublishingPlatform());
    }

    private static String getProviderID(String feed) {
        return feed.toLowerCase().replace(" ", "_").trim();
    }
}

