/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.annotations.taglib.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.annotations.taglib.apt.Tag;
import org.apache.struts.annotations.taglib.apt.TagAttribute;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagAnnotationProcessor
implements AnnotationProcessor {
    public static final String TAG = "org.apache.struts2.views.annotations.StrutsTag";
    public static final String TAG_ATTRIBUTE = "org.apache.struts2.views.annotations.StrutsTagAttribute";
    public static final String TAG_SKIP_HIERARCHY = "org.apache.struts2.views.annotations.StrutsTagSkipInheritance";
    private AnnotationProcessorEnvironment environment;
    private AnnotationTypeDeclaration tagDeclaration;
    private AnnotationTypeDeclaration tagAttributeDeclaration;
    private AnnotationTypeDeclaration skipDeclaration;
    private Map<String, Tag> tags = new TreeMap<String, Tag>();

    public TagAnnotationProcessor(AnnotationProcessorEnvironment env) {
        this.environment = env;
        this.tagDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(TAG);
        this.tagAttributeDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(TAG_ATTRIBUTE);
        this.skipDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(TAG_SKIP_HIERARCHY);
    }

    public void process() {
        MethodDeclaration methodDeclaration;
        Map<String, Object> values;
        String typeName;
        this.checkOptions();
        Collection tagDeclarations = this.environment.getDeclarationsAnnotatedWith(this.tagDeclaration);
        Collection attributesDeclarations = this.environment.getDeclarationsAnnotatedWith(this.tagAttributeDeclaration);
        Collection skipDeclarations = this.environment.getDeclarationsAnnotatedWith(this.skipDeclaration);
        for (Declaration declaration : tagDeclarations) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)declaration;
            typeName = typeDeclaration.getQualifiedName();
            values = this.getValues((Declaration)typeDeclaration, this.tagDeclaration);
            Tag tag = new Tag();
            tag.setDescription((String)values.get("description"));
            tag.setName((String)values.get("name"));
            tag.setTldBodyContent((String)values.get("tldBodyContent"));
            tag.setTldTagClass((String)values.get("tldTagClass"));
            tag.setDeclaredType(typeName);
            tag.setAllowDynamicAttributes((Boolean)values.get("allowDynamicAttributes"));
            this.tags.put(typeName, tag);
        }
        for (Declaration declaration : skipDeclarations) {
            if (!(declaration instanceof MethodDeclaration)) continue;
            methodDeclaration = (MethodDeclaration)declaration;
            typeName = methodDeclaration.getDeclaringType().getQualifiedName();
            String methodName = methodDeclaration.getSimpleName();
            String name = String.valueOf(Character.toLowerCase(methodName.charAt(3))) + methodName.substring(4);
            Tag tag = this.tags.get(typeName);
            if (tag == null) continue;
            this.tags.get(typeName).addSkipAttribute(name);
        }
        for (Declaration declaration : attributesDeclarations) {
            methodDeclaration = (MethodDeclaration)declaration;
            typeName = methodDeclaration.getDeclaringType().getQualifiedName();
            values = this.getValues((Declaration)methodDeclaration, this.tagAttributeDeclaration);
            TagAttribute attribute = new TagAttribute();
            String name = (String)values.get("name");
            if (name == null || name.length() == 0) {
                String methodName = methodDeclaration.getSimpleName();
                name = String.valueOf(Character.toLowerCase(methodName.charAt(3))) + methodName.substring(4);
            }
            values.put("name", name);
            this.populateTagAttributes(attribute, values);
            Tag parentTag = this.tags.get(typeName);
            if (parentTag != null) {
                this.tags.get(typeName).addTagAttribute(attribute);
                continue;
            }
            parentTag = new Tag();
            parentTag.setDeclaredType(typeName);
            parentTag.setInclude(false);
            parentTag.addTagAttribute(attribute);
            this.tags.put(typeName, parentTag);
        }
        for (Map.Entry entry : this.tags.entrySet()) {
            this.processHierarchy((Tag)entry.getValue());
        }
        this.saveAsXml();
        this.saveTemplates();
    }

    private void populateTagAttributes(TagAttribute attribute, Map<String, Object> values) {
        attribute.setRequired((Boolean)values.get("required"));
        attribute.setRtexprvalue((Boolean)values.get("rtexprvalue"));
        attribute.setDefaultValue((String)values.get("defaultValue"));
        attribute.setType((String)values.get("type"));
        attribute.setDescription((String)values.get("description"));
        attribute.setName((String)values.get("name"));
    }

    private void processHierarchy(Tag tag) {
        try {
            Class<?> clazz = Class.forName(tag.getDeclaredType());
            List<String> skipAttributes = tag.getSkipAttributes();
            while (this.getAnnotation(TAG_SKIP_HIERARCHY, clazz.getAnnotations()) == null && (clazz = clazz.getSuperclass()) != null) {
                Tag parentTag = this.tags.get(clazz.getName());
                if (parentTag != null) {
                    for (TagAttribute attribute : parentTag.getAttributes()) {
                        if (skipAttributes.contains(attribute.getName())) continue;
                        tag.addTagAttribute(attribute);
                    }
                    continue;
                }
                this.addTagAttributesFromParent(tag, clazz);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addTagAttributesFromParent(Tag tag, Class clazz) throws ClassNotFoundException {
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            List<String> skipAttributes = tag.getSkipAttributes();
            for (int i = 0; i < props.length; ++i) {
                Annotation annotation;
                PropertyDescriptor prop = props[i];
                Method writeMethod = prop.getWriteMethod();
                if (writeMethod == null || !Modifier.isPublic(writeMethod.getModifiers()) || (annotation = this.getAnnotation(TAG_ATTRIBUTE, writeMethod.getAnnotations())) == null || skipAttributes.contains(prop.getName())) continue;
                Map<String, Object> values = this.getValues(annotation);
                TagAttribute attribute = new TagAttribute();
                values.put("name", prop.getName());
                this.populateTagAttributes(attribute, values);
                tag.addTagAttribute(attribute);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Annotation getAnnotation(String typeName, Annotation[] annotations) {
        for (int i = 0; i < annotations.length; ++i) {
            if (!annotations[i].annotationType().getName().equals(typeName)) continue;
            return annotations[i];
        }
        return null;
    }

    private void checkOptions() {
        if (this.getOption("tlibVersion") == null) {
            throw new IllegalArgumentException("'tlibVersion' is missing");
        }
        if (this.getOption("jspVersion") == null) {
            throw new IllegalArgumentException("'jspVersion' is missing");
        }
        if (this.getOption("shortName") == null) {
            throw new IllegalArgumentException("'shortName' is missing");
        }
        if (this.getOption("description") == null) {
            throw new IllegalArgumentException("'description' is missing");
        }
        if (this.getOption("displayName") == null) {
            throw new IllegalArgumentException("'displayName' is missing");
        }
        if (this.getOption("uri") == null) {
            throw new IllegalArgumentException("'uri' is missing");
        }
        if (this.getOption("outTemplatesDir") == null) {
            throw new IllegalArgumentException("'outTemplatesDir' is missing");
        }
        if (this.getOption("outFile") == null) {
            throw new IllegalArgumentException("'outFile' is missing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTemplates() {
        Configuration config = new Configuration();
        config.setClassForTemplateLoading(this.getClass(), "");
        config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        try {
            Template template = config.getTemplate("tag.ftl");
            String rootDir = new File(this.getOption("outTemplatesDir")).getAbsolutePath();
            for (Tag tag : this.tags.values()) {
                if (!tag.isInclude()) continue;
                HashMap<String, Tag> root = new HashMap<String, Tag>();
                root.put("tag", tag);
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(rootDir, tag.getName() + ".html")));
                try {
                    template.process(root, (Writer)writer);
                }
                finally {
                    writer.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void saveAsXml() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            document.setXmlVersion("1.0");
            Element tagLib = document.createElement("taglib");
            tagLib.setAttribute("xmlns", "http://java.sun.com/xml/ns/j2ee");
            tagLib.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            tagLib.setAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-jsptaglibrary_2_0.xsd");
            tagLib.setAttribute("version", this.getOption("jspVersion"));
            document.appendChild(tagLib);
            this.appendTextNode(document, tagLib, "tlib-version", this.getOption("tlibVersion"), false);
            this.appendTextNode(document, tagLib, "short-name", this.getOption("shortName"), false);
            this.appendTextNode(document, tagLib, "uri", this.getOption("uri"), false);
            this.appendTextNode(document, tagLib, "display-name", this.getOption("displayName"), false);
            this.appendTextNode(document, tagLib, "description", this.getOption("description"), true);
            for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
                Tag tag = entry.getValue();
                if (!tag.isInclude()) continue;
                this.createElement(document, tagLib, tag);
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("indent-number", 2);
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new OutputStreamWriter(new FileOutputStream(this.getOption("outFile"))));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getOption(String name) {
        if (this.environment.getOptions().containsKey(name)) {
            return (String)this.environment.getOptions().get(name);
        }
        for (Map.Entry entry : this.environment.getOptions().entrySet()) {
            String key = (String)entry.getKey();
            String[] splitted = key.split("=");
            if (!splitted[0].equals("-A" + name)) continue;
            return splitted[1];
        }
        return null;
    }

    private void createElement(Document doc, Element tagLibElement, Tag tag) {
        Element tagElement = doc.createElement("tag");
        tagLibElement.appendChild(tagElement);
        this.appendTextNode(doc, tagElement, "name", tag.getName(), false);
        this.appendTextNode(doc, tagElement, "tag-class", tag.getTldTagClass(), false);
        this.appendTextNode(doc, tagElement, "body-content", tag.getTldBodyContent(), false);
        this.appendTextNode(doc, tagElement, "description", tag.getDescription(), true);
        for (TagAttribute attribute : tag.getAttributes()) {
            this.createElement(doc, tagElement, attribute);
        }
        this.appendTextNode(doc, tagElement, "dynamic-attributes", String.valueOf(tag.isAllowDynamicAttributes()), false);
    }

    private void createElement(Document doc, Element tagElement, TagAttribute attribute) {
        Element attributeElement = doc.createElement("attribute");
        tagElement.appendChild(attributeElement);
        this.appendTextNode(doc, attributeElement, "name", attribute.getName(), false);
        this.appendTextNode(doc, attributeElement, "required", String.valueOf(attribute.isRequired()), false);
        this.appendTextNode(doc, attributeElement, "rtexprvalue", String.valueOf(attribute.isRtexprvalue()), false);
        this.appendTextNode(doc, attributeElement, "description", attribute.getDescription(), true);
    }

    private void appendTextNode(Document doc, Element element, String name, String text, boolean cdata) {
        Text textNode = cdata ? doc.createCDATASection(text) : doc.createTextNode(text);
        Element newElement = doc.createElement(name);
        newElement.appendChild(textNode);
        element.appendChild(newElement);
    }

    private Map<String, Object> getValues(Declaration declaration, AnnotationTypeDeclaration type) {
        TreeMap<String, Object> values = new TreeMap<String, Object>();
        Collection annotations = declaration.getAnnotationMirrors();
        for (AnnotationMirror mirror : annotations) {
            if (!mirror.getAnnotationType().getDeclaration().equals(type)) continue;
            for (AnnotationTypeElementDeclaration annotationType : mirror.getElementValues().keySet()) {
                Object value = ((AnnotationValue)mirror.getElementValues().get(annotationType)).getValue();
                AnnotationValue defaultValue = annotationType.getDefaultValue();
                values.put(annotationType.getSimpleName(), value != null ? value : defaultValue);
            }
        }
        for (AnnotationTypeElementDeclaration annotationType : type.getMethods()) {
            String name;
            AnnotationValue value = annotationType.getDefaultValue();
            if (value == null || values.containsKey(name = annotationType.getSimpleName())) continue;
            values.put(name, value.getValue());
        }
        return values;
    }

    private Map<String, Object> getValues(Annotation annotation) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        TreeMap<String, Object> values = new TreeMap<String, Object>();
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Method[] methods = annotationType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method == null || method.getParameterTypes().length != 0) continue;
            Object value = method.invoke((Object)annotation, new Object[0]);
            values.put(method.getName(), value);
        }
        return values;
    }
}

