/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.rest;

import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.rest.ContentTypeHandlerManager;
import org.apache.struts2.rest.HttpHeaders;
import org.apache.struts2.rest.handler.ContentTypeHandler;

public class DefaultContentTypeHandlerManager
implements ContentTypeHandlerManager {
    Map<String, ContentTypeHandler> handlersByExtension = new HashMap<String, ContentTypeHandler>();
    Map<String, ContentTypeHandler> handlersByContentType = new HashMap<String, ContentTypeHandler>();
    String defaultExtension;

    @Inject(value="struts.rest.defaultExtension")
    public void setDefaultExtension(String name) {
        this.defaultExtension = name;
    }

    @Inject
    public void setContainer(Container container) {
        Set names = container.getInstanceNames(ContentTypeHandler.class);
        for (String name : names) {
            ContentTypeHandler handler = (ContentTypeHandler)container.getInstance(ContentTypeHandler.class, name);
            if (handler.getExtension() != null) {
                String overrideName = (String)container.getInstance(String.class, "struts.rest.handlerOverride." + handler.getExtension());
                if (overrideName != null) {
                    if (this.handlersByExtension.containsKey(handler.getExtension())) continue;
                    handler = (ContentTypeHandler)container.getInstance(ContentTypeHandler.class, overrideName);
                }
                this.handlersByExtension.put(handler.getExtension(), handler);
            }
            if (handler.getContentType() == null) continue;
            this.handlersByContentType.put(handler.getContentType(), handler);
        }
    }

    public ContentTypeHandler getHandlerForRequest(HttpServletRequest req) {
        ContentTypeHandler handler = null;
        String contentType = req.getContentType();
        if (contentType != null) {
            handler = this.handlersByContentType.get(contentType);
        }
        if (handler == null) {
            String extension = this.findExtension(req.getRequestURI());
            if (extension == null) {
                extension = this.defaultExtension;
            }
            handler = this.handlersByExtension.get(extension);
        }
        return handler;
    }

    public ContentTypeHandler getHandlerForResponse(HttpServletRequest req, HttpServletResponse res) {
        String extension = this.findExtension(req.getRequestURI());
        if (extension == null) {
            extension = this.defaultExtension;
        }
        return this.handlersByExtension.get(extension);
    }

    public String handleResult(ActionConfig actionConfig, Object methodResult, Object target) throws IOException {
        ContentTypeHandler handler;
        String resultCode = null;
        HttpServletRequest req = ServletActionContext.getRequest();
        HttpServletResponse res = ServletActionContext.getResponse();
        if (target instanceof ModelDriven) {
            target = ((ModelDriven)target).getModel();
        }
        boolean statusNotOk = false;
        if (methodResult instanceof HttpHeaders) {
            HttpHeaders info = (HttpHeaders)methodResult;
            resultCode = info.apply(req, res, target);
            if (info.getStatus() != 200) {
                if (info.getStatus() == 304) {
                    target = null;
                } else {
                    statusNotOk = true;
                }
            }
        } else {
            resultCode = (String)methodResult;
        }
        if (!statusNotOk && !"get".equalsIgnoreCase(req.getMethod())) {
            target = null;
        }
        if ((handler = this.getHandlerForResponse(req, res)) != null) {
            String extCode = resultCode + "-" + handler.getExtension();
            if (actionConfig.getResults().get(extCode) != null) {
                resultCode = extCode;
            } else {
                StringWriter writer = new StringWriter();
                resultCode = handler.fromObject(target, resultCode, writer);
                String text = writer.toString();
                if (text.length() > 0) {
                    byte[] data = text.getBytes("UTF-8");
                    res.setContentLength(data.length);
                    res.setContentType(handler.getContentType());
                    res.getOutputStream().write(data);
                    res.getOutputStream().close();
                }
            }
        }
        return resultCode;
    }

    protected String findExtension(String url) {
        int slashPos;
        int dotPos = url.lastIndexOf(46);
        if (dotPos > (slashPos = url.lastIndexOf(47)) && dotPos > -1) {
            return url.substring(dotPos + 1);
        }
        return null;
    }
}

